/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRefUtil {
    private static final Logger LOG = Logger.getInstance(GitRefUtil.class);
    private static final Pattern BRANCH_PATTERN = Pattern.compile(" *(?:ref:)? */?((?:refs/heads/|refs/remotes/)?\\S+)");

    @Nullable
    public static String addRefsHeadsPrefixIfNeeded(@Nullable String branchName) {
        if (branchName != null && !branchName.startsWith("refs/heads/")) {
            return "refs/heads/" + branchName;
        }
        return branchName;
    }

    @Nullable
    public static Pair<String, String> parseRefsLine(@NotNull String line) {
        int i2;
        if (line == null) {
            GitRefUtil.$$$reportNull$$$0(0);
        }
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i2 = 0; i2 < line.length(); ++i2) {
            char c = line.charAt(i2);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i2);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i2;
        if (start < line.length() && Character.isWhitespace(line.charAt(start++))) {
            char c;
            for (i2 = start; i2 < line.length() && !Character.isWhitespace(c = line.charAt(i2)); ++i2) {
            }
            branch = line.substring(start, i2);
        }
        if (branch == null || !branch.startsWith("refs/heads/") && !branch.startsWith("refs/remotes/")) {
            return null;
        }
        return Pair.create((Object)GitRefUtil.shortBuffer(branch), (Object)GitRefUtil.shortBuffer(hash.trim()));
    }

    @NotNull
    private static String shortBuffer(String raw) {
        return new String(raw);
    }

    @NotNull
    static Map<String, Hash> resolveRefs(@NotNull Map<String, String> data) {
        if (data == null) {
            GitRefUtil.$$$reportNull$$$0(1);
        }
        Map<String, Hash> resolved = GitRefUtil.getResolvedHashes(data);
        Map unresolved = ContainerUtil.filter(data, refName -> !resolved.containsKey(refName));
        boolean progressed = true;
        while (progressed && !unresolved.isEmpty()) {
            progressed = false;
            Iterator iterator = unresolved.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String refName2 = (String)entry.getKey();
                String refValue = (String)entry.getValue();
                String link = GitRefUtil.getTarget(refValue);
                if (link != null) {
                    if (GitRefUtil.duplicateEntry(resolved, refName2, refValue)) {
                        iterator.remove();
                        continue;
                    }
                    if (!resolved.containsKey(link)) {
                        LOG.debug("Unresolved symbolic link [" + refName2 + "] pointing to [" + refValue + "]");
                        continue;
                    }
                    Hash targetValue = resolved.get(link);
                    resolved.put(refName2, targetValue);
                    iterator.remove();
                    progressed = true;
                    continue;
                }
                LOG.warn("Unexpected record [" + refName2 + "] -> [" + refValue + "]");
                iterator.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            LOG.warn("Cyclic symbolic links among .git/refs: " + unresolved);
        }
        Map<String, Hash> map2 = resolved;
        if (map2 == null) {
            GitRefUtil.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public static Map<String, Hash> getResolvedHashes(@NotNull Map<String, String> data) {
        if (data == null) {
            GitRefUtil.$$$reportNull$$$0(3);
        }
        HashMap<String, Hash> resolved = new HashMap<String, Hash>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = GitRefUtil.parseHash(entry.getValue());
            if (hash == null || GitRefUtil.duplicateEntry(resolved, refName, hash)) continue;
            resolved.put(refName, hash);
        }
        HashMap<String, Hash> hashMap = resolved;
        if (hashMap == null) {
            GitRefUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Nullable
    static String getTarget(@NotNull String refName) {
        Matcher matcher;
        if (refName == null) {
            GitRefUtil.$$$reportNull$$$0(5);
        }
        if (!(matcher = BRANCH_PATTERN.matcher(refName)).matches()) {
            return null;
        }
        Object target = matcher.group(1);
        if (!((String)target).startsWith("refs/heads/") && !((String)target).startsWith("refs/remotes/")) {
            target = "refs/heads/" + (String)target;
        }
        return target;
    }

    @Nullable
    static Hash parseHash(@NotNull String value) {
        if (value == null) {
            GitRefUtil.$$$reportNull$$$0(6);
        }
        try {
            return HashImpl.build((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean duplicateEntry(@NotNull Map<String, Hash> resolved, @NotNull String refName, @NotNull Object newValue) {
        if (resolved == null) {
            GitRefUtil.$$$reportNull$$$0(7);
        }
        if (refName == null) {
            GitRefUtil.$$$reportNull$$$0(8);
        }
        if (newValue == null) {
            GitRefUtil.$$$reportNull$$$0(9);
        }
        if (resolved.containsKey(refName)) {
            LOG.error("Duplicate entry for [" + refName + "]. resolved: [" + resolved.get(refName).asString() + "], current: " + newValue + "]");
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRefUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRefUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRefs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRefsLine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefs";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedHashes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "duplicateEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

