/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitConfig {
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"", 2);
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"", 2);
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"", 2);
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch", 2);
    @NotNull
    private final Collection<? extends Remote> myRemotes;
    @NotNull
    private final Collection<? extends Url> myUrls;
    @NotNull
    private final Collection<? extends BranchConfig> myTrackedInfos;

    private GitConfig(@NotNull Collection<? extends Remote> remotes, @NotNull Collection<? extends Url> urls, @NotNull Collection<? extends BranchConfig> trackedInfos) {
        if (remotes == null) {
            GitConfig.$$$reportNull$$$0(0);
        }
        if (urls == null) {
            GitConfig.$$$reportNull$$$0(1);
        }
        if (trackedInfos == null) {
            GitConfig.$$$reportNull$$$0(2);
        }
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    @NotNull
    Collection<GitRemote> parseRemotes() {
        List list2 = ((StreamEx)StreamEx.of(this.myRemotes).map(remote -> GitConfig.convertRemoteToGitRemote(this.myUrls, remote)).filter(remote -> !remote.getUrls().isEmpty())).toList();
        if (list2 == null) {
            GitConfig.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static GitRemote convertRemoteToGitRemote(@NotNull Collection<? extends Url> urls, @NotNull Remote remote) {
        if (urls == null) {
            GitConfig.$$$reportNull$$$0(4);
        }
        if (remote == null) {
            GitConfig.$$$reportNull$$$0(5);
        }
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        return new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), remote.getPushSpec());
    }

    @NotNull
    Collection<GitBranchTrackInfo> parseTrackInfos(@NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(6);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.mapNotNull(this.myTrackedInfos, config -> GitConfig.convertBranchConfig(config, localBranches, remoteBranches));
        if (list2 == null) {
            GitConfig.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    static GitConfig read(@NotNull File configFile) {
        Ini ini;
        if (configFile == null) {
            GitConfig.$$$reportNull$$$0(9);
        }
        GitConfig emptyConfig = new GitConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (!configFile.exists() || configFile.isDirectory()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                GitConfig.$$$reportNull$$$0(10);
            }
            return gitConfig;
        }
        try {
            ini = GitConfigHelperKt.loadIniFile(configFile);
        }
        catch (IOException e) {
            LOG.warn("Couldn't read .git/config at" + configFile.getPath(), (Throwable)e);
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                GitConfig.$$$reportNull$$$0(11);
            }
            return gitConfig;
        }
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini);
        return new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
    }

    @NotNull
    private static Collection<BranchConfig> parseTrackedInfos(@NotNull Ini ini) {
        if (ini == null) {
            GitConfig.$$$reportNull$$$0(12);
        }
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!StringUtil.startsWithIgnoreCase((String)sectionName, (String)"branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section)) == null) continue;
            configs.add(branchConfig);
        }
        ArrayList<BranchConfig> arrayList = configs;
        if (arrayList == null) {
            GitConfig.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static GitBranchTrackInfo convertBranchConfig(@Nullable BranchConfig branchConfig, @NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(14);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(15);
        }
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getRemote();
        String mergeName = branchConfig.getMerge();
        String rebaseName = branchConfig.getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.debug("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.debug("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String remoteBranchName = StringUtil.unquoteString((String)(merge ? mergeName : rebaseName));
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitConfig.findRemoteBranch(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    @Nullable
    private static GitLocalBranch findLocalBranch(@NotNull String branchName, @NotNull Collection<? extends GitLocalBranch> localBranches) {
        if (branchName == null) {
            GitConfig.$$$reportNull$$$0(16);
        }
        if (localBranches == null) {
            GitConfig.$$$reportNull$$$0(17);
        }
        String name = GitBranchUtil.stripRefsPrefix(branchName);
        return (GitLocalBranch)ContainerUtil.find(localBranches, input -> input.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull String remoteBranchName, @NotNull String remoteName, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (remoteBranchName == null) {
            GitConfig.$$$reportNull$$$0(18);
        }
        if (remoteName == null) {
            GitConfig.$$$reportNull$$$0(19);
        }
        if (remoteBranches == null) {
            GitConfig.$$$reportNull$$$0(20);
        }
        String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        return (GitRemoteBranch)ContainerUtil.find(remoteBranches, branch -> branch.getNameForRemoteOperations().equals(branchName) && branch.getRemote().getName().equals(remoteName));
    }

    @Nullable
    private static BranchConfig parseBranchSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher;
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(21);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(22);
        }
        if ((matcher = BRANCH_INFO_SECTION.matcher(sectionName)).matches()) {
            String remote = (String)section.get((Object)"remote");
            String merge = (String)section.get((Object)"merge");
            String rebase = (String)section.get((Object)"rebase");
            return new BranchConfig(matcher.group(1), remote, merge, rebase);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(@NotNull Ini ini) {
        if (ini == null) {
            GitConfig.$$$reportNull$$$0(23);
        }
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Profile.Section section;
            String sectionName = (String)stringSectionEntry.getKey();
            Remote remote = GitConfig.parseRemoteSection(sectionName, section = (Profile.Section)stringSectionEntry.getValue());
            if (remote != null) {
                remotes.add(remote);
                continue;
            }
            Url url = GitConfig.parseUrlSection(sectionName, section);
            if (url == null) continue;
            urls.add(url);
        }
        Pair pair = Pair.create(remotes, urls);
        if (pair == null) {
            GitConfig.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    private static UrlsAndPushUrls substituteUrls(@NotNull Collection<? extends Url> urlSections, @NotNull Remote remote) {
        String insteadOf;
        boolean substituted;
        if (urlSections == null) {
            GitConfig.$$$reportNull$$$0(25);
        }
        if (remote == null) {
            GitConfig.$$$reportNull$$$0(26);
        }
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        return new UrlsAndPushUrls(urls, pushUrls);
    }

    @NotNull
    private static String substituteUrl(@NotNull String remoteUrl, @NotNull Url url, @NotNull String insteadOf) {
        if (remoteUrl == null) {
            GitConfig.$$$reportNull$$$0(27);
        }
        if (url == null) {
            GitConfig.$$$reportNull$$$0(28);
        }
        if (insteadOf == null) {
            GitConfig.$$$reportNull$$$0(29);
        }
        String string = url.myName + remoteUrl.substring(insteadOf.length());
        if (string == null) {
            GitConfig.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    private static Remote parseRemoteSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher;
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(31);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(32);
        }
        if ((matcher = REMOTE_SECTION.matcher(sectionName)).matches() && matcher.groupCount() == 1) {
            List fetch2 = ContainerUtil.notNullize((List)section.getAll((Object)"fetch"));
            List push = ContainerUtil.notNullize((List)section.getAll((Object)"push"));
            List url = ContainerUtil.notNullize((List)section.getAll((Object)"url"));
            List pushurl = ContainerUtil.notNullize((List)section.getAll((Object)"pushurl"));
            return new Remote(matcher.group(1), fetch2, push, url, pushurl);
        }
        return null;
    }

    @Nullable
    private static Url parseUrlSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher;
        if (sectionName == null) {
            GitConfig.$$$reportNull$$$0(33);
        }
        if (section == null) {
            GitConfig.$$$reportNull$$$0(34);
        }
        if ((matcher = URL_SECTION.matcher(sectionName)).matches() && matcher.groupCount() == 1) {
            String insteadof = (String)section.get((Object)"insteadof");
            String pushInsteadof = (String)section.get((Object)"pushinsteadof");
            return new Url(matcher.group(1), insteadof, pushInsteadof);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedInfos";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitConfig";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 6: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 7: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranchName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 21: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 22: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlSections";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insteadOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitConfig";
                break;
            }
            case 3: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemotes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTrackInfos";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTrackedInfos";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertRemoteToGitRemote";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseTrackInfos";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseTrackedInfos";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchConfig";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseBranchSection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseRemotes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteUrls";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "substituteUrl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseRemoteSection";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseUrlSection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 24: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class BranchConfig {
        private final String myName;
        @Nullable
        private final String myRemote;
        @Nullable
        private final String myMerge;
        @Nullable
        private final String myRebase;

        private BranchConfig(String name, @Nullable String remote, @Nullable String merge, @Nullable String rebase) {
            this.myName = name;
            this.myRemote = remote;
            this.myMerge = merge;
            this.myRebase = rebase;
        }

        public String getName() {
            return this.myName;
        }

        @Nullable
        private String getRemote() {
            return this.myRemote;
        }

        @Nullable
        private String getMerge() {
            return this.myMerge;
        }

        @Nullable
        private String getRebase() {
            return this.myRebase;
        }
    }

    private static final class Url {
        private final String myName;
        @Nullable
        private final String myInsteadof;
        @Nullable
        private final String myPushInsteadof;

        private Url(String name, @Nullable String insteadof, @Nullable String pushInsteadof) {
            this.myName = name;
            this.myInsteadof = insteadof;
            this.myPushInsteadof = pushInsteadof;
        }

        @Nullable
        public String getInsteadOf() {
            return this.myInsteadof;
        }

        @Nullable
        public String getPushInsteadOf() {
            return this.myPushInsteadof;
        }
    }

    private static final class Remote {
        @NotNull
        private final String myName;
        @NotNull
        List<String> myFetchSpecs;
        @NotNull
        List<String> myPushSpec;
        @NotNull
        List<String> myUrls;
        @NotNull
        List<String> myPushUrls;

        private Remote(@NotNull String name, @NotNull List<String> fetchSpecs, @NotNull List<String> pushSpec, @NotNull List<String> urls, @NotNull List<String> pushUrls) {
            if (name == null) {
                Remote.$$$reportNull$$$0(0);
            }
            if (fetchSpecs == null) {
                Remote.$$$reportNull$$$0(1);
            }
            if (pushSpec == null) {
                Remote.$$$reportNull$$$0(2);
            }
            if (urls == null) {
                Remote.$$$reportNull$$$0(3);
            }
            if (pushUrls == null) {
                Remote.$$$reportNull$$$0(4);
            }
            this.myName = name;
            this.myFetchSpecs = fetchSpecs;
            this.myPushSpec = pushSpec;
            this.myUrls = urls;
            this.myPushUrls = pushUrls;
        }

        @NotNull
        private Collection<String> getUrls() {
            List<String> list2 = this.myUrls;
            if (list2 == null) {
                Remote.$$$reportNull$$$0(5);
            }
            return list2;
        }

        @NotNull
        private Collection<String> getPushUrls() {
            List<String> list2 = this.myPushUrls;
            if (list2 == null) {
                Remote.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        private List<String> getPushSpec() {
            List<String> list2 = this.myPushSpec;
            if (list2 == null) {
                Remote.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        private List<String> getFetchSpecs() {
            List<String> list2 = this.myFetchSpecs;
            if (list2 == null) {
                Remote.$$$reportNull$$$0(8);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetchSpecs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pushSpec";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pushUrls";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/repo/GitConfig$Remote";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/repo/GitConfig$Remote";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushUrls";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushSpec";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFetchSpecs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

