/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitConfigureRemotesDialog;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u001a8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u001a\b\u0010\u0018\u001a\u00020\u0019H\u0002\u001a@\u0010\u001a\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u001aR\u0010\u001f\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u00042\b\b\u0001\u0010!\u001a\u00020\u00042\b\b\u0001\u0010\"\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010$0\u0017H\u0002\u001a\u0012\u0010%\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "url", "", "Lgit4idea/repo/GitRemote;", "getUrl", "(Lgit4idea/repo/GitRemote;)Ljava/lang/String;", "changeRemote", "Lgit4idea/commands/GitCommandResult;", "git", "Lgit4idea/commands/Git;", "repo", "Lgit4idea/repo/GitRepository;", "oldName", "oldUrl", "newName", "newUrl", "editRemote", "", "repository", "remote", "onSuccess", "Lkotlin/Function0;", "getModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "removeRemotes", "remotes", "", "parent", "Ljava/awt/Component;", "runInModalTask", "title", "errorTitle", "errorMessage", "operation", "", "toStringRepresentation", "intellij.vcs.git"})
public final class GitConfigureRemotesDialogKt {
    private static final Logger LOG;

    public static final void removeRemotes(@NotNull Git git, @NotNull GitRepository repository, @NotNull Set<GitRemote> remotes, @Nullable Component parent, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        if (Messages.showYesNoDialog((Project)(parent == null ? (Project)parent : repository.getProject()), (String)GitBundle.message("remotes.dialog.remove.remote.message", remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes)), (String)GitBundle.message("remotes.dialog.remove.remote.title", remotes.size()), (Icon)Messages.getQuestionIcon()) == 0) {
            String string = GitBundle.message("remotes.dialog.removing.remote.progress", remotes.size());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"remotes.dialog.\u2026.progress\", remotes.size)");
            String string2 = GitBundle.message("remotes.dialog.removing.remote.error.title", remotes.size());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"remotes.dialog.\u2026ror.title\", remotes.size)");
            String string3 = GitBundle.message("remotes.dialog.removing.remote.error.message", remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"remotes.dialog.\u2026toStringRepresentation())");
            GitConfigureRemotesDialogKt.runInModalTask(string, string2, string3, repository, onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)((Function0)new Function0<List<? extends GitCommandResult>>(remotes, git, repository){
                final /* synthetic */ Set $remotes;
                final /* synthetic */ Git $git;
                final /* synthetic */ GitRepository $repository;

                @Nullable
                public final List<GitCommandResult> invoke() {
                    boolean bl = false;
                    ArrayList<GitCommandResult> arrayList = new ArrayList<GitCommandResult>();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ArrayList<GitCommandResult> $this$apply = arrayList;
                    boolean bl4 = false;
                    for (GitRemote remote : this.$remotes) {
                        $this$apply.add(this.$git.removeRemote(this.$repository, remote));
                    }
                    return arrayList;
                }
                {
                    this.$remotes = set;
                    this.$git = git;
                    this.$repository = gitRepository;
                    super(0);
                }
            }));
        }
    }

    public static /* synthetic */ void removeRemotes$default(Git git, GitRepository gitRepository, Set set, Component component, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            component = null;
        }
        if ((n & 0x10) != 0) {
            function0 = removeRemotes.1.INSTANCE;
        }
        GitConfigureRemotesDialogKt.removeRemotes(git, gitRepository, set, component, (Function0<Unit>)function0);
    }

    public static final void editRemote(@NotNull Git git, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        String string = remote.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remote.name");
        String oldName = string;
        String oldUrl = GitConfigureRemotesDialogKt.getUrl(remote);
        GitDefineRemoteDialog dialog2 = new GitDefineRemoteDialog(repository, git, oldName, oldUrl);
        if (dialog2.showAndGet()) {
            String newRemoteName = dialog2.getRemoteName();
            String newRemoteUrl = dialog2.getRemoteUrl();
            if (Intrinsics.areEqual((Object)newRemoteName, (Object)oldName) && Intrinsics.areEqual((Object)newRemoteUrl, (Object)oldUrl)) {
                return;
            }
            String string2 = GitBundle.message("remotes.changing.remote.progress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"remotes.changing.remote.progress\")");
            String string3 = GitBundle.message("remotes.changing.remote.error.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"remotes.changing.remote.error.title\")");
            String string4 = GitBundle.message("remotes.changing.remote.error.message", oldName, newRemoteName, newRemoteUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"remotes.changin\u2026RemoteName, newRemoteUrl)");
            GitConfigureRemotesDialogKt.runInModalTask(string2, string3, string4, repository, onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)((Function0)new Function0<List<? extends GitCommandResult>>(git, repository, oldName, oldUrl, newRemoteName, newRemoteUrl){
                final /* synthetic */ Git $git;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ String $oldName;
                final /* synthetic */ String $oldUrl;
                final /* synthetic */ String $newRemoteName;
                final /* synthetic */ String $newRemoteUrl;

                @Nullable
                public final List<GitCommandResult> invoke() {
                    boolean bl = false;
                    ArrayList<GitCommandResult> arrayList = new ArrayList<GitCommandResult>();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ArrayList<GitCommandResult> $this$apply = arrayList;
                    boolean bl4 = false;
                    $this$apply.add(GitConfigureRemotesDialogKt.access$changeRemote(this.$git, this.$repository, this.$oldName, this.$oldUrl, this.$newRemoteName, this.$newRemoteUrl));
                    return arrayList;
                }
                {
                    this.$git = git;
                    this.$repository = gitRepository;
                    this.$oldName = string;
                    this.$oldUrl = string2;
                    this.$newRemoteName = string3;
                    this.$newRemoteUrl = string4;
                    super(0);
                }
            }));
        }
    }

    public static /* synthetic */ void editRemote$default(Git git, GitRepository gitRepository, GitRemote gitRemote, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = editRemote.1.INSTANCE;
        }
        GitConfigureRemotesDialogKt.editRemote(git, gitRepository, gitRemote, (Function0<Unit>)function0);
    }

    private static final String getUrl(GitRemote $this$url) {
        List<String> list2 = $this$url.getUrls();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"urls");
        String string = (String)CollectionsKt.firstOrNull(list2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String toStringRepresentation(Set<GitRemote> $this$toStringRepresentation) {
        String string;
        if ($this$toStringRepresentation.size() == 1) {
            Object object = CollectionsKt.first((Iterable)$this$toStringRepresentation);
            boolean bl = false;
            boolean bl2 = false;
            GitRemote $this$with = (GitRemote)object;
            boolean bl3 = false;
            string = $this$with.getName() + " '" + GitConfigureRemotesDialogKt.getUrl($this$with) + '\'';
        } else {
            string = '\n' + CollectionsKt.joinToString$default((Iterable)$this$toStringRepresentation, (CharSequence)"\n", null, null, (int)0, null, (Function1)toStringRepresentation.2.INSTANCE, (int)30, null);
        }
        return string;
    }

    private static final GitCommandResult changeRemote(Git git, GitRepository repo, String oldName, String oldUrl, String newName, String newUrl) {
        GitCommandResult result2 = null;
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true && !(result2 = git.renameRemote(repo, oldName, newName)).success()) {
            return result2;
        }
        if (Intrinsics.areEqual((Object)newUrl, (Object)oldUrl) ^ true) {
            result2 = git.setRemoteUrl(repo, newName, newUrl);
        }
        GitCommandResult gitCommandResult = result2;
        Intrinsics.checkNotNull((Object)gitCommandResult);
        return gitCommandResult;
    }

    private static final void runInModalTask(@Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Title) String errorTitle, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage, GitRepository repository, Function0<Unit> onSuccess2, Function0<? extends List<? extends GitCommandResult>> operation) {
        ProgressManager.getInstance().run((Task)new Task.Modal(operation, repository, onSuccess2, errorMessage, errorTitle, title, repository.getProject(), title, true){
            private List<? extends GitCommandResult> results;
            final /* synthetic */ Function0 $operation;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ Function0 $onSuccess;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $errorTitle;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.results = (List)this.$operation.invoke();
                this.$repository.update();
            }

            public void onSuccess() {
                block11: {
                    String string;
                    block10: {
                        boolean bl;
                        block9: {
                            this.$onSuccess.invoke();
                            if (this.results == null) break block10;
                            List<? extends GitCommandResult> list2 = this.results;
                            Intrinsics.checkNotNull(list2);
                            Iterable $this$any$iv = list2;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    GitCommandResult it = (GitCommandResult)element$iv;
                                    boolean bl2 = false;
                                    if (!(!it.success())) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block11;
                    }
                    if (this.results == null) {
                        string = GitBundle.message("remotes.operation.not.executed.message", new Object[0]);
                    } else {
                        List<? extends GitCommandResult> list3 = this.results;
                        Intrinsics.checkNotNull(list3);
                        string = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n", null, null, (int)0, null, (Function1)runInModalTask.onSuccess.errorDetails.1.INSTANCE, (int)30, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (results == null) mes\u2026rorOutputAsJoinedString }");
                    String errorDetails2 = string;
                    String string2 = GitBundle.message("remotes.operation.error.message", this.$errorMessage, this.$repository, errorDetails2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"remotes.operati\u2026repository, errorDetails)");
                    String message = string2;
                    GitConfigureRemotesDialogKt.access$getLOG$p().warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)message, (String)this.$errorTitle);
                }
            }
            {
                this.$operation = $captured_local_variable$0;
                this.$repository = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
                this.$errorMessage = $captured_local_variable$3;
                this.$errorTitle = $captured_local_variable$4;
                this.$title = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    private static final DialogWrapper.IdeModalityType getModalityType() {
        return Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitConfigureRemotesDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$getUrl$p(GitRemote $this$access_u24url_u24p) {
        return GitConfigureRemotesDialogKt.getUrl($this$access_u24url_u24p);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$runInModalTask(String title, String errorTitle, String errorMessage, GitRepository repository, Function0 onSuccess2, Function0 operation) {
        GitConfigureRemotesDialogKt.runInModalTask(title, errorTitle, errorMessage, repository, (Function0<Unit>)onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)operation);
    }

    public static final /* synthetic */ DialogWrapper.IdeModalityType access$getModalityType() {
        return GitConfigureRemotesDialogKt.getModalityType();
    }

    public static final /* synthetic */ GitCommandResult access$changeRemote(Git git, GitRepository repo, String oldName, String oldUrl, String newName, String newUrl) {
        return GitConfigureRemotesDialogKt.changeRemote(git, repo, oldName, oldUrl, newName, newUrl);
    }
}

