/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0004R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperation;", "", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "rebase", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "rebaseEditor", "Lgit4idea/rebase/GitRebaseEditorHandler;", "preserveMerges", "", "GitMultipleCommitEditingProcess", "intellij.vcs.git"})
public abstract class GitCommitEditingOperation {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepository repository;

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final GitCommitEditingOperationResult rebase(@NotNull List<? extends VcsCommitMetadata> commits2, @NotNull GitRebaseEditorHandler rebaseEditor2, boolean preserveMerges) {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)rebaseEditor2, (String)"rebaseEditor");
        List list2 = ((VcsCommitMetadata)CollectionsKt.last(commits2)).getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"commits.last().parents");
        String string = ((Hash)CollectionsKt.first((List)list2)).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commits.last().parents.first().asString()");
        String base = string;
        GitVcs gitVcs = this.repository.getVcs();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"repository.vcs");
        GitVersion gitVersion = gitVcs.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"repository.vcs.version");
        GitRebaseParams params = GitRebaseParams.Companion.editCommits(gitVersion, base, rebaseEditor2, preserveMerges, GitRebaseParams.AutoSquashOption.DISABLE);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        GitRebaseSpec gitRebaseSpec = GitRebaseSpec.forNewRebase(this.project, params, CollectionsKt.listOf((Object)this.repository), indicator);
        Intrinsics.checkNotNullExpressionValue((Object)gitRebaseSpec, (String)"GitRebaseSpec.forNewReba\u2026f(repository), indicator)");
        GitRebaseSpec spec = gitRebaseSpec;
        GitMultipleCommitEditingProcess process = new GitMultipleCommitEditingProcess(this.repository, params, spec);
        process.rebase();
        return process.getResult();
    }

    public static /* synthetic */ GitCommitEditingOperationResult rebase$default(GitCommitEditingOperation gitCommitEditingOperation, List list2, GitRebaseEditorHandler gitRebaseEditorHandler, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return gitCommitEditingOperation.rebase(list2, gitRebaseEditorHandler, bl);
    }

    @NotNull
    protected final GitRepository getRepository() {
        return this.repository;
    }

    public GitCommitEditingOperation(@NotNull GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        this.project = project;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0015R\u0018\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lgit4idea/rebase/log/GitCommitEditingOperation$GitMultipleCommitEditingProcess;", "Lgit4idea/rebase/GitRebaseProcess;", "repository", "Lgit4idea/repo/GitRepository;", "params", "Lgit4idea/branch/GitRebaseParams;", "spec", "Lgit4idea/rebase/GitRebaseSpec;", "(Lgit4idea/repo/GitRepository;Lgit4idea/branch/GitRebaseParams;Lgit4idea/rebase/GitRebaseSpec;)V", "initialHead", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "result", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "getResult", "()Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "setResult", "(Lgit4idea/rebase/log/GitCommitEditingOperationResult;)V", "notifySuccess", "", "intellij.vcs.git"})
    private static final class GitMultipleCommitEditingProcess
    extends GitRebaseProcess {
        private final String initialHead;
        @NotNull
        private GitCommitEditingOperationResult result;
        private final GitRepository repository;
        private final GitRebaseParams params;

        @NotNull
        public final GitCommitEditingOperationResult getResult() {
            return this.result;
        }

        public final void setResult(@NotNull GitCommitEditingOperationResult gitCommitEditingOperationResult) {
            Intrinsics.checkNotNullParameter((Object)gitCommitEditingOperationResult, (String)"<set-?>");
            this.result = gitCommitEditingOperationResult;
        }

        @Override
        @RequiresBackgroundThread
        protected void notifySuccess() {
            this.repository.update();
            String string = this.repository.getCurrentRevision();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentRevision!!");
            String newHead = string;
            String string2 = this.params.getUpstream();
            Intrinsics.checkNotNull((Object)string2);
            this.result = new GitCommitEditingOperationResult.Complete(this.repository, string2, this.initialHead, newHead);
        }

        public GitMultipleCommitEditingProcess(@NotNull GitRepository repository, @NotNull GitRebaseParams params, @NotNull GitRebaseSpec spec) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            super(repository.getProject(), spec, null);
            this.repository = repository;
            this.params = params;
            this.repository.update();
            String string = this.repository.getCurrentRevision();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentRevision!!");
            this.initialHead = string;
            this.result = GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
    }
}

