/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.conflict;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.i18n.GitBundleExtensions;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\u0005\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00110\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\u001a\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/rebase/conflict/GitRebaseMergeDialogCustomizer;", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "repository", "Lgit4idea/repo/GitRepository;", "upstream", "", "rebasingBranch", "ingoingCommit", "Lcom/intellij/vcs/log/Hash;", "mergeBase", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;)V", "baseBranch", "baseHash", "basePresentable", "getColumnNames", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "getLeftPanelTitle", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLeftTitleCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "Lcom/intellij/openapi/vcs/FilePath;", "getMultipleFileMergeDescription", "files", "", "getRightPanelTitle", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getRightTitleCustomizer", "getTitleCustomizerList", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "intellij.vcs.git"})
final class GitRebaseMergeDialogCustomizer
extends MergeDialogCustomizer {
    private final Hash baseHash;
    @NlsSafe
    private final String basePresentable;
    @NlsSafe
    private final String baseBranch;
    private final GitRepository repository;
    private final String rebasingBranch;
    private final Hash ingoingCommit;
    private final Hash mergeBase;

    @NotNull
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(this.rebasingBranch, this.baseBranch, this.baseHash);
    }

    @NotNull
    public String getLeftPanelTitle(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(this.rebasingBranch);
    }

    @NotNull
    public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Hash hash = revisionNumber != null ? HashImpl.build((String)revisionNumber.asString()) : this.baseHash;
        return GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch(this.baseBranch, hash);
    }

    @NotNull
    public List<String> getColumnNames() {
        return CollectionsKt.listOf((Object[])new String[]{GitMergeProvider.calcColumnName(false, this.rebasingBranch), GitMergeProvider.calcColumnName(true, this.basePresentable)});
    }

    @NotNull
    public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new MergeDialogCustomizer.DiffEditorTitleCustomizerList(this.getLeftTitleCustomizer(file), null, this.getRightTitleCustomizer(file));
    }

    private final DiffEditorTitleCustomizer getLeftTitleCustomizer(FilePath file) {
        if (this.ingoingCommit == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        String string = this.ingoingCommit.toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ingoingCommit.toShortString()");
        objectArray[0] = string;
        HtmlChunk.Element element = HtmlChunk.text((String)this.rebasingBranch).bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlChunk.text(rebasingBranch).bold()");
        objectArray[1] = element;
        String string2 = GitBundleExtensions.html("rebase.conflict.diff.dialog.left.title", objectArray);
        String string3 = this.ingoingCommit.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ingoingCommit.asString()");
        return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(string2, this.repository, file, string3);
    }

    private final DiffEditorTitleCustomizer getRightTitleCustomizer(FilePath file) {
        String string;
        if (this.mergeBase == null) {
            return null;
        }
        if (this.baseBranch != null) {
            Object[] objectArray = new Object[1];
            HtmlChunk.Element element = HtmlChunk.text((String)this.baseBranch).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlChunk.text(baseBranch).bold()");
            objectArray[0] = element;
            string = GitBundleExtensions.html("rebase.conflict.diff.dialog.right.with.branch.title", objectArray);
        } else {
            string = GitBundleExtensions.html("rebase.conflict.diff.dialog.right.simple.title", new Object[0]);
        }
        String title = string;
        return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(title, this.repository, file, (Pair<String, String>)new Pair((Object)this.mergeBase.asString(), (Object)"HEAD"));
    }

    public GitRebaseMergeDialogCustomizer(@NotNull GitRepository repository, @NotNull String upstream, @NlsSafe @NotNull String rebasingBranch, @Nullable Hash ingoingCommit, @Nullable Hash mergeBase) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)rebasingBranch, (String)"rebasingBranch");
        this.repository = repository;
        this.rebasingBranch = rebasingBranch;
        this.ingoingCommit = ingoingCommit;
        this.mergeBase = mergeBase;
        CharSequence charSequence = upstream;
        String string = "[a-fA-F0-9]{40}";
        boolean bl = false;
        string = new Regex(string);
        bl = false;
        if (string.matches(charSequence)) {
            this.basePresentable = VcsLogUtil.getShortHash((String)upstream);
            this.baseBranch = null;
            this.baseHash = HashImpl.build((String)upstream);
        } else {
            this.basePresentable = upstream;
            this.baseBranch = upstream;
            this.baseHash = null;
        }
    }
}

