/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseHelpPopupPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u0001H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel;", "Ljavax/swing/JPanel;", "()V", "content", "helpLink", "Lcom/intellij/ui/components/BrowserLink;", "getHelpLink", "()Lcom/intellij/ui/components/BrowserLink;", "rebaseBranchImage", "Ljavax/swing/JComponent;", "chooseImage", "", "imagePath", "createContent", "createHelpLink", "createImageComponent", "loadImage", "Ljava/awt/Image;", "path", "Companion", "intellij.vcs.git"})
public final class GitRebaseHelpPopupPanel
extends JPanel {
    @NotNull
    private final BrowserLink helpLink = this.createHelpLink();
    private final JComponent rebaseBranchImage = this.createImageComponent("/images/rebase-branch");
    private final JPanel content = this.createContent();
    private static final Logger LOG;
    private static final String REBASE_BRANCH_IMG = "/images/rebase-branch";
    private static final String DARK_POSTFIX = "-dark";
    private static final String HIDPI_POSTFIX = "@2x";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final BrowserLink getHelpLink() {
        return this.helpLink;
    }

    private final JPanel createContent() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)createContent.1.1.INSTANCE, (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GitRebaseHelpPopupPanel this$0;
            {
                this.this$0 = gitRebaseHelpPopupPanel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)GitRebaseHelpPopupPanel.access$getRebaseBranchImage$p(this.this$0), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ GitRebaseHelpPopupPanel this$0;
            {
                this.this$0 = gitRebaseHelpPopupPanel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)this.this$0.getHelpLink()), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return (JPanel)panel$iv;
    }

    private final BrowserLink createHelpLink() {
        String string = GitBundle.message("rebase.help.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebase.help.link\")");
        return new BrowserLink(string, "https://git-scm.com/docs/git-rebase");
    }

    private final JComponent createImageComponent(String imagePath) {
        JBImageIcon jBImageIcon;
        Image image;
        String suitableImagePath = this.chooseImage(imagePath);
        Image image2 = image = this.loadImage(suitableImagePath);
        if (image2 != null) {
            JBImageIcon jBImageIcon2;
            Image image3 = image2;
            boolean bl = false;
            boolean bl2 = false;
            Image p1 = image3;
            boolean bl3 = false;
            jBImageIcon = jBImageIcon2 = new JBImageIcon(p1);
        } else {
            jBImageIcon = null;
        }
        Icon icon = (Icon)jBImageIcon;
        return new JLabel(icon);
    }

    private final Image loadImage(String path) {
        Image image;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            Image image2 = img;
            BufferedImage bufferedImage = img;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"img");
            image = (Image)new JBHiDPIScaledImage(image2, 274, 140, bufferedImage.getType());
        }
        catch (Exception e) {
            LOG.warn("Failed to load image: " + path, (Throwable)e);
            image = null;
        }
        return image;
    }

    private final String chooseImage(String imagePath) {
        String themePart = StartupUiUtil.isUnderDarcula() ? DARK_POSTFIX : "";
        String retinaPart = StartupUiUtil.isJreHiDPI() ? HIDPI_POSTFIX : "";
        return imagePath + themePart + retinaPart + ".png";
    }

    public GitRebaseHelpPopupPanel() {
        this.add((Component)this.content, "Center");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@Nullable KeyEvent e) {
                KeyEvent keyEvent = e;
                if (keyEvent != null) {
                    if (keyEvent.getKeyCode() == 32) {
                        this.getHelpLink().doClick();
                    }
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseHelpPopupPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ JComponent access$getRebaseBranchImage$p(GitRebaseHelpPopupPanel $this) {
        return $this.rebaseBranchImage;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel$Companion;", "", "()V", "DARK_POSTFIX", "", "HIDPI_POSTFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REBASE_BRANCH_IMG", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

