/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEntry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0016\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/rebase/GitAutomaticRebaseEditor;", "Lgit4idea/rebase/GitInteractiveRebaseEditorHandler;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "entriesEditor", "Lkotlin/Function1;", "", "Lgit4idea/rebase/GitRebaseEntry;", "plainTextEditor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "editCommits", "", "file", "Ljava/io/File;", "intellij.vcs.git"})
public final class GitAutomaticRebaseEditor
extends GitInteractiveRebaseEditorHandler {
    @NotNull
    private final Logger LOG;
    private final Project project;
    private final VirtualFile root;
    private final Function1<List<? extends GitRebaseEntry>, List<GitRebaseEntry>> entriesEditor;
    private final Function1<String, String> plainTextEditor;

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    @Override
    public int editCommits(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            if (!this.myRebaseEditorShown) {
                this.myRebaseEditorShown = true;
                GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.project, this.root, file);
                List<GitRebaseEntry> list2 = rebaseFile.load();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"rebaseFile.load()");
                List<GitRebaseEntry> entries = list2;
                rebaseFile.save((List)this.entriesEditor.invoke(entries));
            } else {
                String modifiedMessage;
                String string = GitConfigUtil.getCommitEncoding(this.project, this.root);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitConfigUtil.getCommitEncoding(project, root)");
                String encoding = string;
                String string2 = FileUtil.loadFile((File)file, (String)encoding);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.loadFile(file, encoding)");
                String originalMessage = string2;
                String string3 = modifiedMessage = (String)this.plainTextEditor.invoke((Object)originalMessage);
                boolean bl = false;
                Charset charset = Charset.forName(encoding);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                Charset charset2 = charset;
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string4.getBytes(charset2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                FileUtil.writeToFile((File)file, (byte[])byArray);
            }
            return 0;
        }
        catch (Exception ex) {
            this.LOG.error("Editor failed: ", (Throwable)ex);
            return 2;
        }
    }

    public GitAutomaticRebaseEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>> entriesEditor, @NotNull Function1<? super String, String> plainTextEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(entriesEditor, (String)"entriesEditor");
        Intrinsics.checkNotNullParameter(plainTextEditor, (String)"plainTextEditor");
        super(project, root);
        this.project = project;
        this.root = root;
        this.entriesEditor = entriesEditor;
        this.plainTextEditor = plainTextEditor;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitAutomaticRebaseEditor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }
}

