/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.BaseSingleTaskController;
import com.intellij.vcs.log.data.SingleTaskController;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import git4idea.light.LightGitTracker;
import git4idea.light.LightGitTrackerListener;
import git4idea.light.LightGitUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lgit4idea/light/LightGitEditorHighlighterManager;", "Lcom/intellij/openapi/Disposable;", "tracker", "Lgit4idea/light/LightGitTracker;", "(Lgit4idea/light/LightGitTracker;)V", "lightEditService", "Lcom/intellij/ide/lightEdit/LightEditService;", "kotlin.jvm.PlatformType", "getLightEditService", "()Lcom/intellij/ide/lightEdit/LightEditService;", "lst", "Lcom/intellij/openapi/vcs/ex/SimpleLocalLineStatusTracker;", "singleTaskController", "Lgit4idea/light/LightGitEditorHighlighterManager$MySingleTaskController;", "getTracker", "()Lgit4idea/light/LightGitTracker;", "dispose", "", "dropLst", "readBaseVersion", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "repositoryPath", "", "setBaseVersion", "baseVersion", "Lgit4idea/light/LightGitEditorHighlighterManager$BaseVersion;", "updateLst", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "BaseVersion", "MySingleTaskController", "Request", "intellij.vcs.git"})
public final class LightGitEditorHighlighterManager
implements Disposable {
    private final MySingleTaskController singleTaskController;
    private SimpleLocalLineStatusTracker lst;
    @NotNull
    private final LightGitTracker tracker;

    private final LightEditService getLightEditService() {
        return LightEditService.getInstance();
    }

    private final void readBaseVersion(VirtualFile file, String repositoryPath) {
        if (repositoryPath == null) {
            SimpleLocalLineStatusTracker simpleLocalLineStatusTracker = this.lst;
            if (simpleLocalLineStatusTracker != null) {
                simpleLocalLineStatusTracker.setBaseRevision((CharSequence)"");
            }
            return;
        }
        this.singleTaskController.request(new Request[]{new Request(file, repositoryPath)});
    }

    private final void setBaseVersion(BaseVersion baseVersion) {
        LightEditService lightEditService = this.getLightEditService();
        Intrinsics.checkNotNullExpressionValue((Object)lightEditService, (String)"lightEditService");
        if (Intrinsics.areEqual((Object)lightEditService.getSelectedFile(), (Object)baseVersion.getFile())) {
            SimpleLocalLineStatusTracker simpleLocalLineStatusTracker = this.lst;
            if (Intrinsics.areEqual((Object)(simpleLocalLineStatusTracker != null ? simpleLocalLineStatusTracker.getVirtualFile() : null), (Object)baseVersion.getFile())) {
                if (baseVersion.getText() != null) {
                    SimpleLocalLineStatusTracker simpleLocalLineStatusTracker2 = this.lst;
                    if (simpleLocalLineStatusTracker2 != null) {
                        simpleLocalLineStatusTracker2.setBaseRevision((CharSequence)baseVersion.getText());
                    }
                } else {
                    this.dropLst();
                }
            }
        }
    }

    private final void updateLst(FileEditor fileEditor) {
        Editor editor = LightEditorInfoImpl.getEditor((FileEditor)fileEditor);
        VirtualFile file = fileEditor.getFile();
        if (editor == null || file == null) {
            this.dropLst();
            return;
        }
        LightFileStatus status = this.tracker.getFileStatus(file);
        if (!GitIndexStatusUtilKt.isTracked(status)) {
            this.dropLst();
            return;
        }
        if (this.lst == null) {
            LightEditService lightEditService = this.getLightEditService();
            Intrinsics.checkNotNullExpressionValue((Object)lightEditService, (String)"lightEditService");
            Project project = lightEditService.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lightEditService.project");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            this.lst = SimpleLocalLineStatusTracker.Companion.createTracker(project, document, file);
        }
        this.readBaseVersion(file, GitIndexStatusUtilKt.getRepositoryPath(status));
    }

    private final void dropLst() {
        SimpleLocalLineStatusTracker simpleLocalLineStatusTracker = this.lst;
        if (simpleLocalLineStatusTracker != null) {
            simpleLocalLineStatusTracker.release();
        }
        this.lst = null;
    }

    public void dispose() {
        this.dropLst();
    }

    @NotNull
    public final LightGitTracker getTracker() {
        return this.tracker;
    }

    public LightGitEditorHighlighterManager(@NotNull LightGitTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.tracker = tracker;
        this.singleTaskController = new MySingleTaskController();
        this.tracker.addUpdateListener(new LightGitTrackerListener(){

            @Override
            public void update() {
                block0: {
                    LightEditService lightEditService = this.getLightEditService();
                    Intrinsics.checkNotNullExpressionValue((Object)lightEditService, (String)"lightEditService");
                    FileEditor fileEditor = lightEditService.getSelectedFileEditor();
                    if (fileEditor == null) break block0;
                    FileEditor fileEditor2 = fileEditor;
                    boolean bl = false;
                    boolean bl2 = false;
                    FileEditor fileEditor3 = fileEditor2;
                    boolean bl3 = false;
                    FileEditor fileEditor4 = fileEditor3;
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditor4, (String)"fileEditor");
                    this.updateLst(fileEditor4);
                }
            }
        }, this);
        LightEditService lightEditService = this.getLightEditService();
        Intrinsics.checkNotNullExpressionValue((Object)lightEditService, (String)"lightEditService");
        lightEditService.getEditorManager().addListener(new LightEditorListener(){

            public void afterSelect(@Nullable LightEditorInfo editorInfo) {
                if (editorInfo == null) {
                    this.dropLst();
                    return;
                }
                SimpleLocalLineStatusTracker simpleLocalLineStatusTracker = lst;
                if (Intrinsics.areEqual((Object)editorInfo.getFile(), (Object)(simpleLocalLineStatusTracker != null ? simpleLocalLineStatusTracker.getVirtualFile() : null)) ^ true) {
                    this.dropLst();
                    FileEditor fileEditor = editorInfo.getFileEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"editorInfo.fileEditor");
                    this.updateLst(fileEditor);
                }
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this.tracker, (Disposable)this);
    }

    public static final /* synthetic */ void access$setLst$p(LightGitEditorHighlighterManager $this, SimpleLocalLineStatusTracker simpleLocalLineStatusTracker) {
        $this.lst = simpleLocalLineStatusTracker;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0014J \u0010\t\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/light/LightGitEditorHighlighterManager$MySingleTaskController;", "Lcom/intellij/vcs/log/BaseSingleTaskController;", "Lgit4idea/light/LightGitEditorHighlighterManager$Request;", "Lgit4idea/light/LightGitEditorHighlighterManager$BaseVersion;", "(Lgit4idea/light/LightGitEditorHighlighterManager;)V", "cancelRunningTasks", "", "requests", "", "process", "previousResult", "intellij.vcs.git"})
    private final class MySingleTaskController
    extends BaseSingleTaskController<Request, BaseVersion> {
        @NotNull
        public BaseVersion process(@NotNull List<Request> requests, @Nullable BaseVersion previousResult) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            Request request = (Request)CollectionsKt.last(requests);
            try {
                String content2 = LightGitUtilKt.getFileContentAsString$default(request.getFile(), request.getRepositoryPath(), LightGitEditorHighlighterManager.this.getTracker().getGitExecutable(), null, 8, null);
                return new BaseVersion(request.getFile(), StringUtil.convertLineSeparators((String)content2));
            }
            catch (VcsException e) {
                MySingleTaskController.access$getLOG$p$s-971212407().warn("Could not read base version for " + request.getFile(), (Throwable)e);
                return new BaseVersion(request.getFile(), null);
            }
        }

        protected boolean cancelRunningTasks(@NotNull List<Request> requests) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            return true;
        }

        public MySingleTaskController() {
            super("light.highlighter", (Function1)new Function1<BaseVersion, Unit>(LightGitEditorHighlighterManager.this){

                public final void invoke(@NotNull BaseVersion p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((LightGitEditorHighlighterManager)this.receiver).setBaseVersion(p1);
                }
            }, (Disposable)LightGitEditorHighlighterManager.this);
        }

        public static final /* synthetic */ Logger access$getLOG$p$s-971212407() {
            return SingleTaskController.LOG;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgit4idea/light/LightGitEditorHighlighterManager$Request;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "repositoryPath", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRepositoryPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class Request {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String repositoryPath;

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final String getRepositoryPath() {
            return this.repositoryPath;
        }

        public Request(@NotNull VirtualFile file, @NotNull String repositoryPath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
            this.file = file;
            this.repositoryPath = repositoryPath;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final String component2() {
            return this.repositoryPath;
        }

        @NotNull
        public final Request copy(@NotNull VirtualFile file, @NotNull String repositoryPath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
            return new Request(file, repositoryPath);
        }

        public static /* synthetic */ Request copy$default(Request request, VirtualFile virtualFile, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = request.file;
            }
            if ((n & 2) != 0) {
                string = request.repositoryPath;
            }
            return request.copy(virtualFile, string);
        }

        @NotNull
        public String toString() {
            return "Request(file=" + this.file + ", repositoryPath=" + this.repositoryPath + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.file;
            String string = this.repositoryPath;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Request)) break block3;
                    Request request = (Request)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)request.file) || !Intrinsics.areEqual((Object)this.repositoryPath, (Object)request.repositoryPath)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\r\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/light/LightGitEditorHighlighterManager$BaseVersion;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    private static final class BaseVersion {
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final String text;

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("BaseVersion(file=").append(this.file).append(", text=");
            String string = this.text;
            if (string == null || (string = StringsKt.take((String)string, (int)10)) == null) {
                string = "null";
            }
            return stringBuilder.append(string).toString();
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public BaseVersion(@NotNull VirtualFile file, @Nullable String text) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.text = text;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @Nullable
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final BaseVersion copy(@NotNull VirtualFile file, @Nullable String text) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new BaseVersion(file, text);
        }

        public static /* synthetic */ BaseVersion copy$default(BaseVersion baseVersion, VirtualFile virtualFile, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = baseVersion.file;
            }
            if ((n & 2) != 0) {
                string = baseVersion.text;
            }
            return baseVersion.copy(virtualFile, string);
        }

        public int hashCode() {
            VirtualFile virtualFile = this.file;
            String string = this.text;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BaseVersion)) break block3;
                    BaseVersion baseVersion = (BaseVersion)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)baseVersion.file) || !Intrinsics.areEqual((Object)this.text, (Object)baseVersion.text)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

