/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.index.vfs.GitIndexVirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFileCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lgit4idea/index/vfs/GitIndexVirtualFileCache$Key;", "kotlin.jvm.PlatformType", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "dispose", "", "filesMatching", "", "function", "Lkotlin/Function1;", "", "get", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Key", "intellij.vcs.git"})
public final class GitIndexVirtualFileCache
implements Disposable {
    private final LoadingCache<Key, GitIndexVirtualFile> cache;
    private final Project project;

    @NotNull
    public final GitIndexVirtualFile get(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            Object object = this.cache.get((Object)new Key(root, filePath));
            Intrinsics.checkNotNull((Object)object);
            return (GitIndexVirtualFile)((Object)object);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            throw (Throwable)e;
        }
    }

    @NotNull
    public final List<GitIndexVirtualFile> filesMatching(@NotNull Function1<? super GitIndexVirtualFile, Boolean> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = this.cache.asMap().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitIndexVirtualFile file = (GitIndexVirtualFile)((Object)element$iv);
            boolean bl2 = false;
            GitIndexVirtualFile gitIndexVirtualFile = file;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitIndexVirtualFile), (String)"file");
            if (!((Boolean)function.invoke((Object)gitIndexVirtualFile)).booleanValue()) continue;
            result2.add(file);
        }
        return result2;
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    public GitIndexVirtualFileCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        LoadingCache loadingCache = Caffeine.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Key, GitIndexVirtualFile>(this){
            final /* synthetic */ GitIndexVirtualFileCache this$0;

            @Nullable
            public final GitIndexVirtualFile load(@NotNull Key key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new GitIndexVirtualFile(GitIndexVirtualFileCache.access$getProject$p(this.this$0), key.getRoot(), key.getFilePath());
            }
            {
                this.this$0 = gitIndexVirtualFileCache;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026oot, key.filePath)\n    })");
        this.cache = loadingCache;
    }

    public static final /* synthetic */ Project access$getProject$p(GitIndexVirtualFileCache $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFileCache$Key;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class Key {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        public Key(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final FilePath component2() {
            return this.filePath;
        }

        @NotNull
        public final Key copy(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new Key(root, filePath);
        }

        public static /* synthetic */ Key copy$default(Key key, VirtualFile virtualFile, FilePath filePath, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = key.root;
            }
            if ((n & 2) != 0) {
                filePath = key.filePath;
            }
            return key.copy(virtualFile, filePath);
        }

        @NotNull
        public String toString() {
            return "Key(root=" + this.root + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.root;
            FilePath filePath = this.filePath;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (filePath != null ? filePath.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Key)) break block3;
                    Key key = (Key)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)key.root) || !Intrinsics.areEqual((Object)this.filePath, (Object)key.filePath)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

