/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.impl.VcsFileStatusProvider;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFileBaseContentProvider;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentRevisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBaseRevision", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "file", "isSupported", "", "intellij.vcs.git"})
public final class GitIndexVirtualFileBaseContentProvider
implements VcsBaseContentProvider {
    private final Project project;

    public boolean isSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GitIndexVirtualFile;
    }

    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file;
        if (!(virtualFile instanceof GitIndexVirtualFile)) {
            virtualFile = null;
        }
        GitIndexVirtualFile gitIndexVirtualFile = (GitIndexVirtualFile)virtualFile;
        if (gitIndexVirtualFile == null) {
            return null;
        }
        GitIndexVirtualFile indexFile = gitIndexVirtualFile;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, indexFile);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            return null;
        }
        FilePath headPath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        VcsRevisionNumber vcsRevisionNumber = this.currentRevisionNumber(indexFile.getRoot());
        if (vcsRevisionNumber == null) {
            return null;
        }
        VcsRevisionNumber currentRevisionNumber = vcsRevisionNumber;
        return VcsFileStatusProvider.createBaseContent((Project)this.project, (ContentRevision)GitContentRevision.createRevision(headPath, currentRevisionNumber, this.project));
    }

    private final VcsRevisionNumber currentRevisionNumber(VirtualFile root) {
        GitRevisionNumber gitRevisionNumber;
        String currentRevision;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        String string = currentRevision = gitRepository != null ? gitRepository.getCurrentRevision() : null;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            gitRevisionNumber = new GitRevisionNumber(it);
        } else {
            gitRevisionNumber = null;
        }
        return (VcsRevisionNumber)gitRevisionNumber;
    }

    public GitIndexVirtualFileBaseContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

