/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexFileSystemRefresherKt;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileCache;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitUntrackedFilesHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b0\u001aJ1\u0010\u0018\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001b2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lgit4idea/index/vfs/GitIndexVirtualFileCache;", "changeContent", "", "file", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "requestor", "", "modificationStamp", "", "writeCommand", "Lkotlin/Function0;", "changeContent$intellij_vcs_git", "dispose", "getFile", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "refresh", "condition", "Lkotlin/Function1;", "", "filesToRefresh", "", "async", "postRunnable", "Ljava/lang/Runnable;", "refresh$intellij_vcs_git", "Companion", "RefreshSession", "intellij.vcs.git"})
public final class GitIndexFileSystemRefresher
implements Disposable {
    private final GitIndexVirtualFileCache cache;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final GitIndexVirtualFile getFile(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.cache.get(root, filePath);
    }

    public final void refresh(@NotNull Function1<? super GitIndexVirtualFile, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        List<GitIndexVirtualFile> filesToRefresh = this.cache.filesMatching(condition);
        if (filesToRefresh.isEmpty()) {
            return;
        }
        GitIndexFileSystemRefresher.refresh$intellij_vcs_git$default(this, filesToRefresh, false, null, 6, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void refresh$intellij_vcs_git(@NotNull List<GitIndexVirtualFile> filesToRefresh, boolean async, @Nullable Runnable postRunnable) {
        RefreshSession session;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(filesToRefresh, (String)"filesToRefresh");
                LOG.debug("Creating " + (async ? "async" : "sync") + " refresh session for " + CollectionsKt.joinToString$default((Iterable)filesToRefresh, null, null, null, (int)0, null, (Function1)refresh.1.INSTANCE, (int)31, null));
                session = new RefreshSession(filesToRefresh, postRunnable);
                if (async) break block4;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isDispatchThread()) break block5;
            }
            Future<?> refresh2 = AppExecutorUtil.getAppExecutorService().submit(new Runnable(session){
                final /* synthetic */ RefreshSession $session;

                public final void run() {
                    this.$session.read();
                    GitIndexFileSystemRefresherKt.writeInEdt((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ refresh.refresh.1 this$0;

                        public final void invoke() {
                            this.this$0.$session.apply();
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.$session = refreshSession;
                }
            });
            if (async) return;
            refresh2.get();
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isWriteAccessAllowed()) {
            new PotemkinProgress(GitBundle.message("stage.vfs.refresh.process", new Object[0]), this.project, null, null).runInBackground(new Runnable(session){
                final /* synthetic */ RefreshSession $session;

                public final void run() {
                    this.$session.read();
                }
                {
                    this.$session = refreshSession;
                }
            });
            session.apply();
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(session){
            final /* synthetic */ RefreshSession $session;

            public final void run() {
                this.$session.read();
            }
            {
                this.$session = refreshSession;
            }
        }, GitBundle.message("stage.vfs.refresh.process", new Object[0]), false, this.project);
        ApplicationManager.getApplication().runWriteAction(new Runnable(session){
            final /* synthetic */ RefreshSession $session;

            public final void run() {
                this.$session.apply();
            }
            {
                this.$session = refreshSession;
            }
        });
    }

    public static /* synthetic */ void refresh$intellij_vcs_git$default(GitIndexFileSystemRefresher gitIndexFileSystemRefresher, List list2, boolean bl, Runnable runnable2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            runnable2 = null;
        }
        gitIndexFileSystemRefresher.refresh$intellij_vcs_git(list2, bl, runnable2);
    }

    @RequiresWriteLock
    public final void changeContent$intellij_vcs_git(@NotNull GitIndexVirtualFile file, @Nullable Object requestor, long modificationStamp, @NotNull Function0<Unit> writeCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter(writeCommand, (String)"writeCommand");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, (VirtualFile)file, file.getModificationStamp(), modificationStamp, false);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).before(CollectionsKt.listOf((Object)event));
        new PotemkinProgress(GitBundle.message("stage.vfs.write.process", file.getName()), this.project, null, null).runInBackground(new Runnable(writeCommand){
            final /* synthetic */ Function0 $writeCommand;

            public final void run() {
                this.$writeCommand.invoke();
            }
            {
                this.$writeCommand = function0;
            }
        });
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        ((BulkFileListener)application2.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(CollectionsKt.listOf((Object)event));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.cache);
    }

    public GitIndexFileSystemRefresher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new GitIndexVirtualFileCache(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $this$mapTo$iv$iv;
                GitRepository repo;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
                List<GitRepository> list2 = gitRepositoryManager.getRepositories();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block6: {
                        repo = (GitRepository)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = events;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                VFileEvent e = (VFileEvent)element$iv;
                                boolean bl3 = false;
                                if (!GitUntrackedFilesHolder.indexChanged(repo, e.getPath())) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    repo = (GitRepository)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    VirtualFile virtualFile = v3.getRoot();
                    collection.add(virtualFile);
                }
                List roots = (List)destination$iv$iv;
                Collection collection = roots;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    LOG.debug("Scheduling refresh for roots " + CollectionsKt.joinToString$default((Iterable)roots, null, null, null, (int)0, null, (Function1)after.1.INSTANCE, (int)31, null));
                    this.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(roots){
                        final /* synthetic */ List $roots;

                        public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                            return this.$roots.contains(it.getRoot());
                        }
                        {
                            this.$roots = list2;
                            super(1);
                        }
                    }));
                }
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(final @NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Logger logger = LOG;
                StringBuilder stringBuilder = new StringBuilder().append("Scheduling refresh for repository ");
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
                logger.debug(stringBuilder.append(virtualFile.getName()).toString());
                this.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(){

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return Intrinsics.areEqual((Object)it.getRoot(), (Object)repository.getRoot());
                    }
                }));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitIndexFileSystemRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitIn\u2026temRefresher::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
        Companion.refreshVirtualFiles(project, paths);
    }

    @JvmStatic
    public static final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Companion.refreshRoots(project, roots);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$RefreshSession;", "", "filesToRefresh", "", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "postRunnable", "Ljava/lang/Runnable;", "(Ljava/util/List;Ljava/lang/Runnable;)V", "refreshList", "", "Lgit4idea/index/vfs/GitIndexVirtualFile$Refresh;", "apply", "", "read", "intellij.vcs.git"})
    private static final class RefreshSession {
        private final List<GitIndexVirtualFile.Refresh> refreshList;
        private final List<GitIndexVirtualFile> filesToRefresh;
        private final Runnable postRunnable;

        public final void read() {
            Logger logger = LOG;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            logger.assertTrue(!application.isDispatchThread());
            for (GitIndexVirtualFile file : this.filesToRefresh) {
                GitIndexVirtualFile.Refresh refresh2;
                if (file.getRefresh$intellij_vcs_git() == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                GitIndexVirtualFile.Refresh it = refresh2;
                boolean bl3 = false;
                this.refreshList.add(it);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void apply() {
            block4: {
                void $this$mapTo$iv$iv;
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                if (this.refreshList.isEmpty()) {
                    Runnable runnable2 = this.postRunnable;
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                    return;
                }
                Iterable $this$map$iv = this.refreshList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GitIndexVirtualFile.Refresh refresh2 = (GitIndexVirtualFile.Refresh)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    VFileContentChangeEvent vFileContentChangeEvent = it.getEvent();
                    collection.add(vFileContentChangeEvent);
                }
                List events = (List)destination$iv$iv;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                ((BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).before(events);
                Iterable $this$forEach$iv = this.refreshList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GitIndexVirtualFile.Refresh it = (GitIndexVirtualFile.Refresh)element$iv;
                    boolean bl = false;
                    it.run();
                }
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                ((BulkFileListener)application2.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(events);
                Runnable runnable3 = this.postRunnable;
                if (runnable3 == null) break block4;
                runnable3.run();
            }
        }

        public RefreshSession(@NotNull List<GitIndexVirtualFile> filesToRefresh, @Nullable Runnable postRunnable) {
            Intrinsics.checkNotNullParameter(filesToRefresh, (String)"filesToRefresh");
            this.filesToRefresh = filesToRefresh;
            this.postRunnable = postRunnable;
            boolean bl = false;
            this.refreshList = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000fH\u0007J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0007J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "project", "Lcom/intellij/openapi/project/Project;", "refreshFilePaths", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshRoots", "roots", "refreshVirtualFiles", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GitIndexFileSystemRefresher.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (GitIndexFileSystemRefresher)object;
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Set pathsSet = CollectionsKt.toSet((Iterable)paths);
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(pathsSet){
                    final /* synthetic */ Set $pathsSet;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$pathsSet.contains(it.getFilePath());
                    }
                    {
                        this.$pathsSet = set;
                        super(1);
                    }
                }));
            }
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(paths){
                    final /* synthetic */ Map $paths;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        Collection collection = (Collection)this.$paths.get(it.getRoot());
                        return collection != null && collection.contains(it.getFilePath());
                    }
                    {
                        this.$paths = map2;
                        super(1);
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
            Collection<FilePath> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable iterable = paths;
            Project project2 = project;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)p1);
                collection.add(filePath);
            }
            collection = (List)destination$iv$iv;
            companion.refreshFilePaths(project2, (Collection<? extends FilePath>)collection);
        }

        @JvmStatic
        public final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(roots){
                    final /* synthetic */ Collection $roots;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$roots.contains(it.getRoot());
                    }
                    {
                        this.$roots = collection;
                        super(1);
                    }
                }));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

