/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import git4idea.index.GitFileStatus;
import git4idea.index.GitIndexStatusUtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lgit4idea/index/ui/NodeKind;", "", "key", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKey", "()Ljava/lang/String;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "origPath", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/openapi/vcs/FileStatus;", "STAGED", "UNSTAGED", "CONFLICTED", "UNTRACKED", "IGNORED", "Companion", "intellij.vcs.git"})
public abstract class NodeKind
extends Enum<NodeKind> {
    public static final /* enum */ NodeKind STAGED;
    public static final /* enum */ NodeKind UNSTAGED;
    public static final /* enum */ NodeKind CONFLICTED;
    public static final /* enum */ NodeKind UNTRACKED;
    public static final /* enum */ NodeKind IGNORED;
    private static final /* synthetic */ NodeKind[] $VALUES;
    @NotNull
    private final String key;
    @NotNull
    private static final Map<NodeKind, Integer> sortOrder;
    @NotNull
    public static final Companion Companion;

    static {
        NodeKind[] nodeKindArray = new NodeKind[5];
        NodeKind[] nodeKindArray2 = nodeKindArray;
        nodeKindArray[0] = STAGED = new STAGED("STAGED", 0);
        nodeKindArray[1] = UNSTAGED = new UNSTAGED("UNSTAGED", 1);
        nodeKindArray[2] = CONFLICTED = new CONFLICTED("CONFLICTED", 2);
        nodeKindArray[3] = UNTRACKED = new UNTRACKED("UNTRACKED", 3);
        nodeKindArray[4] = IGNORED = new IGNORED("IGNORED", 4);
        $VALUES = nodeKindArray;
        Companion = new Companion(null);
        sortOrder = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)CollectionsKt.listOf((Object[])new NodeKind[]{CONFLICTED, STAGED, UNSTAGED, UNTRACKED, IGNORED}), (Iterable)((Iterable)ArraysKt.getIndices((Object[])NodeKind.values()))));
    }

    public abstract boolean is(@NotNull GitFileStatus var1);

    @NotNull
    public abstract FileStatus status(@NotNull GitFileStatus var1);

    @Nullable
    public FilePath origPath(@NotNull GitFileStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return null;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    private NodeKind(String key) {
        this.key = key;
    }

    public /* synthetic */ NodeKind(String $enum$name, int $enum$ordinal, String key, DefaultConstructorMarker $constructor_marker) {
        this(key);
    }

    public static NodeKind[] values() {
        return (NodeKind[])$VALUES.clone();
    }

    public static NodeKind valueOf(String string) {
        return Enum.valueOf(NodeKind.class, string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/NodeKind$STAGED;", "Lgit4idea/index/ui/NodeKind;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "origPath", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/openapi/vcs/FileStatus;", "intellij.vcs.git"})
    static final class STAGED
    extends NodeKind {
        @Override
        public boolean is(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status.getStagedStatus() != null;
        }

        @Override
        @NotNull
        public FileStatus status(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            FileStatus fileStatus = status.getStagedStatus();
            Intrinsics.checkNotNull((Object)fileStatus);
            return fileStatus;
        }

        @Override
        @Nullable
        public FilePath origPath(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return GitIndexStatusUtilKt.isRenamed(status.getIndex()) ? status.getOrigPath() : null;
        }

        /*
         * WARNING - void declaration
         */
        STAGED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/NodeKind$UNSTAGED;", "Lgit4idea/index/ui/NodeKind;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "origPath", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/openapi/vcs/FileStatus;", "intellij.vcs.git"})
    static final class UNSTAGED
    extends NodeKind {
        @Override
        public boolean is(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status.getUnStagedStatus() != null;
        }

        @Override
        @NotNull
        public FileStatus status(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            FileStatus fileStatus = status.getUnStagedStatus();
            Intrinsics.checkNotNull((Object)fileStatus);
            return fileStatus;
        }

        @Override
        @Nullable
        public FilePath origPath(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return GitIndexStatusUtilKt.isRenamed(status.getWorkTree()) ? status.getOrigPath() : null;
        }

        /*
         * WARNING - void declaration
         */
        UNSTAGED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0004\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/index/ui/NodeKind$CONFLICTED;", "Lgit4idea/index/ui/NodeKind;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "Lcom/intellij/openapi/vcs/FileStatus;", "kotlin.jvm.PlatformType", "intellij.vcs.git"})
    static final class CONFLICTED
    extends NodeKind {
        @Override
        public boolean is(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status.isConflicted();
        }

        @Override
        public FileStatus status(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return FileStatus.MERGED_WITH_CONFLICTS;
        }

        /*
         * WARNING - void declaration
         */
        CONFLICTED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0004\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/index/ui/NodeKind$UNTRACKED;", "Lgit4idea/index/ui/NodeKind;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "Lcom/intellij/openapi/vcs/FileStatus;", "kotlin.jvm.PlatformType", "intellij.vcs.git"})
    static final class UNTRACKED
    extends NodeKind {
        @Override
        public boolean is(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status.isUntracked();
        }

        @Override
        public FileStatus status(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return FileStatus.UNKNOWN;
        }

        /*
         * WARNING - void declaration
         */
        UNTRACKED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0004\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/index/ui/NodeKind$IGNORED;", "Lgit4idea/index/ui/NodeKind;", "is", "", "status", "Lgit4idea/index/GitFileStatus;", "Lcom/intellij/openapi/vcs/FileStatus;", "kotlin.jvm.PlatformType", "intellij.vcs.git"})
    static final class IGNORED
    extends NodeKind {
        @Override
        public boolean is(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return status.isIgnored();
        }

        @Override
        public FileStatus status(@NotNull GitFileStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return FileStatus.IGNORED;
        }

        /*
         * WARNING - void declaration
         */
        IGNORED() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/NodeKind$Companion;", "", "()V", "sortOrder", "", "Lgit4idea/index/ui/NodeKind;", "", "getSortOrder$intellij_vcs_git", "()Ljava/util/Map;", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final Map<NodeKind, Integer> getSortOrder$intellij_vcs_git() {
            return sortOrder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

