/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/actions/GitStageCompareWithVersionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "currentVersion", "Lgit4idea/index/ContentVersion;", "compareWithVersion", "(Lgit4idea/index/ContentVersion;Lgit4idea/index/ContentVersion;)V", "getCompareWithVersion", "()Lgit4idea/index/ContentVersion;", "getCurrentVersion", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createDiffRequest", "Lcom/intellij/diff/requests/DiffRequest;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lgit4idea/index/GitFileStatus;", "update", "intellij.vcs.git"})
public abstract class GitStageCompareWithVersionAction
extends DumbAwareAction {
    @NotNull
    private final ContentVersion currentVersion;
    @NotNull
    private final ContentVersion compareWithVersion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project) || file == null || file instanceof GitIndexVirtualFile != (this.currentVersion == ContentVersion.STAGED)) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus status = GitStageTrackerKt.status(gitStageTracker, file);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(status != null);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        GitFileStatus gitFileStatus = status;
        presentation2.setEnabled(gitFileStatus != null && GitFileStatusKt.has(gitFileStatus, this.compareWithVersion));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
        Project project2 = project;
        Object object = e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.VIRTUAL_FILE)");
        VirtualFile file = (VirtualFile)object;
        VirtualFile virtualFile = GitStageTrackerKt.getRoot(project2, file);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, root, file);
        if (gitFileStatus == null) {
            return;
        }
        GitFileStatus status = gitFileStatus;
        DiffRequestProducer diffRequestProducer = SimpleDiffRequestProducer.create((FilePath)GitIndexVirtualFileKt.filePath(file), (ThrowableComputable)((ThrowableComputable)new ThrowableComputable<DiffRequest, Throwable>(this, project2, root, status){
            final /* synthetic */ GitStageCompareWithVersionAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ GitFileStatus $status;

            public final DiffRequest compute() {
                return this.this$0.createDiffRequest(this.$project, this.$root, this.$status);
            }
            {
                this.this$0 = gitStageCompareWithVersionAction;
                this.$project = project;
                this.$root = virtualFile;
                this.$status = gitFileStatus;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestProducer, (String)"SimpleDiffRequestProduce\u2026ect, root, status)\n    })");
        DiffRequestProducer producer2 = diffRequestProducer;
        DiffManager.getInstance().showDiff(e.getProject(), (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer2), DiffDialogHints.DEFAULT);
    }

    @NotNull
    public abstract DiffRequest createDiffRequest(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GitFileStatus var3);

    @NotNull
    public final ContentVersion getCurrentVersion() {
        return this.currentVersion;
    }

    @NotNull
    public final ContentVersion getCompareWithVersion() {
        return this.compareWithVersion;
    }

    public GitStageCompareWithVersionAction(@NotNull ContentVersion currentVersion, @NotNull ContentVersion compareWithVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentVersion), (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)compareWithVersion), (String)"compareWithVersion");
        this.currentVersion = currentVersion;
        this.compareWithVersion = compareWithVersion;
    }
}

