/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import git4idea.GitVcs;
import git4idea.config.GitVcsApplicationSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"canEnableStagingArea", "", "enableStagingArea", "", "enabled", "isStagingAreaAvailable", "project", "Lcom/intellij/openapi/project/Project;", "stageLineStatusTrackerRegistryOption", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
public final class GitStageManagerKt {
    @NotNull
    public static final RegistryValue stageLineStatusTrackerRegistryOption() {
        RegistryValue registryValue = Registry.get((String)"git.enable.stage.line.status.tracker");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(\"git.enable\u2026age.line.status.tracker\")");
        return registryValue;
    }

    public static final void enableStagingArea(boolean enabled) {
        GitVcsApplicationSettings applicationSettings;
        GitVcsApplicationSettings gitVcsApplicationSettings = applicationSettings = GitVcsApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gitVcsApplicationSettings, (String)"applicationSettings");
        if (enabled == gitVcsApplicationSettings.isStagingAreaEnabled()) {
            return;
        }
        applicationSettings.setStagingAreaEnabled(enabled);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((CommitModeManager.SettingsListener)application.getMessageBus().syncPublisher(CommitModeManager.SETTINGS)).settingsChanged();
    }

    public static final boolean canEnableStagingArea() {
        return CommitModeManager.Companion.isNonModalInSettings();
    }

    public static final boolean isStagingAreaAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommitMode commitMode = CommitModeManager.Companion.getInstance(project).getCurrentCommitMode();
        return commitMode instanceof CommitMode.ExternalCommitMode && Intrinsics.areEqual((Object)((CommitMode.ExternalCommitMode)commitMode).getVcs().getKeyInstanceMethod(), (Object)GitVcs.getKey());
    }
}

