/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageLineStatusTracker;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u001c\u0010\u0014\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001a\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016\u00a8\u0006\u001c"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "()V", "createTracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "handleLoadingError", "", "tracker", "isMyTracker", "", "isTrackedFile", "loadContent", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "info", "setLoadedContent", "content", "shouldBeUpdated", "oldInfo", "newInfo", "Companion", "StagedContentInfo", "StagedTrackerContent", "intellij.vcs.git"})
public final class GitStageLineStatusTrackerProvider
implements LineStatusTrackerContentLoader {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public boolean isMyTracker(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return tracker instanceof GitStageLineStatusTracker;
    }

    public boolean isTrackedFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (!GitStageManagerKt.isStagingAreaAvailable(project)) {
            return false;
        }
        if (!GitStageManagerKt.stageLineStatusTrackerRegistryOption().asBoolean()) {
            return false;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
        return repository != null;
    }

    @Nullable
    public LocalLineStatusTracker<?> createTracker(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, file);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (!(status.isTracked() && GitFileStatusKt.has(status, ContentVersion.STAGED) && GitFileStatusKt.has(status, ContentVersion.LOCAL))) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(file)");
        FilePath filePath2 = filePath;
        if (GitContentRevision.getRepositoryIfSubmodule(project, filePath2) != null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document document2 = document;
        return new GitStageLineStatusTracker(project, file, document2);
    }

    @Nullable
    public LineStatusTrackerContentLoader.ContentInfo getContentInfo(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026File(file) ?: return null");
        GitRepository repository = gitRepository;
        String string = repository.getCurrentRevision();
        Charset charset = file.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"file.charset");
        return new StagedContentInfo(string, charset, file);
    }

    public boolean shouldBeUpdated(@Nullable LineStatusTrackerContentLoader.ContentInfo oldInfo, @NotNull LineStatusTrackerContentLoader.ContentInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        StagedContentInfo cfr_ignored_0 = (StagedContentInfo)newInfo;
        return oldInfo == null || !(oldInfo instanceof StagedContentInfo) || Intrinsics.areEqual((Object)((StagedContentInfo)oldInfo).getCurrentRevision(), (Object)((StagedContentInfo)newInfo).getCurrentRevision()) ^ true || Intrinsics.areEqual((Object)((StagedContentInfo)oldInfo).getCharset(), (Object)((StagedContentInfo)newInfo).getCharset()) ^ true;
    }

    @Nullable
    public LineStatusTrackerContentLoader.TrackerContent loadContent(@NotNull Project project, @NotNull LineStatusTrackerContentLoader.ContentInfo info) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        StagedContentInfo cfr_ignored_0 = (StagedContentInfo)info;
        VirtualFile file = ((StagedContentInfo)info).getVirtualFile();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(file)");
        FilePath filePath2 = filePath;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"GitStageTracker.getInstance(project)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, file);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (GitContentRevision.getRepositoryIfSubmodule(project, filePath2) != null) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026File(file) ?: return null");
        GitRepository repository = gitRepository;
        GitIndexFileSystemRefresher indexFileRefresher = GitIndexFileSystemRefresher.Companion.getInstance(project);
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        GitIndexVirtualFile indexFile = indexFileRefresher.getFile(virtualFile, GitFileStatusKt.path(status, ContentVersion.STAGED));
        boolean $i$f$runReadAction = false;
        Document document = (Document)ApplicationManager.getApplication().runReadAction(new Computable<T>(indexFile){
            final /* synthetic */ GitIndexVirtualFile $indexFile$inlined;
            {
                this.$indexFile$inlined = gitIndexVirtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)FileDocumentManager.getInstance().getDocument((VirtualFile)this.$indexFile$inlined);
            }
        });
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"runReadAction { FileDocu\u2026dexFile) } ?: return null");
        Document indexDocument = document;
        indexDocument.putUserData(LineStatusTrackerBase.Companion.getSEPARATE_UNDO_STACK(), (Object)Registry.is((String)"git.stage.separate.undo.stack"));
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            return new StagedTrackerContent("", indexDocument);
        }
        try {
            byte[] bytes = GitFileUtils.getFileContent(project, repository.getRoot(), "HEAD", VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (FilePath)GitFileStatusKt.path(status, ContentVersion.HEAD)));
            Charset charset = DiffContentFactoryImpl.guessCharset((Project)project, (byte[])bytes, (FilePath)filePath2);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"DiffContentFactoryImpl.g\u2026project, bytes, filePath)");
            Charset charset2 = charset;
            String string = CharsetToolkit.decodeString((byte[])bytes, (Charset)charset2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CharsetToolkit.decodeString(bytes, charset)");
            String headContent = string;
            String string2 = StringUtil.convertLineSeparators((String)headContent);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.convertLineSeparators(headContent)");
            String correctedText = string2;
            return new StagedTrackerContent(correctedText, indexDocument);
        }
        catch (VcsException e) {
            LOG.warn("Can't load base revision content for " + file.getPath() + " with status " + status, (Throwable)e);
            return null;
        }
    }

    public void setLoadedContent(@NotNull LocalLineStatusTracker<?> tracker, @NotNull LineStatusTrackerContentLoader.TrackerContent content2) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        GitStageLineStatusTracker cfr_ignored_0 = (GitStageLineStatusTracker)tracker;
        StagedTrackerContent cfr_ignored_1 = (StagedTrackerContent)content2;
        ((GitStageLineStatusTracker)tracker).setBaseRevision(((StagedTrackerContent)content2).getVcsContent(), ((StagedTrackerContent)content2).getStagedDocument());
    }

    public void handleLoadingError(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        GitStageLineStatusTracker cfr_ignored_0 = (GitStageLineStatusTracker)tracker;
        ((GitStageLineStatusTracker)tracker).dropBaseRevision();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitStageLineStatusTrackerProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitSt\u2026ckerProvider::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$StagedContentInfo;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "currentRevision", "", "charset", "Ljava/nio/charset/Charset;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Ljava/nio/charset/Charset;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getCurrentRevision", "()Ljava/lang/String;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
    private static final class StagedContentInfo
    implements LineStatusTrackerContentLoader.ContentInfo {
        @Nullable
        private final String currentRevision;
        @NotNull
        private final Charset charset;
        @NotNull
        private final VirtualFile virtualFile;

        @Nullable
        public final String getCurrentRevision() {
            return this.currentRevision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        public StagedContentInfo(@Nullable String currentRevision, @NotNull Charset charset, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            this.currentRevision = currentRevision;
            this.charset = charset;
            this.virtualFile = virtualFile;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$StagedTrackerContent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "vcsContent", "", "stagedDocument", "Lcom/intellij/openapi/editor/Document;", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/editor/Document;)V", "getStagedDocument", "()Lcom/intellij/openapi/editor/Document;", "getVcsContent", "()Ljava/lang/CharSequence;", "intellij.vcs.git"})
    private static final class StagedTrackerContent
    implements LineStatusTrackerContentLoader.TrackerContent {
        @NotNull
        private final CharSequence vcsContent;
        @NotNull
        private final Document stagedDocument;

        @NotNull
        public final CharSequence getVcsContent() {
            return this.vcsContent;
        }

        @NotNull
        public final Document getStagedDocument() {
            return this.stagedDocument;
        }

        public StagedTrackerContent(@NotNull CharSequence vcsContent, @NotNull Document stagedDocument) {
            Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
            Intrinsics.checkNotNullParameter((Object)stagedDocument, (String)"stagedDocument");
            this.vcsContent = vcsContent;
            this.stagedDocument = stagedDocument;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

