/*
 * Decompiled with CFR 0.152.
 */
package git4idea.console;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.console.VcsConsoleFolding;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/console/GitConsoleFolding;", "Lcom/intellij/vcs/console/VcsConsoleFolding;", "()V", "getFoldingsForLine", "", "Lcom/intellij/vcs/console/VcsConsoleFolding$Placeholder;", "project", "Lcom/intellij/openapi/project/Project;", "line", "", "isGitCommandLine", "", "Companion", "intellij.vcs.git"})
public final class GitConsoleFolding
implements VcsConsoleFolding {
    private static final Pattern CONFIG_OPTIONS_REGEX;
    private static final Pattern GIT_LINE_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<VcsConsoleFolding.Placeholder> getFoldingsForLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.isGitCommandLine(line)) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List result2 = new ArrayList();
        Matcher matcher = CONFIG_OPTIONS_REGEX.matcher(line);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"CONFIG_OPTIONS_REGEX.matcher(line)");
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            int end;
            int start = matcher2.start();
            if (start < (end = matcher2.end()) && StringUtil.isWhiteSpace((char)line.charAt(start))) {
                ++start;
            }
            if (start >= end) continue;
            result2.add(new VcsConsoleFolding.Placeholder("-c ...", new TextRange(start, end)));
        }
        return result2;
    }

    private final boolean isGitCommandLine(String line) {
        return GIT_LINE_REGEX.matcher(line).find();
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(\\s-c\\s[\\w.]+=[^ ]*)+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"(\\\\s-c\\\\s[\\\\w.]+=[^ ]*)+\")");
        CONFIG_OPTIONS_REGEX = pattern;
        Pattern pattern2 = Pattern.compile("\\[.*] git ");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"Pattern.compile(\"\\\\[.*] git \")");
        GIT_LINE_REGEX = pattern2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/console/GitConsoleFolding$Companion;", "", "()V", "CONFIG_OPTIONS_REGEX", "Ljava/util/regex/Pattern;", "GIT_LINE_REGEX", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

