/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MergeConflictResolveUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitConflict;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\bH\u0001\u001a:\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0000\u00a8\u0006\u0014"}, d2={"acceptConflictSide", "", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lgit4idea/conflicts/GitMergeHandler;", "selectedConflicts", "", "Lgit4idea/repo/GitConflict;", "takeTheirs", "", "isReversed", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "conflict", "getConflictType", "", "showMergeWindow", "intellij.vcs.git"})
public final class GitConflictsPanelKt {
    @NotNull
    public static final BackgroundableActionLock getConflictOperationLock(@NotNull Project project, @NotNull GitConflict conflict2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)conflict2, (String)"conflict");
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock((Project)project, (Object[])new Object[]{conflict2.getFilePath()});
        Intrinsics.checkNotNullExpressionValue((Object)backgroundableActionLock, (String)"BackgroundableActionLock\u2026oject, conflict.filePath)");
        return backgroundableActionLock;
    }

    /*
     * WARNING - void declaration
     */
    public static final void acceptConflictSide(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts, boolean takeTheirs, @NotNull Function1<? super VirtualFile, Boolean> isReversed) {
        void $this$mapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        Intrinsics.checkNotNullParameter(isReversed, (String)"isReversed");
        Iterable $this$filterNot$iv = selectedConflicts;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            GitConflict it = (GitConflict)element$iv$iv;
            boolean bl = false;
            if (GitConflictsPanelKt.getConflictOperationLock(project, it).isLocked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (conflicts.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = conflicts;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitConflict bl = (GitConflict)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            BackgroundableActionLock backgroundableActionLock = GitConflictsPanelKt.getConflictOperationLock(project, (GitConflict)it);
            collection.add(backgroundableActionLock);
        }
        List locks = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = locks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
            boolean bl = false;
            it.lock();
        }
        new Task.Backgroundable(conflicts, isReversed, handler, takeTheirs, locks, project, project, GitBundle.message("conflicts.accept.progress", conflicts.size()), true){
            final /* synthetic */ List $conflicts;
            final /* synthetic */ Function1 $isReversed;
            final /* synthetic */ GitMergeHandler $handler;
            final /* synthetic */ boolean $takeTheirs;
            final /* synthetic */ List $locks;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void destination$iv;
                Iterable $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable iterable = this.$conflicts;
                boolean bl = false;
                Collection collection = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    GitConflict gitConflict = (GitConflict)item$iv;
                    void var11_12 = destination$iv;
                    boolean bl2 = false;
                    VirtualFile virtualFile = it.getRoot();
                    var11_12.add(virtualFile);
                }
                $this$mapTo$iv = (Iterable)destination$iv;
                Function1 predicate$iv = this.$isReversed;
                boolean $i$f$filter = false;
                Iterator<T> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List reversedRoots = (List)destination$iv$iv;
                this.$handler.acceptOneVersion(this.$conflicts, reversedRoots, this.$takeTheirs);
            }

            public void onFinished() {
                Iterable $this$forEach$iv = this.$locks;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
                    boolean bl = false;
                    it.unlock();
                }
            }
            {
                this.$conflicts = $captured_local_variable$0;
                this.$isReversed = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
                this.$takeTheirs = $captured_local_variable$3;
                this.$locks = $captured_local_variable$4;
                this.$project = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    public static final void showMergeWindow(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts, @NotNull Function1<? super VirtualFile, Boolean> isReversed) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        Intrinsics.checkNotNullParameter(isReversed, (String)"isReversed");
        Iterable $this$filter$iv = selectedConflicts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitConflict it = (GitConflict)element$iv$iv;
            boolean bl = false;
            if (!(handler.canResolveConflict(it) && !GitConflictsPanelKt.getConflictOperationLock(project, it).isLocked())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (conflicts.isEmpty()) {
            return;
        }
        for (GitConflict conflict2 : conflicts) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            FilePath filePath = conflict2.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"conflict.filePath");
            VirtualFile file = localFileSystem.refreshAndFindFileByPath(filePath.getPath());
            if (file == null) {
                VcsNotifier.getInstance((Project)project).notifyError("git.cannot.resolve.conflict", GitBundle.message("conflicts.merge.window.error.title", new Object[0]), GitBundle.message("conflicts.merge.window.error.message", conflict2.getFilePath()));
                continue;
            }
            BackgroundableActionLock lock = GitConflictsPanelKt.getConflictOperationLock(project, conflict2);
            MergeConflictResolveUtil.INSTANCE.showMergeWindow(project, file, lock, (Function0<GitMergeHandler.Resolver>)((Function0)new Function0<GitMergeHandler.Resolver>(handler, conflict2, file, isReversed){
                final /* synthetic */ GitMergeHandler $handler;
                final /* synthetic */ GitConflict $conflict;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Function1 $isReversed;

                @NotNull
                public final GitMergeHandler.Resolver invoke() {
                    VirtualFile virtualFile = this.$conflict.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"conflict.root");
                    GitMergeHandler.Resolver resolver = this.$handler.resolveConflict(this.$conflict, this.$file, (Boolean)this.$isReversed.invoke((Object)virtualFile));
                    Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"handler.resolveConflict(\u2026sReversed(conflict.root))");
                    return resolver;
                }
                {
                    this.$handler = gitMergeHandler;
                    this.$conflict = gitConflict;
                    this.$file = virtualFile;
                    this.$isReversed = function1;
                    super(0);
                }
            }));
        }
    }

    @Nls
    @NotNull
    public static final String getConflictType(@NotNull GitConflict conflict2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)conflict2, (String)"conflict");
        GitConflict.Status status = conflict2.getStatus(GitConflict.ConflictSide.OURS, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)status), (String)"conflict.getStatus(ConflictSide.OURS, true)");
        GitConflict.Status oursStatus = status;
        GitConflict.Status status2 = conflict2.getStatus(GitConflict.ConflictSide.THEIRS, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)status2), (String)"conflict.getStatus(ConflictSide.THEIRS, true)");
        GitConflict.Status theirsStatus = status2;
        if (oursStatus == GitConflict.Status.DELETED && theirsStatus == GitConflict.Status.DELETED) {
            String string2 = GitBundle.message("conflicts.type.both.deleted", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"conflicts.type.both.deleted\")");
        } else if (oursStatus == GitConflict.Status.ADDED && theirsStatus == GitConflict.Status.ADDED) {
            String string3 = GitBundle.message("conflicts.type.both.added", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"conflicts.type.both.added\")");
        } else if (oursStatus == GitConflict.Status.MODIFIED && theirsStatus == GitConflict.Status.MODIFIED) {
            String string4 = GitBundle.message("conflicts.type.both.modified", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GitBundle.message(\"conflicts.type.both.modified\")");
        } else if (oursStatus == GitConflict.Status.DELETED) {
            String string5 = GitBundle.message("conflicts.type.deleted.by.you", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"GitBundle.message(\"conflicts.type.deleted.by.you\")");
        } else if (theirsStatus == GitConflict.Status.DELETED) {
            String string6 = GitBundle.message("conflicts.type.deleted.by.them", new Object[0]);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"GitBundle.message(\"confl\u2026ts.type.deleted.by.them\")");
        } else if (oursStatus == GitConflict.Status.ADDED) {
            String string7 = GitBundle.message("conflicts.type.added.by.you", new Object[0]);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"GitBundle.message(\"conflicts.type.added.by.you\")");
        } else if (theirsStatus == GitConflict.Status.ADDED) {
            String string8 = GitBundle.message("conflicts.type.added.by.them", new Object[0]);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"GitBundle.message(\"conflicts.type.added.by.them\")");
        } else {
            throw (Throwable)new IllegalStateException("ours: " + (Object)((Object)oursStatus) + "; theirs: " + (Object)((Object)theirsStatus));
        }
        return string;
    }
}

