/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.GuiUtils;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(0);
        }
        return (GitExecutableProblemsNotifier)project.getService(GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(2);
        }
        GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(this.myProject);
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(this.myProject);
        problemHandler.showError(exception, errorNotifier);
    }

    static void notify(@NotNull Project project, @NotNull BadGitExecutableNotification notification) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(3);
        }
        if (notification == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(4);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (GitExecutableProblemsNotifier.ensureSingularOfType(project, ((Object)((Object)notification)).getClass())) {
                notification.notify(project);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private static boolean ensureSingularOfType(@NotNull Project project, @NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications;
        int notificationsCount;
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(5);
        }
        if (notificationType == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(6);
        }
        if ((notificationsCount = (currentNotifications = (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, project)).length) <= 0) {
            return true;
        }
        for (int i2 = 0; i2 < notificationsCount - 1; ++i2) {
            currentNotifications[i2].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @Nls
    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(7);
        }
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? GitBundle.message("git.executable.error.file.not.found", cause.getMessage()) : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                String string = exception.getMessage();
                if (string == null) {
                    GitExecutableProblemsNotifier.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0]);
            if (string == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = errorMessage;
        if (string == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyExecutionError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureSingularOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyErrorMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle, @Nullable @NlsContexts.NotificationContent String content2, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            if (groupDisplayId == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(0);
            }
            if (type == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(1);
            }
            super(groupDisplayId, icon, title, subtitle, content2, type, listener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableProblemsNotifier$BadGitExecutableNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

