/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.config.DefaultExecutableProblemHandler;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVersion;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a)\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0000\u001a)\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0000\u001a\u0017\u0010\n\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u001a\r\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0000\u001a\u0015\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\r\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"findGitExecutableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "getErrorMessage", "", "Lorg/jetbrains/annotations/Nls;", "text", "description", "getErrorTitle", "getHumanReadableErrorFor", "exception", "", "getLinkToConfigure", "Lgit4idea/config/ErrorNotifier$FixOption;", "showUnsupportedVersionError", "", "version", "Lgit4idea/config/GitVersion;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "unsupportedVersionDescription", "unsupportedVersionMessage", "unsupportedWslVersionDescription", "dumpToString", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.vcs.git"})
public final class GitExecutableProblemHandlersKt {
    @NotNull
    public static final GitExecutableProblemHandler findGitExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SystemInfo.isWindows ? (GitExecutableProblemHandler)new WindowsExecutableProblemHandler(project) : (SystemInfo.isMac ? (GitExecutableProblemHandler)new MacExecutableProblemHandler(project) : (GitExecutableProblemHandler)new DefaultExecutableProblemHandler(project));
    }

    @RequiresEdt
    public static final void showUnsupportedVersionError(@NotNull Project project, @NotNull GitVersion version, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        String description = version.getType() == GitVersion.Type.WSL1 ? GitExecutableProblemHandlersKt.unsupportedWslVersionDescription() : GitExecutableProblemHandlersKt.unsupportedVersionDescription();
        errorNotifier.showError(GitExecutableProblemHandlersKt.unsupportedVersionMessage(version), description, GitExecutableProblemHandlersKt.getLinkToConfigure(project));
    }

    @NotNull
    public static final String unsupportedVersionMessage(@NotNull GitVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = GitBundle.message("git.executable.validation.error.version.title", version.getPresentation());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.e\u2026e\", version.presentation)");
        return string;
    }

    @NotNull
    public static final String unsupportedVersionDescription() {
        Object[] objectArray = new Object[1];
        GitVersion gitVersion = GitVersion.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"GitVersion.MIN");
        objectArray[0] = gitVersion.getPresentation();
        String string = GitBundle.message("git.executable.validation.error.version.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.e\u2026Version.MIN.presentation)");
        return string;
    }

    @NotNull
    public static final String unsupportedWslVersionDescription() {
        String string = GitBundle.message("git.executable.validation.error.wsl1.unsupported.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.e\u2026sl1.unsupported.message\")");
        return string;
    }

    @NotNull
    public static final ErrorNotifier.FixOption getLinkToConfigure(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ErrorNotifier.FixOption.Configure(project);
    }

    @NotNull
    public static final String dumpToString(@NotNull ProcessOutput $this$dumpToString) {
        Intrinsics.checkNotNullParameter((Object)$this$dumpToString, (String)"$this$dumpToString");
        return "output: " + $this$dumpToString.getStdout() + ", error output: " + $this$dumpToString.getStderr();
    }

    @NotNull
    public static final String getErrorTitle(@NotNull String text, @Nullable String description) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (description == null) {
            String string2 = GitBundle.message("git.executable.validation.error.start.title", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"git.e\u2026ation.error.start.title\")");
        } else {
            string = text;
        }
        return string;
    }

    @NotNull
    public static final String getErrorMessage(@NotNull String text, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = description;
        if (string == null) {
            string = text;
        }
        return string;
    }

    @Nullable
    public static final String getHumanReadableErrorFor(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof GitNotInstalledException) {
            return null;
        }
        return GitExecutableProblemsNotifier.getPrettyErrorMessage(exception);
    }
}

