/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitChangeUtils {
    @NonNls
    public static final String COMMITTED_CHANGELIST_FORMAT = "%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03";
    private static final Logger LOG = Logger.getInstance(GitChangeUtils.class);

    private GitChangeUtils() {
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, GitRevisionNumber parentRevision, String s, Collection<? super Change> changes) throws VcsException {
        GitChangeUtils.parseChanges(project, vcsRoot, thisRevision, parentRevision, new StringScanner(s), changes);
    }

    private static void parseChanges(Project project, VirtualFile vcsRoot, @Nullable GitRevisionNumber thisRevision, @Nullable GitRevisionNumber parentRevision, StringScanner s, Collection<? super Change> changes) throws VcsException {
        GitChangeUtils.parseChanges(vcsRoot, s, (status, beforePath, afterPath) -> {
            assert (beforePath != null || afterPath != null);
            ContentRevision before = beforePath != null ? GitContentRevision.createRevision(beforePath, (VcsRevisionNumber)parentRevision, project) : null;
            ContentRevision after2 = afterPath != null ? GitContentRevision.createRevision(afterPath, (VcsRevisionNumber)thisRevision, project) : null;
            changes.add(new Change(before, after2, status));
        });
    }

    private static void parseChanges(@NotNull VirtualFile vcsRoot, @NotNull StringScanner s, @NotNull FileStatusLineConsumer consumer2) throws VcsException {
        if (vcsRoot == null) {
            GitChangeUtils.$$$reportNull$$$0(0);
        }
        if (s == null) {
            GitChangeUtils.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            GitChangeUtils.$$$reportNull$$$0(2);
        }
        while (s.hasMoreData()) {
            FilePath after2;
            FilePath before;
            FileStatus status = null;
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            if ("CADUMRT".indexOf(s.peek()) == -1) {
                return;
            }
            String[] tokens = s.line().split("\t");
            String path = tokens[tokens.length - 1];
            FilePath filePath = GitContentRevision.createPathFromEscaped(vcsRoot, path);
            switch (tokens[0].charAt(0)) {
                case 'A': 
                case 'C': {
                    status = FileStatus.ADDED;
                    before = null;
                    after2 = filePath;
                    break;
                }
                case 'U': {
                    status = FileStatus.MERGED_WITH_CONFLICTS;
                }
                case 'M': {
                    if (status == null) {
                        status = FileStatus.MODIFIED;
                    }
                    before = filePath;
                    after2 = filePath;
                    break;
                }
                case 'D': {
                    status = FileStatus.DELETED;
                    before = filePath;
                    after2 = null;
                    break;
                }
                case 'R': {
                    status = FileStatus.MODIFIED;
                    before = GitContentRevision.createPathFromEscaped(vcsRoot, tokens[1]);
                    after2 = filePath;
                    break;
                }
                case 'T': {
                    status = FileStatus.MODIFIED;
                    before = filePath;
                    after2 = filePath;
                    break;
                }
                default: {
                    throw new VcsException(GitBundle.message("error.git.parse.unknown.file.status", Arrays.asList(tokens)));
                }
            }
            consumer2.consume(status, before, after2);
        }
    }

    @NotNull
    public static GitRevisionNumber resolveReference(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull @NonNls String reference) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(3);
        }
        if (vcsRoot == null) {
            GitChangeUtils.$$$reportNull$$$0(4);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(5);
        }
        GitLineHandler handler = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        StringTokenizer stk = new StringTokenizer(output, "\n\r \t", false);
        if (!stk.hasMoreTokens()) {
            try {
                GitLineHandler dh = new GitLineHandler(project, vcsRoot, GitCommand.LOG);
                dh.addParameters("-1", "HEAD");
                dh.setSilent(true);
                String out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git log -1 HEAD': [" + out + "]");
                dh = GitChangeUtils.createRefResolveHandler(project, vcsRoot, reference);
                out = Git.getInstance().runCommand(dh).getOutputOrThrow(new int[0]);
                LOG.info("Diagnostic output from 'git rev-list -1 --timestamp HEAD': [" + out + "]");
            }
            catch (VcsException e) {
                LOG.info("Exception while trying to get some diagnostics info", (Throwable)e);
            }
            throw new VcsException(GitBundle.message("error.git.parse.not.a.revision.number", reference));
        }
        Date timestamp = GitUtil.parseTimestampWithNFEReport(stk.nextToken(), handler, output);
        return new GitRevisionNumber(stk.nextToken(), timestamp);
    }

    @NotNull
    private static GitLineHandler createRefResolveHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String reference) {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(7);
        }
        if (reference == null) {
            GitChangeUtils.$$$reportNull$$$0(8);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_LIST);
        handler.addParameters("--timestamp", "--max-count=1", reference);
        handler.endOptions();
        handler.setSilent(true);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitChangeUtils.$$$reportNull$$$0(9);
        }
        return gitLineHandler;
    }

    public static GitCommittedChangeList getRevisionChanges(Project project, @NotNull VirtualFile root, @NonNls String revisionName, boolean skipDiffsForMerge, boolean local, boolean revertable) throws VcsException {
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(10);
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.SHOW);
        h2.setSilent(true);
        h2.addParameters("--name-status", "--first-parent", "--no-abbrev", "-M", "--pretty=format:%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--encoding=UTF-8", revisionName, "--");
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(output);
        return GitChangeUtils.parseChangeList(project, root, s, skipDiffsForMerge, h2, local, revertable);
    }

    public static GitCommittedChangeList parseChangeList(Project project, VirtualFile root, StringScanner s, boolean skipDiffsForMerge, GitHandler handler, boolean local, boolean revertable) throws VcsException {
        ArrayList<Change> changes = new ArrayList<Change>();
        Date commitDate = GitUtil.parseTimestampWithNFEReport(s.line(), handler, s.getAllText());
        String revisionNumber = s.line();
        String parentsLine = s.line();
        String[] parents = parentsLine.length() == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : parentsLine.split(" ");
        String authorName = s.line();
        String committerName = s.line();
        committerName = GitUtil.adjustAuthorName(authorName, committerName);
        String commentSubject = s.boundedToken('\u0003', true);
        s.nextLine();
        String commentBody = s.boundedToken('\u0003', true);
        Object fullComment = commentSubject.length() == 0 ? commentBody : (commentBody.length() == 0 ? commentSubject : commentSubject + "\n" + commentBody);
        GitRevisionNumber thisRevision = new GitRevisionNumber(revisionNumber, commitDate);
        if (skipDiffsForMerge || parents.length <= 1) {
            String[] parentRevision = parents.length > 0 ? GitChangeUtils.resolveReference(project, root, parents[0]) : null;
            GitChangeUtils.parseChanges(project, root, thisRevision, (GitRevisionNumber)(local ? null : parentRevision), s, changes);
        } else {
            for (String parent : parents) {
                GitRevisionNumber parentRevision = GitChangeUtils.resolveReference(project, root, parent);
                GitLineHandler diffHandler = new GitLineHandler(project, root, GitCommand.DIFF);
                diffHandler.setSilent(true);
                diffHandler.addParameters("--name-status", "-M", parentRevision.getRev(), thisRevision.getRev());
                String diff = Git.getInstance().runCommand(diffHandler).getOutputOrThrow(new int[0]);
                GitChangeUtils.parseChanges(project, root, thisRevision, parentRevision, diff, changes);
                if (changes.size() > 0) break;
            }
        }
        String changeListName = String.format("%s(%s)", commentSubject, revisionNumber);
        return new GitCommittedChangeList(changeListName, (String)fullComment, committerName, thisRevision, commitDate, changes, GitVcs.getInstance(project), revertable);
    }

    public static long longForSHAHash(@NonNls String revisionNumber) {
        return Long.parseLong(revisionNumber.substring(0, 15), 16) << 4 + Integer.parseInt(revisionNumber.substring(15, 16), 16);
    }

    @NotNull
    public static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String oldRevision, @Nullable @NonNls String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(12);
        }
        return GitChangeUtils.getDiff(project, root, oldRevision, newRevision, dirtyPaths, true, false);
    }

    @NotNull
    private static Collection<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @Nullable @NonNls String oldRevision, @Nullable @NonNls String newRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean detectRenames, boolean threeDots) throws VcsException {
        GitRevisionNumber newRev;
        GitRevisionNumber oldRev;
        String range;
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(oldRevision != null || newRevision != null, (Object)"Both old and new revisions can't be null");
        String dots = threeDots ? "..." : "..";
        if (newRevision == null) {
            range = oldRevision + dots;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = null;
        } else if (oldRevision == null) {
            range = dots + newRevision;
            oldRev = null;
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        } else {
            range = oldRevision + dots + newRevision;
            oldRev = GitChangeUtils.resolveReference(project, root, oldRevision);
            newRev = GitChangeUtils.resolveReference(project, root, newRevision);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, range, dirtyPaths, false, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitChangeUtils.parseChanges(project, root, newRev, oldRev, output, changes);
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<GitDiffChange> getStagedChanges(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(16);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(17);
        }
        return GitChangeUtils.getLocalChanges(project, root, null, "--cached", "-M");
    }

    @NotNull
    public static Collection<GitDiffChange> getUnstagedChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, boolean detectMoves) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(19);
        }
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, paths, "-M");
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, "--no-renames");
    }

    @NotNull
    public static Collection<GitDiffChange> getWorkingTreeChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, boolean detectMoves) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(21);
        }
        if (detectMoves) {
            return GitChangeUtils.getLocalChanges(project, root, paths, "-M", "HEAD");
        }
        return GitChangeUtils.getLocalChanges(project, root, paths, "--no-renames", "HEAD");
    }

    @NotNull
    private static Collection<GitDiffChange> getLocalChanges(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths, String ... parameters) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(22);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(23);
        }
        if (paths != null && paths.isEmpty()) {
            List<GitDiffChange> list2 = Collections.emptyList();
            if (list2 == null) {
                GitChangeUtils.$$$reportNull$$$0(24);
            }
            return list2;
        }
        GitLineHandler handler = (GitLineHandler)GitUtil.createHandlerWithPaths(paths, () -> {
            GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
            diff.addParameters("--name-status");
            diff.addParameters(parameters);
            return diff;
        });
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        ArrayList<GitDiffChange> changes = new ArrayList<GitDiffChange>();
        GitChangeUtils.parseChanges(root, new StringScanner(output), (status, beforePath, afterPath) -> changes.add(new GitDiffChange(status, beforePath, afterPath)));
        ArrayList<GitDiffChange> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static List<FilePath> getUnmergedFiles(@NotNull GitRepository repository) throws VcsException {
        GitCommandResult result2;
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(26);
        }
        if (!(result2 = Git.getInstance().getUnmergedFiles(repository)).success()) {
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
        VirtualFile root = repository.getRoot();
        String output = StringUtil.join(result2.getOutput(), (String)"\n");
        HashSet<FilePath> unmergedPaths = new HashSet<FilePath>();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            String path = GitUtil.unescapePath(relative);
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)root, (String)path, (boolean)false);
            unmergedPaths.add(filePath);
        }
        return new ArrayList<FilePath>(unmergedPaths);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(27);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(28);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(29);
        }
        return GitChangeUtils.getDiffWithWorkingDir(project, root, oldRevision, dirtyPaths, reverse, true);
    }

    @NotNull
    public static Collection<Change> getDiffWithWorkingDir(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NonNls String oldRevision, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(30);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(31);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(32);
        }
        String output = GitChangeUtils.getDiffOutput(project, root, oldRevision, dirtyPaths, reverse, detectRenames);
        ArrayList<Change> changes = new ArrayList<Change>();
        GitRevisionNumber revisionNumber = GitChangeUtils.resolveReference(project, root, oldRevision);
        GitChangeUtils.parseChanges(project, root, reverse ? revisionNumber : null, reverse ? null : revisionNumber, output, changes);
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitChangeUtils.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private static String getDiffOutput(@NotNull Project project, @NotNull VirtualFile root, @NotNull String diffRange, @Nullable Collection<? extends FilePath> dirtyPaths, boolean reverse, boolean detectRenames) throws VcsException {
        if (project == null) {
            GitChangeUtils.$$$reportNull$$$0(34);
        }
        if (root == null) {
            GitChangeUtils.$$$reportNull$$$0(35);
        }
        if (diffRange == null) {
            GitChangeUtils.$$$reportNull$$$0(36);
        }
        GitLineHandler h2 = (GitLineHandler)GitUtil.createHandlerWithPaths(dirtyPaths, () -> {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.DIFF);
            if (reverse) {
                handler.addParameters("-R");
            }
            handler.addParameters("--name-status", "--diff-filter=ADCMRUXT");
            if (detectRenames) {
                handler.addParameters("-M");
            }
            handler.addParameters(diffRange);
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            return handler;
        });
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        if (string == null) {
            GitChangeUtils.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    public static Collection<Change> getDiffWithWorkingTree(@NotNull GitRepository repository, @NotNull @NonNls String refToCompare, boolean detectRenames) {
        Collection<Change> changes;
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(38);
        }
        if (refToCompare == null) {
            GitChangeUtils.$$$reportNull$$$0(39);
        }
        try {
            changes = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), refToCompare, null, false, detectRenames);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't collect diff", (Throwable)e);
            changes = null;
        }
        return changes;
    }

    @Nullable
    public static Collection<Change> getDiff(@NotNull GitRepository repository, @NotNull @NonNls String oldRevision, @NotNull @NonNls String newRevision, boolean detectRenames) {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(40);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(41);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(42);
        }
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, detectRenames, false);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Collection<Change> getThreeDotDiff(@NotNull GitRepository repository, @NotNull @NonNls String oldRevision, @NotNull @NonNls String newRevision) {
        if (repository == null) {
            GitChangeUtils.$$$reportNull$$$0(43);
        }
        if (oldRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(44);
        }
        if (newRevision == null) {
            GitChangeUtils.$$$reportNull$$$0(45);
        }
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), oldRevision, newRevision, null, true, true);
        }
        catch (VcsException e) {
            LOG.info("Couldn't collect changes between " + oldRevision + " and " + newRevision, (Throwable)e);
            if (null == null) {
                GitChangeUtils.$$$reportNull$$$0(46);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 25: 
            case 33: 
            case 37: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 25: 
            case 33: 
            case 37: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 25: 
            case 33: 
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 26: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 29: 
            case 32: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRevision";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRange";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refToCompare";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/changes/GitChangeUtils";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefResolveHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiff";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChanges";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffWithWorkingDir";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffOutput";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreeDotDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseChanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRefResolveHandler";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 25: 
            case 33: 
            case 37: 
            case 46: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionChanges";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDiff";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStagedChanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getUnstagedChanges";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingTreeChanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingDir";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDiffOutput";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDiffWithWorkingTree";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getThreeDotDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 25: 
            case 33: 
            case 37: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GitDiffChange
    implements FilePathChange {
        @NotNull
        private final FileStatus status;
        @Nullable
        private final FilePath beforePath;
        @Nullable
        private final FilePath afterPath;

        public GitDiffChange(@NotNull FileStatus status, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            if (status == null) {
                GitDiffChange.$$$reportNull$$$0(0);
            }
            assert (beforePath != null || afterPath != null);
            this.status = status;
            this.beforePath = beforePath;
            this.afterPath = afterPath;
        }

        @Nullable
        public FilePath getBeforePath() {
            return this.beforePath;
        }

        @Nullable
        public FilePath getAfterPath() {
            return this.afterPath;
        }

        @NotNull
        public FilePath getFilePath() {
            @Nullable FilePath t = this.afterPath != null ? this.afterPath : this.beforePath;
            FilePath filePath = Objects.requireNonNull(t);
            if (filePath == null) {
                GitDiffChange.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @NotNull
        public FileStatus getStatus() {
            FileStatus fileStatus = this.status;
            if (fileStatus == null) {
                GitDiffChange.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/changes/GitChangeUtils$GitDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/changes/GitChangeUtils$GitDiffChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface FileStatusLineConsumer {
        public void consume(@NotNull FileStatus var1, @Nullable FilePath var2, @Nullable FilePath var3);
    }
}

