/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchStateProvider;
import com.intellij.vcs.branch.LinkedBranchDataImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lgit4idea/branch/GitBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.git"})
public final class GitBranchStateProvider
implements BranchStateProvider {
    @NotNull
    private final Project project;

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        LinkedBranchDataImpl linkedBranchDataImpl;
        GitRepository repository;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!ProjectLevelVcsManager.getInstance((Project)this.project).checkVcsIsActive("Git")) {
            return null;
        }
        GitRepository gitRepository = repository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFileQuick(path);
        if (gitRepository != null) {
            GitBranch gitBranch;
            GitRepository gitRepository2 = gitRepository;
            boolean bl = false;
            boolean bl2 = false;
            GitRepository it = gitRepository2;
            boolean bl3 = false;
            VirtualFile virtualFile = it.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it.root");
            String string = virtualFile.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.root.presentableName");
            GitLocalBranch gitLocalBranch = it.getCurrentBranch();
            linkedBranchDataImpl = new LinkedBranchDataImpl(string, gitLocalBranch != null ? gitLocalBranch.getName() : null, (gitBranch = it.getCurrentBranch()) != null && (gitBranch = ((GitLocalBranch)gitBranch).findTrackedBranch(it)) != null ? gitBranch.getName() : null);
        } else {
            linkedBranchDataImpl = null;
        }
        return (BranchData)linkedBranchDataImpl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GitBranchStateProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

