/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Alarm;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(GitBranchIncomingOutgoingManager.class);
    public static final Topic<GitIncomingOutgoingListener> GIT_INCOMING_OUTGOING_CHANGED = new Topic("Git incoming outgoing info changed", GitIncomingOutgoingListener.class);
    private static final String MAC_DEFAULT_LAUNCH = "com.apple.launchd";
    private static final boolean HAS_EXTERNAL_SSH_AGENT = GitBranchIncomingOutgoingManager.hasExternalSSHAgent();
    @NotNull
    private final Object LOCK;
    @NotNull
    private final Set<GitRepository> myDirtyReposWithIncoming;
    @NotNull
    private final Set<GitRepository> myDirtyReposWithOutgoing;
    private boolean myShouldRequestRemoteInfo;
    @NotNull
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final Map<GitRepository, Set<GitLocalBranch>> myLocalBranchesWithIncoming;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToFetch;
    @NotNull
    private final Map<GitRepository, Set<GitLocalBranch>> myLocalBranchesWithOutgoing;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myErrorMap;
    @NotNull
    private final Project myProject;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthSuccessMap;
    @NotNull
    private final AtomicBoolean myIsUpdating;

    GitBranchIncomingOutgoingManager(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myDirtyReposWithIncoming = new HashSet<GitRepository>();
        this.myDirtyReposWithOutgoing = new HashSet<GitRepository>();
        this.myLocalBranchesWithIncoming = new ConcurrentHashMap<GitRepository, Set<GitLocalBranch>>();
        this.myLocalBranchesToFetch = new ConcurrentHashMap<GitRepository, Map<GitLocalBranch, Hash>>();
        this.myLocalBranchesWithOutgoing = new ConcurrentHashMap<GitRepository, Set<GitLocalBranch>>();
        this.myErrorMap = MultiMap.createConcurrentSet();
        this.myAuthSuccessMap = MultiMap.createConcurrentSet();
        this.myIsUpdating = new AtomicBoolean();
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("GitBranchIncomingOutgoingManager", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void dispose() {
        this.stopScheduling();
    }

    private static boolean hasExternalSSHAgent() {
        String ssh_auth_sock = EnvironmentUtil.getValue((String)"SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            return false;
        }
        return !StringUtil.contains((CharSequence)ssh_auth_sock, (CharSequence)MAC_DEFAULT_LAUNCH);
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(1);
        }
        return this.shouldCheckIncoming() && this.getBranchesWithIncoming(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(2);
        }
        return GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing() && this.getBranchesWithOutgoing(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean shouldCheckIncoming() {
        return Registry.is((String)"git.update.incoming.outgoing.info") && GitVcsSettings.getInstance(this.myProject).getIncomingCheckStrategy() != GitIncomingCheckStrategy.Never;
    }

    private static boolean shouldCheckIncomingOutgoing() {
        return Registry.is((String)"git.update.incoming.outgoing.info");
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(3);
        }
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = (GitBranchIncomingOutgoingManager)ServiceManager.getService((Project)project, GitBranchIncomingOutgoingManager.class);
        if (gitBranchIncomingOutgoingManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(4);
        }
        return gitBranchIncomingOutgoingManager;
    }

    public boolean supportsIncomingOutgoing() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public void activate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.updateBranchesWithOutgoing();
            this.updateIncomingScheduling();
        });
    }

    public void updateIncomingScheduling() {
        if (this.myPeriodicalUpdater == null && this.shouldCheckIncoming()) {
            this.updateBranchesWithIncoming(true);
            int timeout = Registry.intValue((String)"git.update.incoming.info.time");
            this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesWithIncoming(true), timeout, timeout, TimeUnit.MINUTES);
        } else if (this.myPeriodicalUpdater != null && !this.shouldCheckIncoming()) {
            this.stopScheduling();
        }
    }

    @RequiresEdt
    private void stopScheduling() {
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
    }

    public void forceUpdateBranches(final @Nullable Runnable runAfterUpdate) {
        if (!this.myIsUpdating.compareAndSet(false, true)) {
            return;
        }
        this.updateBranchesWithIncoming(false);
        this.updateBranchesWithOutgoing();
        new Task.Backgroundable(this.myProject, GitBundle.message("branches.update.info.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Semaphore semaphore = new Semaphore(0);
                GitBranchIncomingOutgoingManager.this.myQueue.queue(Update.create((Object)((Object)this), () -> semaphore.release()));
                GitBranchIncomingOutgoingManager.this.myQueue.flush();
                try {
                    while (!indicator.isCanceled() && !semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            public void onFinished() {
                GitBranchIncomingOutgoingManager.this.myIsUpdating.set(false);
                if (runAfterUpdate != null) {
                    runAfterUpdate.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchIncomingOutgoingManager$1", "run"));
            }
        }.queue();
    }

    public boolean isUpdating() {
        return this.myIsUpdating.get();
    }

    private void scheduleUpdate() {
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> {
            boolean shouldRequestRemoteInfo;
            ArrayList<GitRepository> withOutgoing;
            ArrayList<GitRepository> withIncoming;
            Iterator iterator = this.LOCK;
            synchronized (iterator) {
                withIncoming = new ArrayList<GitRepository>(this.myDirtyReposWithIncoming);
                withOutgoing = new ArrayList<GitRepository>(this.myDirtyReposWithOutgoing);
                shouldRequestRemoteInfo = this.myShouldRequestRemoteInfo;
                this.myDirtyReposWithIncoming.clear();
                this.myDirtyReposWithOutgoing.clear();
                this.myShouldRequestRemoteInfo = false;
            }
            for (GitRepository r : withOutgoing) {
                this.myLocalBranchesWithOutgoing.put(r, this.calculateBranchesWithOutgoing(r));
            }
            for (GitRepository r : withIncoming) {
                if (shouldRequestRemoteInfo) {
                    this.myLocalBranchesToFetch.put(r, this.calculateBranchesToFetch(r));
                }
                this.myLocalBranchesWithIncoming.put(r, this.calcBranchesWithIncoming(r));
            }
            ((GitIncomingOutgoingListener)this.myProject.getMessageBus().syncPublisher(GIT_INCOMING_OUTGOING_CHANGED)).incomingOutgoingInfoChanged();
        }));
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithIncoming(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesWithIncoming);
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithOutgoing(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesWithOutgoing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithIncoming(boolean fromRemote) {
        if (!this.shouldCheckIncoming()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myShouldRequestRemoteInfo = fromRemote;
            this.myDirtyReposWithIncoming.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithOutgoing() {
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToFetch(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(5);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToFetchForRemote(repository, (GitRemote)entry.getKey(), (Collection)entry.getValue(), this.getAuthenticationMode(repository, (GitRemote)entry.getKey()))));
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToFetchForRemote(@NotNull GitRepository repository, @NotNull GitRemote gitRemote, @NotNull Collection<? extends GitBranchTrackInfo> trackInfoList, GitAuthenticationMode mode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(7);
        }
        if (gitRemote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(8);
        }
        if (trackInfoList == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(9);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), mode);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                Hash localHashForRemoteBranch = branchesCollection.getHash(remoteBranch);
                if (localHashForRemoteBranch == null) {
                    return;
                }
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations())) && !localHashForRemoteBranch.equals(remoteHash)) {
                    result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                }
            });
        }
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private Set<GitLocalBranch> calcBranchesWithIncoming(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(11);
        }
        HashSet<GitLocalBranch> result2 = new HashSet<GitLocalBranch>();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<GitLocalBranch, Hash> cachedBranchesToFetch = this.myLocalBranchesToFetch.get(repository);
        branchesCollection.getLocalBranches().forEach(localBranch -> {
            GitBranchTrackInfo info = GitBranchUtil.getTrackInfoForBranch(repository, localBranch);
            if (info == null) {
                return;
            }
            Hash localHashForRemoteBranch = branchesCollection.getHash(info.getRemoteBranch());
            Hash localHash = branchesCollection.getHash((GitBranch)localBranch);
            if (localHashForRemoteBranch == null) {
                return;
            }
            if (this.hasCommitsForBranch(repository, info.getLocalBranch(), localHash, localHashForRemoteBranch, true)) {
                result2.add(info.getLocalBranch());
            } else if (cachedBranchesToFetch != null && localHashForRemoteBranch.equals(cachedBranchesToFetch.get(localBranch))) {
                result2.add(info.getLocalBranch());
            }
        });
        HashSet<GitLocalBranch> hashSet = result2;
        if (hashSet == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private GitAuthenticationMode getAuthenticationMode(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(13);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(14);
        }
        GitAuthenticationMode gitAuthenticationMode = this.myAuthSuccessMap.get((Object)repository).contains(remote) ? GitAuthenticationMode.SILENT : GitAuthenticationMode.NONE;
        if (gitAuthenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(15);
        }
        return gitAuthenticationMode;
    }

    private boolean shouldAvoidUserInteraction(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(16);
        }
        return GitVcsSettings.getInstance(this.myProject).getIncomingCheckStrategy() == GitIncomingCheckStrategy.Auto && HAS_EXTERNAL_SSH_AGENT && GitBranchIncomingOutgoingManager.containsSSHUrl(remote);
    }

    private static boolean containsSSHUrl(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(17);
        }
        return ContainerUtil.exists(remote.getUrls(), url -> !url.startsWith("http"));
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, @NotNull GitAuthenticationMode authenticationMode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(18);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(19);
        }
        if (branchRefNames == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(20);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(21);
        }
        HashMap<String, Hash> result2 = new HashMap<String, Hash>();
        if (!this.supportsIncomingOutgoing()) {
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(22);
            }
            return hashMap;
        }
        if (authenticationMode == GitAuthenticationMode.NONE || authenticationMode == GitAuthenticationMode.SILENT && this.shouldAvoidUserInteraction(remote)) {
            this.myErrorMap.putValue((Object)repository, (Object)remote);
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(23);
            }
            return hashMap;
        }
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{"--heads", remote.getName()});
            params.addAll(refs);
            GitCommandResult lsRemoteResult = Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository, remote, params, authenticationMode)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseRefsLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myErrorMap.remove((Object)repository, (Object)remote);
                this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
            } else {
                this.myErrorMap.putValue((Object)repository, (Object)remote);
            }
        });
        HashMap<String, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> params, @NotNull GitAuthenticationMode authenticationMode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(25);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(26);
        }
        if (params == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(27);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(28);
        }
        GitLineHandler h2 = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.LS_REMOTE);
        h2.setIgnoreAuthenticationMode(authenticationMode);
        h2.addParameters(params);
        h2.setUrls(remote.getUrls());
        GitLineHandler gitLineHandler = h2;
        if (gitLineHandler == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(29);
        }
        return gitLineHandler;
    }

    @NotNull
    private Set<GitLocalBranch> calculateBranchesWithOutgoing(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(30);
        }
        HashSet<GitLocalBranch> branchesWithOutgoing = new HashSet<GitLocalBranch>();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            Hash localHashForRemoteBranch;
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash hash = localHashForRemoteBranch = pushTarget != null ? branchesCollection.getHash(pushTarget.getBranch()) : null;
            Hash localHash = branchesCollection.getHash(branch);
            if (!this.hasCommitsForBranch(gitRepository, branch, localHash, localHashForRemoteBranch, false)) continue;
            branchesWithOutgoing.add(branch);
        }
        HashSet<GitLocalBranch> hashSet = branchesWithOutgoing;
        if (hashSet == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    private boolean hasCommitsForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch, @Nullable Hash localBranchHash, @Nullable Hash localHashForRemoteBranch, boolean incoming) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(32);
        }
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(33);
        }
        if (!this.supportsIncomingOutgoing()) {
            return false;
        }
        if (localHashForRemoteBranch == null || Objects.equals(localBranchHash, localHashForRemoteBranch)) {
            return false;
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        handler.setSilent(true);
        String branchName = localBranch.getName();
        handler.addParameters("--count", incoming ? branchName + ".." + branchName + "@{u}" : localHashForRemoteBranch.asString() + ".." + branchName);
        try {
            String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]).trim();
            return !StringUtil.startsWithChar((CharSequence)output, (char)'0');
        }
        catch (VcsException e) {
            LOG.warn("Can't get outgoing info (git rev-list " + branchName + " failed):" + e.getMessage());
            return false;
        }
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository, @NotNull Map<GitRepository, Set<GitLocalBranch>> branchCollection) {
        if (branchCollection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(34);
        }
        if (repository != null) {
            Collection collection = Objects.requireNonNullElse(branchCollection.get(repository), Collections.emptySet());
            if (collection == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(35);
            }
            return collection;
        }
        Collection collection = (Collection)StreamEx.of(branchCollection.values()).flatMap(Collection::stream).collect(Collectors.toSet());
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(36);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(37);
        }
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.add(repository);
            this.myDirtyReposWithIncoming.add(repository);
        }
        this.scheduleUpdate();
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(38);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(39);
        }
        if (!this.shouldCheckIncoming()) {
            return;
        }
        this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(40);
        }
        MultiMap multiMap = ContainerUtil.groupBy(repository.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
        if (multiMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(41);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemote";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackInfoList";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchRefNames";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToFetch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesToFetchForRemote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesWithIncoming";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationMode";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createLsRemoteHandler";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesWithOutgoing";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackInfoByRemotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasIncomingFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasOutgoingFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToFetch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesToFetchForRemote";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesWithIncoming";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAuthenticationMode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldAvoidUserInteraction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsSSHUrl";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLsRemoteHandler";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesWithOutgoing";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasCommitsForBranch";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "repositoryChanged";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "authenticationSucceeded";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "groupTrackInfoByRemotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GitIncomingOutgoingListener {
        public void incomingOutgoingInfoChanged();
    }
}

