/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.google.common.collect.HashMultiset;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.io.URLUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.GitStatisticsCollector;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.repo.GitCommitTemplateTracker;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.dashboard.BranchesDashboardUiKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002J4\u0010\u0010\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lgit4idea/GitStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "addCommitTemplateMetrics", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "set", "Ljava/util/HashSet;", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "addGitLogMetrics", "metrics", "", "addPropertyMetricIfDiffers", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiImpl;", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "", "eventId", "", "getGroupId", "getMetrics", "getVersion", "", "Companion", "intellij.vcs.git"})
public final class GitStatisticsCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGroupId() {
        return "git.configuration";
    }

    public int getVersion() {
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitUtil.getRepositoryManager(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        List<GitRepository> list2 = repositoryManager.getRepositories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositoryManager.repositories");
        List<GitRepository> repositories = list2;
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        GitVcsSettings defaultSettings = new GitVcsSettings();
        MetricEventUtilKt.addEnumIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.1.INSTANCE, (String)"repo.sync");
        MetricEventUtilKt.addEnumIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.2.INSTANCE, (String)"update.type");
        MetricEventUtilKt.addEnumIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.3.INSTANCE, (String)"save.policy");
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.4.INSTANCE, (String)"push.autoupdate");
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.5.INSTANCE, (String)"push.update.all.roots");
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.6.INSTANCE, (String)"warn.about.crlf");
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)((Object)settings), (Object)((Object)defaultSettings), (Function1)getMetrics.7.INSTANCE, (String)"warn.about.detached");
        GitVcsApplicationSettings appSettings = GitVcsApplicationSettings.getInstance();
        GitVcsApplicationSettings defaultAppSettings = new GitVcsApplicationSettings();
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)appSettings, (Object)defaultAppSettings, (Function1)getMetrics.8.INSTANCE, (String)"cherrypick.autocommit");
        MetricEventUtilKt.addBoolIfDiffers((Set)set, (Object)appSettings, (Object)defaultAppSettings, (Function1)getMetrics.9.INSTANCE, (String)"staging.area.enabled");
        GitVcs gitVcs = GitVcs.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"GitVcs.getInstance(project)");
        GitVersion gitVersion = gitVcs.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"GitVcs.getInstance(project).version");
        GitVersion version = gitVersion;
        FeatureUsageData featureUsageData = new FeatureUsageData();
        String string = version.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.presentation");
        set.add(MetricEventFactoryKt.newMetric((String)"executable", (FeatureUsageData)featureUsageData.addData("version", string).addData("type", version.getType().name())));
        Iterator<GitRepository> iterator = repositories.iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            GitBranchesCollection branches2;
            GitRepository repository;
            GitRepository gitRepository = repository = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repository");
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository.getBranches(), (String)"repository.branches");
            MetricEvent metric = MetricEventFactoryKt.newMetric((String)"repository");
            metric.getData().addData("local_branches", branches2.getLocalBranches().size());
            metric.getData().addData("remote_branches", branches2.getRemoteBranches().size());
            metric.getData().addData("remotes", repository.getRemotes().size());
            Collection<GitRemote> collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.remotes");
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                GitRemote it = (GitRemote)element$iv$iv;
                boolean bl2 = false;
                GitRemote gitRemote = it;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemote, (String)"it");
                if (GitStatisticsCollector.Companion.getRemoteServerType(gitRemote) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            HashMultiset remoteTypes = HashMultiset.create((Iterable)((List)destination$iv$iv));
            for (String remoteType : remoteTypes) {
                metric.getData().addData("remote_" + remoteType, remoteTypes.count((Object)remoteType));
            }
            set.add(metric);
        }
        this.addCommitTemplateMetrics(project, repositories, set);
        this.addGitLogMetrics(project, (Set<MetricEvent>)set);
        return set;
    }

    private final void addCommitTemplateMetrics(Project project, List<? extends GitRepository> repositories, HashSet<MetricEvent> set) {
        if (repositories.isEmpty()) {
            return;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitCommitTemplateTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        int templatesCount = ((GitCommitTemplateTracker)object).templatesCount();
        if (templatesCount == 0) {
            return;
        }
        MetricEvent metric = MetricEventFactoryKt.newMetric((String)"commit_template");
        metric.getData().addData("count", templatesCount);
        metric.getData().addData("multiple_root", repositories.size() > 1);
        set.add(metric);
    }

    private final void addGitLogMetrics(Project project, Set<MetricEvent> metrics) {
        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance((Project)project);
        if (vcsProjectLog == null) {
            return;
        }
        VcsProjectLog projectLog = vcsProjectLog;
        VcsLogUiImpl vcsLogUiImpl = projectLog.getMainLogUi();
        if (vcsLogUiImpl == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiImpl, (String)"projectLog.mainLogUi ?: return");
        VcsLogUiImpl ui = vcsLogUiImpl;
        this.addPropertyMetricIfDiffers(metrics, ui, (VcsLogUiProperties.VcsLogUiProperty<Boolean>)((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY()), "showGitBranchesInLog");
        this.addPropertyMetricIfDiffers(metrics, ui, (VcsLogUiProperties.VcsLogUiProperty<Boolean>)((VcsLogUiProperties.VcsLogUiProperty)BranchesDashboardUiKt.getCHANGE_LOG_FILTER_ON_BRANCH_SELECTION_PROPERTY()), "updateBranchesFilterInLogOnSelection");
    }

    private final void addPropertyMetricIfDiffers(Set<MetricEvent> metrics, VcsLogUiImpl ui, VcsLogUiProperties.VcsLogUiProperty<Boolean> property, String eventId) {
        Object object;
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = property;
        if (!(vcsLogUiProperty instanceof VcsLogProjectTabsProperties.CustomBooleanTabProperty)) {
            vcsLogUiProperty = null;
        }
        if ((object = (VcsLogProjectTabsProperties.CustomBooleanTabProperty)vcsLogUiProperty) == null || (object = object.defaultValue(ui.getId())) == null) {
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = property;
            if (!(vcsLogUiProperty2 instanceof VcsLogApplicationSettings.CustomBooleanProperty)) {
                vcsLogUiProperty2 = null;
            }
            VcsLogApplicationSettings.CustomBooleanProperty customBooleanProperty = (VcsLogApplicationSettings.CustomBooleanProperty)vcsLogUiProperty2;
            object = customBooleanProperty != null ? customBooleanProperty.defaultValue() : null;
        }
        if (object == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(property as? VcsLogProj\u2026.defaultValue() ?: return");
        boolean defaultValue = object.booleanValue();
        MainVcsLogUiProperties mainVcsLogUiProperties = ui.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUiProperties, (String)"ui.properties");
        MainVcsLogUiProperties properties = mainVcsLogUiProperties;
        Boolean bl = properties.exists(property) ? (Boolean)properties.get(property) : Boolean.valueOf(defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"if (properties.exists(pr\u2026operty] else defaultValue");
        boolean value = bl;
        if (!Comparing.equal((Object)value, (Object)defaultValue)) {
            metrics.add(MetricEventFactoryKt.newBooleanMetric((String)eventId, (boolean)value));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lgit4idea/GitStatisticsCollector$Companion;", "", "()V", "getRemoteServerType", "", "remote", "Lgit4idea/repo/GitRemote;", "intellij.vcs.git"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final String getRemoteServerType(GitRemote remote) {
            boolean bl;
            block18: {
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block17: {
                    boolean bl3;
                    block16: {
                        void $this$mapTo$iv$iv;
                        List<String> list2 = remote.getUrls();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"remote.urls");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterator iterator = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p1;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            String string2 = URLUtil.parseHostFromSshUrl((String)p1);
                            collection.add(string2);
                        }
                        List hosts = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                        if (hosts.contains("github.com")) {
                            return "github";
                        }
                        if (hosts.contains("gitlab.com")) {
                            return "gitlab";
                        }
                        if (hosts.contains("bitbucket.org")) {
                            return "bitbucket";
                        }
                        List<String> list3 = remote.getUrls();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"remote.urls");
                        $this$any$iv = list3;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl5 = false;
                                String string = it;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"github", (boolean)false, (int)2, null)) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return "github_custom";
                    }
                    List<String> list4 = remote.getUrls();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"remote.urls");
                    $this$any$iv = list4;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            String string = it;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"gitlab", (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block17;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return "gitlab_custom";
                }
                List<String> list5 = remote.getUrls();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"remote.urls");
                $this$any$iv = list5;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl7 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"bitbucket", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return "bitbucket_custom";
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

