/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.util;

import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002JF\u0010\f\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00070\r2\u001a\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00110\u0010J\u0014\u0010\u0012\u001a\u00020\n2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J(\u0010\u0015\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J(\u0010\u0019\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J.\u0010\u001c\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\f\u0010\u001e\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/completion/ml/util/RelevanceUtil;", "", "()V", "IGNORED_FACTORS", "", "", "weighersClassesCache", "", "Lcom/intellij/internal/statistic/utils/PluginType;", "acceptValue", "", "value", "asRelevanceMaps", "Lkotlin/Pair;", "", "relevanceObjects", "", "Lcom/intellij/openapi/util/Pair;", "isJetBrainsClass", "cl", "Ljava/lang/Class;", "addCompoundValues", "", "prefix", "proximity", "addDataClassValues", "featureName", "dataClassString", "addProperties", "properties", "normalized", "intellij.completionMlRanking"})
public final class RelevanceUtil {
    private static final Set<String> IGNORED_FACTORS;
    private static final Map<String, PluginType> weighersClassesCache;
    @NotNull
    public static final RelevanceUtil INSTANCE;

    @NotNull
    public final Pair<Map<String, Object>, Map<String, Object>> asRelevanceMaps(@NotNull List<? extends com.intellij.openapi.util.Pair<String, Object>> relevanceObjects) {
        Intrinsics.checkNotNullParameter(relevanceObjects, (String)"relevanceObjects");
        boolean bl = false;
        Map relevanceMap = new LinkedHashMap();
        boolean bl2 = false;
        Map additionalMap = new LinkedHashMap();
        block14: for (com.intellij.openapi.util.Pair<String, Object> pair : relevanceObjects) {
            Object object = pair.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.first");
            String name = this.normalized((String)object);
            Object value = pair.second;
            if (IGNORED_FACTORS.contains(name) || value == null) continue;
            switch (name) {
                case "proximity": {
                    this.addCompoundValues(relevanceMap, "prox", value.toString());
                    continue block14;
                }
                case "kotlin.proximity": {
                    this.addCompoundValues(relevanceMap, "kt_prox", value.toString());
                    continue block14;
                }
                case "swiftSymbolProximity": {
                    relevanceMap.put(name, value);
                    this.addCompoundValues(relevanceMap, "swift_prox", value.toString());
                    continue block14;
                }
                case "kotlin.callableWeight": {
                    this.addDataClassValues(relevanceMap, "kotlin.callableWeight", value.toString());
                    continue block14;
                }
                case "ml_weigh": {
                    this.addCompoundValues(additionalMap, "ml", value.toString());
                    continue block14;
                }
            }
            if (!this.acceptValue(value) && !Intrinsics.areEqual((Object)name, (Object)"ml_rank")) continue;
            relevanceMap.put(name, value);
        }
        return new Pair((Object)relevanceMap, (Object)additionalMap);
    }

    private final boolean acceptValue(Object value) {
        return value instanceof Number || value instanceof Boolean || value.getClass().isEnum() || this.isJetBrainsClass(value.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJetBrainsClass(Class<?> cl) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, PluginType> map = weighersClassesCache;
        String string = cl.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cl.name");
        String key$iv = string;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PluginType answer$iv = PluginInfoDetectorKt.getPluginInfo(cl).getType();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        PluginType pluginType = (PluginType)object;
        return pluginType.isDevelopedByJetBrains();
    }

    private final String normalized(String $this$normalized) {
        return StringsKt.substringBefore$default((String)$this$normalized, (char)'@', null, (int)2, null);
    }

    private final void addCompoundValues(Map<String, Object> $this$addCompoundValues, String prefix, String proximity) {
        List items = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)proximity, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        this.addProperties($this$addCompoundValues, prefix, items);
    }

    private final void addDataClassValues(Map<String, Object> $this$addDataClassValues, String featureName, String dataClassString) {
        if (StringUtil.countChars((CharSequence)dataClassString, (char)'(') != 1) {
            $this$addDataClassValues.put(featureName, dataClassString);
        } else {
            this.addProperties($this$addDataClassValues, featureName, StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)dataClassString, (char)'(', null, (int)2, null), (char)')', null, (int)2, null), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null));
        }
    }

    private final void addProperties(Map<String, Object> $this$addProperties, String prefix, List<String> properties) {
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            String string = StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null);
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String key = prefix + '_' + ((Object)StringsKt.trim((CharSequence)string2)).toString();
            String string3 = StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null);
            boolean bl4 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String value = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            $this$addProperties.put(key, value);
        }
    }

    private RelevanceUtil() {
    }

    static {
        RelevanceUtil relevanceUtil;
        INSTANCE = relevanceUtil = new RelevanceUtil();
        IGNORED_FACTORS = SetsKt.setOf((Object[])new String[]{"kotlin.byNameAlphabetical", "scalaMethodCompletionWeigher", "unresolvedOnTop", "alphabetic", "TabNineLookupElementWeigher", "AixLookupElementWeigher", "CodotaCompletionWeigher", "CodotaCompletionWeigher_Kotlin", "EmcSuggestionsWeigher", "codotaPriorityWeigher", "com.zlabs.code.completion.ScaCompletionWeigher", "com.aliyun.odps.studio.intellij.compiler.codecompletion.OdpsqlCompletionWeigher"});
        boolean bl = false;
        weighersClassesCache = new LinkedHashMap();
    }
}

