/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.completion.ml.common.PrefixMatchingType;
import com.intellij.completion.ml.personalization.UserFactor;
import com.intellij.completion.ml.personalization.UserFactorsManager;
import com.intellij.completion.ml.personalization.impl.AveragePrefixLength;
import com.intellij.completion.ml.personalization.impl.AverageSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.AverageTimeBetweenTyping;
import com.intellij.completion.ml.personalization.impl.CompletionTypeRatio;
import com.intellij.completion.ml.personalization.impl.ExplicitSelectRatio;
import com.intellij.completion.ml.personalization.impl.LookupCancelledRatio;
import com.intellij.completion.ml.personalization.impl.MaxSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.MnemonicsRatio;
import com.intellij.completion.ml.personalization.impl.MostFrequentPrefixLength;
import com.intellij.completion.ml.personalization.impl.MostFrequentSelectedItemPosition;
import com.intellij.completion.ml.personalization.impl.PrefixMatchingTypeRatio;
import com.intellij.completion.ml.personalization.impl.TodayCompletionUsageCount;
import com.intellij.completion.ml.personalization.impl.TotalUsageCount;
import com.intellij.completion.ml.personalization.impl.TypedSelectRatio;
import com.intellij.completion.ml.personalization.impl.WeekAverageUsageCount;
import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorsManagerImpl;", "Lcom/intellij/completion/ml/personalization/UserFactorsManager;", "()V", "userFactors", "", "", "Lcom/intellij/completion/ml/personalization/UserFactor;", "getAllFactors", "", "register", "", "factor", "registerAllFactors", "Companion", "intellij.completionMlRanking"})
public final class UserFactorsManagerImpl
implements UserFactorsManager {
    private final Map<String, UserFactor> userFactors;
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Companion Companion;

    private final void registerAllFactors() {
        this.register(new TypedSelectRatio());
        this.register(new ExplicitSelectRatio());
        this.register(new LookupCancelledRatio());
        this.register(new CompletionTypeRatio(CompletionType.BASIC));
        this.register(new CompletionTypeRatio(CompletionType.SMART));
        this.register(new CompletionTypeRatio(CompletionType.CLASS_NAME));
        this.register(new TodayCompletionUsageCount());
        this.register(new TotalUsageCount());
        this.register(new WeekAverageUsageCount());
        this.register(new MostFrequentPrefixLength());
        this.register(new AveragePrefixLength());
        this.register(new AverageSelectedItemPosition());
        this.register(new MaxSelectedItemPosition());
        this.register(new MostFrequentSelectedItemPosition());
        this.register(new AverageTimeBetweenTyping());
        this.register(new MnemonicsRatio());
        for (PrefixMatchingType type : PrefixMatchingType.values()) {
            this.register(new PrefixMatchingTypeRatio(type));
        }
    }

    @Override
    @NotNull
    public List<UserFactor> getAllFactors() {
        return CollectionsKt.toList((Iterable)this.userFactors.values());
    }

    private final void register(UserFactor factor) {
        UserFactor old = this.userFactors.put(factor.getId(), factor);
        if (old != null) {
            if (old == factor) {
                LOG.warn("The same factor was registered twice");
            } else {
                LOG.warn("Two different factors with the same id found: id = " + old.getId() + ", " + "classes = " + CollectionsKt.listOf((Object[])new String[]{factor.getClass().getCanonicalName(), old.getClass().getCanonicalName()}));
            }
        }
    }

    public UserFactorsManagerImpl() {
        boolean bl = false;
        this.userFactors = new LinkedHashMap();
        if (UserFactorsManager.Companion.getENABLE_USER_FACTORS()) {
            this.registerAllFactors();
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(UserFactorsManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(UserF\u2026sManagerImpl::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorsManagerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.completionMlRanking"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

