/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.completion.ml.personalization.Day;
import com.intellij.completion.ml.personalization.impl.DayImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/personalization/impl/DayImpl;", "Lcom/intellij/completion/ml/personalization/Day;", "date", "Ljava/util/Date;", "(Ljava/util/Date;)V", "dayOfMonth", "", "getDayOfMonth", "()I", "month", "getMonth", "year", "getYear", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "intellij.completionMlRanking"})
public final class DayImpl
implements Day {
    private final int dayOfMonth;
    private final int month;
    private final int year;
    private static final Logger LOG;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT;
    @NotNull
    public static final Companion Companion;

    @Override
    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(@NotNull Day other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getYear() == other.getYear()) {
            if (this.getMonth() == other.getMonth()) {
                return Intrinsics.compare((int)this.getDayOfMonth(), (int)other.getDayOfMonth());
            }
            return Intrinsics.compare((int)this.getMonth(), (int)other.getMonth());
        }
        return Intrinsics.compare((int)this.getYear(), (int)other.getYear());
    }

    public int hashCode() {
        return Objects.hash(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }

    public boolean equals(@Nullable Object other) {
        if (other != null && other instanceof Day) {
            return this.compareTo((Day)other) == 0;
        }
        return false;
    }

    @NotNull
    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDayOfMonth());
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        String string = DATE_FORMAT.get().format(calendar2.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_FORMAT.get().format(calendar.time)");
        return string;
    }

    public DayImpl(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        calendar2.setTime(date);
        this.dayOfMonth = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DayImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DayImpl::class.java)");
        LOG = logger;
        DATE_FORMAT = ThreadLocal.withInitial(Companion.DATE_FORMAT.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/personalization/impl/DayImpl$Companion;", "", "()V", "DATE_FORMAT", "Ljava/lang/ThreadLocal;", "Ljava/text/SimpleDateFormat;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fromString", "Lcom/intellij/completion/ml/personalization/Day;", "str", "", "intellij.completionMlRanking"})
    public static final class Companion {
        @Nullable
        public final Day fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            ParsePosition position = new ParsePosition(0);
            Date date = null;
            try {
                Date date2 = ((SimpleDateFormat)DATE_FORMAT.get()).parse(str, position);
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"DATE_FORMAT.get().parse(str, position)");
                date = date2;
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse a date from string: " + str + ". Collected data for the day will be skipped.", (Throwable)e);
                return null;
            }
            if (position.getIndex() == 0) {
                return null;
            }
            return new DayImpl(date);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

