/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.experiment;

import com.google.gson.Gson;
import com.intellij.completion.ml.experiment.ClientExperimentStatus;
import com.intellij.completion.ml.experiment.ExperimentConfig;
import com.intellij.completion.ml.experiment.ExperimentGroupConfig;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentLanguageConfig;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus;", "Lcom/intellij/completion/ml/experiment/ExperimentStatus;", "()V", "experimentConfig", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "language2group", "", "", "Lcom/intellij/completion/ml/experiment/ExperimentInfo;", "disable", "", "findMatchingLanguage", "language", "Lcom/intellij/lang/Language;", "forLanguage", "isDisabled", "", "setDisabled", "value", "Companion", "intellij.completionMlRanking"})
public final class ClientExperimentStatus
implements ExperimentStatus {
    private final ExperimentConfig experimentConfig = Companion.loadExperimentInfo();
    private final Map<String, ExperimentInfo> language2group;
    private static final String EXPERIMENT_DISABLED_PROPERTY_KEY = "ml.completion.experiment.disabled";
    private static final String PATH_TO_EXPERIMENT_CONFIG = "/experiment.json";
    private static final Lazy GSON$delegate;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ExperimentInfo forLanguage(@NotNull Language language) {
        ExperimentInfo experimentInfo;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return new ExperimentInfo(false, 0, false, false, false, 28, null);
        }
        String string = this.findMatchingLanguage(language);
        if (string == null) {
            return new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, 28, null);
        }
        String matchingLanguage = string;
        RegistryValue registryValue = Registry.get((String)"completion.ml.override.experiment.group.number");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(\"completion\u2026experiment.group.number\")");
        RegistryValue experimentGroupRegistry = registryValue;
        if (experimentGroupRegistry.isChangedFromDefault()) {
            Object v3;
            block6: {
                Iterable iterable = this.experimentConfig.getGroups();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl3 = false;
                    if (!(it.getNumber() == experimentGroupRegistry.asInteger())) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            ExperimentGroupConfig group = v3;
            if (group != null) {
                this.setDisabled(false);
                return new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures());
            }
        }
        if ((experimentInfo = this.language2group.get(matchingLanguage)) == null) {
            experimentInfo = new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, 28, null);
        }
        return experimentInfo;
    }

    @Override
    public void disable() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isEAP()) {
            this.setDisabled(true);
        }
    }

    @Override
    public boolean isDisabled() {
        return PropertiesComponent.getInstance().isTrueValue(EXPERIMENT_DISABLED_PROPERTY_KEY);
    }

    private final void setDisabled(boolean value) {
        PropertiesComponent.getInstance().setValue(EXPERIMENT_DISABLED_PROPERTY_KEY, value);
    }

    /*
     * WARNING - void declaration
     */
    private final String findMatchingLanguage(Language language) {
        Iterator iterator;
        block6: {
            void $this$filterTo$iv$iv;
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"Language.getRegisteredLanguages()");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)element$iv$iv;
                boolean bl = false;
                if (!language.isKindOf(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List baseLanguages = (List)destination$iv$iv;
            Iterable iterable2 = this.language2group.keySet();
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator2 : iterable) {
                boolean bl3;
                block5: {
                    String languageId = (String)((Object)iterator2);
                    boolean bl4 = false;
                    Iterable $this$any$iv = baseLanguages;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Language it = (Language)element$iv;
                            boolean bl5 = false;
                            Language language2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"it");
                            if (!StringsKt.equals((String)languageId, (String)language2.getID(), (boolean)true)) continue;
                            bl3 = true;
                            break block5;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                iterator = iterator2;
                break block6;
            }
            iterator = null;
        }
        return (String)((Object)iterator);
    }

    public ClientExperimentStatus() {
        boolean bl = false;
        this.language2group = new LinkedHashMap();
        for (ExperimentLanguageConfig languageSettings : this.experimentConfig.getLanguages()) {
            Object v0;
            block2: {
                int bucket = EventLogConfiguration.INSTANCE.getBucket() % languageSettings.getExperimentBucketsCount();
                int groupNumber = languageSettings.getIncludeGroups().size() > bucket ? ((Number)languageSettings.getIncludeGroups().get(bucket)).intValue() : this.experimentConfig.getVersion();
                Iterable iterable = this.experimentConfig.getGroups();
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t : iterable2) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl4 = false;
                    if (!(it.getNumber() == groupNumber)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ExperimentGroupConfig group = v0;
            ExperimentInfo groupInfo = group == null ? new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, 28, null) : new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures());
            this.language2group.put(languageSettings.getId(), groupInfo);
        }
    }

    static {
        Companion = new Companion(null);
        GSON$delegate = LazyKt.lazy((Function0)Companion.GSON.2.INSTANCE);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClientExperimentStatus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus$Companion;", "", "()V", "EXPERIMENT_DISABLED_PROPERTY_KEY", "", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "GSON$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PATH_TO_EXPERIMENT_CONFIG", "checkExperimentGroups", "", "experimentInfo", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "loadExperimentInfo", "intellij.completionMlRanking"})
    public static final class Companion {
        private final Gson getGSON() {
            Lazy lazy = GSON$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Gson)lazy.getValue();
        }

        @NotNull
        public final ExperimentConfig loadExperimentInfo() {
            try {
                ExperimentConfig experimentInfo;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isEAP()) {
                    return ExperimentConfig.Companion.disabledExperiment();
                }
                URL uRL = ClientExperimentStatus.class.getResource(ClientExperimentStatus.PATH_TO_EXPERIMENT_CONFIG);
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"ClientExperimentStatus::\u2026ATH_TO_EXPERIMENT_CONFIG)");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                boolean bl2 = false;
                boolean bl3 = false;
                String json = new String(byArray, charset);
                ExperimentConfig experimentConfig = experimentInfo = (ExperimentConfig)this.getGSON().fromJson(json, ExperimentConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)experimentConfig, (String)"experimentInfo");
                this.checkExperimentGroups(experimentConfig);
                return experimentInfo;
            }
            catch (Throwable e) {
                LOG.error("Error on loading ML Completion experiment info", e);
                return ExperimentConfig.Companion.disabledExperiment();
            }
        }

        private final void checkExperimentGroups(ExperimentConfig experimentInfo) {
            boolean bl;
            boolean bl2;
            for (ExperimentGroupConfig group : experimentInfo.getGroups()) {
                if (group.getShowArrows()) {
                    bl2 = group.getUseMLRanking();
                    bl = false;
                    if (_Assertions.ENABLED && !bl2) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = "Showing arrows requires ML ranking";
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42));
                    }
                }
                if (!group.getUseMLRanking()) continue;
                bl2 = group.getCalculateFeatures();
                bl = false;
                if (!_Assertions.ENABLED || bl2) continue;
                boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = false;
                String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = "ML ranking requires calculating features";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62));
            }
            for (ExperimentLanguageConfig language : experimentInfo.getLanguages()) {
                boolean bl3;
                block12: {
                    bl2 = language.getIncludeGroups().size() <= language.getExperimentBucketsCount();
                    bl = false;
                    if (_Assertions.ENABLED && !bl2) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = "Groups count must be less than the total number of buckets (" + language.getId() + ')';
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72));
                    }
                    Iterable $this$all$iv = language.getIncludeGroups();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            boolean bl4;
                            block11: {
                                int number = ((Number)element$iv).intValue();
                                boolean bl5 = false;
                                Iterable $this$any$iv = experimentInfo.getGroups();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl4 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        ExperimentGroupConfig it = (ExperimentGroupConfig)element$iv2;
                                        boolean bl6 = false;
                                        if (!(it.getNumber() == number)) continue;
                                        bl4 = true;
                                        break block11;
                                    }
                                    bl4 = false;
                                }
                            }
                            if (bl4) continue;
                            bl3 = false;
                            break block12;
                        }
                        bl3 = true;
                    }
                }
                bl2 = bl3;
                bl = false;
                if (!_Assertions.ENABLED || bl2) continue;
                boolean bl7 = false;
                String string = "Group included for language (" + language.getId() + ") should be among general list of groups";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

