/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditEdgeHandler;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultGraph2DRenderer;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.uml.core.actions.DeleteNodeContentAction;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.core.actions.UmlNewAction;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.popup.AddElementsFromPopupAction;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.editors.DiagramNodeCellEditor;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Alarm;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusListener;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class DiagramPresentationModelImpl
extends DiagramPresentationModel {
    @NotNull
    private static final String USE_BRIDGE_CALCULATOR_REGKEY = "diagrams.use.bridge.calculator";
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiagramState myPresentation;
    @NotNull
    private final DiagramProvider<?> myProvider;
    @GuardedBy(value="myActionsLock")
    @NotNull
    private final DefaultActionGroup myElementProvidersActions;
    @GuardedBy(value="myActionsLock")
    @NotNull
    private final DefaultActionGroup myExtraActions;
    @NotNull
    private final Object myActionsLock;
    @NotNull
    private final NotNullLazyValue<DefaultUmlRenderer> myRenderer;
    @Nullable
    private final UmlNodeHighlighter myNodeHighlighter;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final SimpleModificationTracker myUpdateTracker;
    @NotNull
    private final NotNullLazyValue<ModificationTracker> myModificationTrackerOfViewUpdates;
    @NotNull
    private final NotNullLazyValue<ModificationTracker> myZoomChangedModTracker;
    @NotNull
    private static final Color ARROW_BG = Gray.TRANSPARENT;
    @NotNull
    private static final Map<Shape, Arrow> KNOWN_SHAPES = new HashMap<Shape, Arrow>();

    public DiagramPresentationModelImpl(@NotNull Graph2D graph, @NotNull Project project, @NotNull DiagramProvider<?> provider) {
        if (graph == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(2);
        }
        super(graph);
        this.myElementProvidersActions = new DefaultActionGroup();
        this.myExtraActions = new DefaultActionGroup();
        this.myActionsLock = new Object();
        this.myRenderer = NotNullLazyValue.atomicLazy(this::createRenderer);
        this.myUpdateTracker = new SimpleModificationTracker();
        this.myModificationTrackerOfViewUpdates = NotNullLazyValue.atomicLazy(this::createModificationTrackerOfViewUpdates);
        this.myZoomChangedModTracker = NotNullLazyValue.atomicLazy(this::createZoomChangedModificationTracker);
        this.myAlarm = new Alarm((Disposable)this);
        this.myPresentation = DiagramState.empty(provider);
        this.myProject = project;
        this.myProvider = provider;
        this.setShowEdgeLabels(true);
        DiagramExtras extras = provider.getExtras();
        this.myNodeHighlighter = extras.getNodeHighlighter();
        MessageBusListener listener = provider.getMessageBusListener(project, graph);
        if (listener != null) {
            project.getMessageBus().connect((Disposable)this).subscribe(listener.getTopic(), listener.getListener());
        }
        this.customizeDefaultSettings();
    }

    @NotNull
    public DiagramBuilder getDiagramBuilder() {
        DiagramBuilder diagramBuilder = (DiagramBuilder)super.getGraphBuilder();
        if (diagramBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(3);
        }
        return diagramBuilder;
    }

    public void setGraphBuilder(@NotNull GraphBuilder<DiagramNode<?>, DiagramEdge<?>> graphBuilder) {
        if (graphBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(4);
        }
        graphBuilder.addGraphBuilderListener((GraphBuilderListener)this, (Disposable)this);
        super.setGraphBuilder(graphBuilder);
    }

    private void customizeDefaultSettings() {
        DiagramExtras extras = this.myProvider.getExtras();
        if (extras.useDefaultLayouter()) {
            return;
        }
        Layouter layouter = extras.getCustomLayouter(this.getSettings(), this.myProject);
        if (layouter == null) {
            layouter = DiagramConfiguration.getInstance().layout.getPredefinedLayouter(this.getSettings());
        }
        GraphSettings.setupDataProvidersForEdgesMerging((Graph2D)((Graph2D)this.getGraph()));
        this.getSettings().setCurrentLayouter(layouter);
        this.getSettings().setFitContentAfterLayout(false);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable DiagramNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"UmlNodeInfoRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(5);
        }
        return nodeRealizer;
    }

    @NotNull
    protected DefaultUmlRenderer createRenderer() {
        return new DefaultUmlRenderer(this.getBuilder(), this.createModificationTrackerOfViewUpdates());
    }

    @NotNull
    public DefaultUmlRenderer getRenderer() {
        DefaultUmlRenderer defaultUmlRenderer = (DefaultUmlRenderer)((Object)this.myRenderer.getValue());
        if (defaultUmlRenderer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(6);
        }
        return defaultUmlRenderer;
    }

    @NotNull
    public ModificationTracker getModificationTrackerOfViewUpdates() {
        ModificationTracker modificationTracker = (ModificationTracker)this.myModificationTrackerOfViewUpdates.getValue();
        if (modificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(7);
        }
        return modificationTracker;
    }

    @NotNull
    protected ModificationTracker createModificationTrackerOfViewUpdates() {
        return new ModificationTracker(){
            final ModificationTracker modificationTracker;
            long myCount;
            {
                this.modificationTracker = DiagramPresentationModelImpl.this.getBuilder().getDataModel().getModificationTracker();
                this.myCount = this.modificationTracker.getModificationCount();
            }

            public long getModificationCount() {
                long count = this.modificationTracker.getModificationCount();
                if (this.myCount != count) {
                    this.myCount = count;
                    DiagramPresentationModelImpl.this.myAlarm.cancelAllRequests();
                    if (!DiagramPresentationModelImpl.this.myAlarm.isDisposed()) {
                        DiagramPresentationModelImpl.this.myAlarm.addRequest(() -> DumbService.getInstance((Project)DiagramPresentationModelImpl.this.myProject).runWhenSmart(() -> {
                            DiagramPresentationModelImpl.this.getBuilder().getDataModel().refreshDataModel();
                            DiagramPresentationModelImpl.this.update();
                            if (DiagramNodeEditorManager.getInstance().getCurrentCellEditor() != null) {
                                DiagramNodeEditorManager.getInstance().stopEditing(DiagramPresentationModelImpl.this.getBuilder());
                            }
                        }), 300);
                    }
                }
                return count + DiagramPresentationModelImpl.this.myUpdateTracker.getModificationCount();
            }
        };
    }

    @NotNull
    private ModificationTracker createZoomChangedModificationTracker() {
        GraphBuilder builder = Objects.requireNonNull(this.getBuilder().getGraphBuilder(), "Cannot create ZoomChangedModificationTracker until GraphBuilder has been set");
        final SimpleModificationTracker modTracker = new SimpleModificationTracker();
        builder.addGraphBuilderListener(new GraphBuilderListener(){

            public void beforeActionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
                if (builder == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void actionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
                if (builder == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (GraphBuilderEvent.ZOOM_CHANGED.equals((Object)event)) {
                    modTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        SimpleModificationTracker simpleModificationTracker = modTracker;
        if (simpleModificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(8);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getModificationTrackerOfZoomChanged() {
        ModificationTracker modificationTracker = (ModificationTracker)this.myZoomChangedModTracker.getValue();
        if (modificationTracker == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(9);
        }
        return modificationTracker;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable DiagramEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        if (edge != null) {
            if (!(edge instanceof DiagramNoteEdge)) {
                edgeRealizer.setLineColor(this.myProvider.getColorManager().getEdgeColor(this.getBuilder(), edge));
            } else {
                edgeRealizer.setLineColor(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.4));
            }
            DiagramRelationshipInfo info = edge.getRelationship();
            DiagramLineType lineType = info.getLineType();
            edgeRealizer.setLineType(DiagramPresentationModelImpl.toGraphLineType(info.getWidth(), lineType != null ? lineType : DiagramLineType.SOLID));
            edgeRealizer.setArrow(DiagramPresentationModelImpl.getArrow(info.getStartArrow()));
            edgeRealizer.setSourceArrow(DiagramPresentationModelImpl.getArrow(info.getEndArrow()));
        }
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(10);
        }
        return polyLineEdgeRealizer;
    }

    @Nullable
    private EdgeLabel createEdge(@Nullable String label, byte model, byte position, @Nullable Color color) {
        if (StringUtil.isEmpty((String)label)) {
            return null;
        }
        EdgeLabel edgeLabel = GraphManager.getGraphManager().createEdgeLabel(label);
        edgeLabel.setModel(model);
        edgeLabel.setPosition(position);
        edgeLabel.setTextColor(color == null ? this.getBuilder().getColorScheme().getDefaultForeground() : color);
        return edgeLabel;
    }

    public EdgeLabel @NotNull [] getEdgeLabels(@Nullable DiagramEdge umlEdge, @NotNull String edgeName) {
        if (edgeName == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(11);
        }
        if (!this.isShowEdgeLabels() || umlEdge == null) {
            if (EMPTY_LABELS == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(12);
            }
            return EMPTY_LABELS;
        }
        DiagramRelationshipInfo relationship = umlEdge.getRelationship();
        ArrayList<EdgeLabel> labels = new ArrayList<EdgeLabel>();
        EdgeLabel center = this.createEdge(relationship.getLabel(), EdgeLabel.CENTERED, EdgeLabel.CENTER, relationship.getLabelColor());
        EdgeLabel from = this.createEdge(relationship.getFromLabel(), EdgeLabel.SIX_POS, EdgeLabel.SHEAD, relationship.getFromLabelColor());
        EdgeLabel to = this.createEdge(relationship.getToLabel(), EdgeLabel.SIX_POS, EdgeLabel.THEAD, relationship.getToLabelColor());
        if (center != null) {
            labels.add(center);
        }
        if (from != null) {
            labels.add(from);
        }
        if (to != null) {
            labels.add(to);
        }
        EdgeLabel[] edgeLabelArray = labels.isEmpty() ? EMPTY_LABELS : labels.toArray(EMPTY_LABELS);
        if (edgeLabelArray == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(13);
        }
        return edgeLabelArray;
    }

    public boolean editNode(@Nullable DiagramNode node) {
        DiagramBuilder builder = this.getBuilder();
        if (node instanceof DiagramNoteNode) {
            DiagramNoteNode note = (DiagramNoteNode)node;
            String text = Messages.showMultilineInputDialog((Project)this.myProject, (String)DiagramBundle.message((String)"dialog.message.note.text", (Object[])new Object[0]), (String)DiagramBundle.message((String)"dialog.title.edit.note", (Object[])new Object[0]), (String)note.getTooltip(), (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
            if (text != null && !text.equals(note.getTooltip())) {
                Runnable editNote = () -> {
                    Node n = builder.getNode((DiagramNode)note);
                    NodeRealizer realizer = builder.getGraph().getRealizer(n);
                    double x = realizer.getX();
                    double y = realizer.getY();
                    DiagramNode originalNode = note.getIdentifyingElement();
                    DiagramDataModel dataModel = builder.getDataModel();
                    dataModel.removeNote(note);
                    builder.updateGraph();
                    dataModel.addNote(originalNode, text);
                    builder.updateGraph();
                    NodeRealizer noteRealizer = builder.getGraph().getRealizer(builder.getNode((DiagramNode)dataModel.getNotes().get(originalNode)));
                    noteRealizer.setX(x);
                    noteRealizer.setY(y);
                    builder.updateGraph();
                };
                DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)editNote, (String)DiagramBundle.message((String)"command.edit.note", (Object[])new Object[0]), null, (PsiElement[])new PsiElement[0]);
            }
            return true;
        }
        if (node == null) {
            return false;
        }
        DiagramExtras extras = node.getProvider().getExtras();
        EditNodeHandler editHandler = extras.getEditNodeHandler();
        if (editHandler != null) {
            editHandler.doEdit(node, (DiagramPresentationModel)this);
            return true;
        }
        if (this.getBuilder().isPopupMode()) {
            Object element = node.getIdentifyingElement();
            if (element instanceof Navigatable) {
                OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{(Navigatable)element});
                return true;
            }
        } else {
            Node nodeObj = builder.getNode(node);
            return DiagramUtils.isNodeWithoutBody((DiagramBuilder)builder, (Node)nodeObj);
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(@Nullable DiagramEdge edge) {
        if (edge == null) {
            return false;
        }
        EditEdgeHandler handler = this.getBuilder().getProvider().getExtras().getEditEdgeHandler();
        DiagramNode src = edge.getSource();
        DiagramNode trg = edge.getTarget();
        if (handler != null && !(src instanceof DiagramNoteNode) && !(trg instanceof DiagramNoteNode) && handler.doEdit(edge, (DiagramPresentationModel)this)) {
            return true;
        }
        Navigatable[] navigationElements = edge.getNavigationElements();
        if (navigationElements.length == 0) {
            return super.editEdge((Object)edge);
        }
        OpenSourceUtil.navigate((Navigatable[])navigationElements);
        return true;
    }

    @Nullable
    public String getNodeTooltip(@Nullable DiagramNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof DiagramNoteNode) {
            return "Note for " + ((DiagramNode)node.getIdentifyingElement()).getTooltip();
        }
        DiagramElementManager elementManager = this.myProvider.getElementManager();
        return elementManager.getNodeTooltip(node.getIdentifyingElement());
    }

    @Nullable
    public String getEdgeTooltip(@Nullable DiagramEdge edge) {
        return edge != null ? edge.getName() : null;
    }

    @RequiresEdt
    public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
        if (view == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(14);
        }
        if (editMode == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(15);
        }
        super.customizeSettings(view, editMode);
        view.setAntialiasedPainting(Registry.is((String)"diagrams.rendering.antialiasing"));
        DiagramPresentationModelImpl.setupNonAntialiasedBackgroundRenderer(view);
        view.setFitContentOnResize(false);
        view.setGridVisible(false);
        Graph2DRenderer renderer = view.getGraph2DRenderer();
        if (renderer instanceof DefaultGraph2DRenderer) {
            DefaultGraph2DRenderer r2d = (DefaultGraph2DRenderer)renderer;
            r2d.setDrawEdgesFirst(true);
        }
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(true);
        editMode.setOrthogonalEdgeRouting(GraphSettings.doesImplyOrthogonalEdgeRouting((Layouter)this.getSettings().getCurrentLayouter()));
        UmlActions.registerCustomShortcuts(this.getBuilder());
        UmlActions.install(this.getBuilder());
        for (DiagramNodeIntentionAction action : this.getBuilder().getProvider().getNodeIntentionActions()) {
            ShortcutSet shortcut;
            if (!(action instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action).getShortcut()) == null) continue;
            action.registerCustomShortcutSet(shortcut, this.getBuilder().getView().getCanvasComponent(), (Disposable)this.getBuilder());
        }
    }

    private static void setupNonAntialiasedBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(16);
        }
        DefaultBackgroundRenderer oldRenderer = (DefaultBackgroundRenderer)view.getBackgroundRenderer();
        DefaultBackgroundRenderer newRenderer = GraphManager.getGraphManager().createNonAntialiasedBackgroundRenderer(view);
        newRenderer.setColor(oldRenderer.getColor());
        newRenderer.setMode(oldRenderer.getMode());
        view.setBackgroundRenderer((BackgroundRenderer)newRenderer);
        view.addBackgroundDrawable(new Drawable(){

            public void paint(Graphics2D g) {
                if (Registry.is((String)"diagrams.rendering.antialiasing")) {
                    GraphicsUtil.setupAAPainting((Graphics)g);
                }
            }

            public Rectangle getBounds() {
                return new Rectangle(0, 0, 0, 0);
            }
        });
    }

    @Deprecated
    @NotNull
    public DiagramState getPresentation() {
        DiagramState diagramState = this.myPresentation;
        if (diagramState == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(17);
        }
        return diagramState;
    }

    @NotNull
    public EdgeCreationPolicy<DiagramNode<?>> getEdgeCreationPolicy() {
        final DiagramEdgeCreationPolicy policy = this.myProvider.getEdgeCreationPolicy();
        if (policy == null) {
            EdgeCreationPolicy edgeCreationPolicy = EdgeCreationPolicy.NOTHING_ACCEPTED_POLICY;
            if (edgeCreationPolicy == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(18);
            }
            return edgeCreationPolicy;
        }
        return new EdgeCreationPolicy<DiagramNode<?>>(){

            public boolean acceptSource(@NotNull DiagramNode source) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                return policy.acceptSource(source);
            }

            public boolean acceptTarget(@NotNull DiagramNode target) {
                if (target == null) {
                    4.$$$reportNull$$$0(1);
                }
                return policy.acceptTarget(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public NodeCellEditor getCustomNodeCellEditor(@Nullable DiagramNode umlNode) {
        return new DiagramNodeCellEditor(this.getBuilder());
    }

    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable DiagramNode info) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(19);
        }
        return defaultActionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected DefaultActionGroup getCommonActionGroup() {
        DiagramExtras extras;
        DiagramAddElementAction handler;
        DiagramScopeManager scopeManager;
        UmlVisibilityActionGroup visibility;
        DefaultActionGroup categories;
        DefaultActionGroup actions = new DefaultActionGroup();
        boolean isDiagramInPopup = this.getBuilder().isPopupMode();
        if (!isDiagramInPopup) {
            actions.add((AnAction)new ActionGroup(DiagramBundle.message((String)"group.action.text.new", (Object[])new Object[0]), true){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    if (e == null) {
                        if (EMPTY_ARRAY == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return EMPTY_ARRAY;
                    }
                    AnAction[] anActionArray = new UmlNewAction().getGroup(e.getDataContext()).getChildren(e);
                    if (anActionArray == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return anActionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/presentation/DiagramPresentationModelImpl$5", "getChildren"));
                }
            });
        }
        if (this.allowChangeVisibleCategories() && (categories = UmlActions.getCategoriesActions(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)categories);
        }
        if ((visibility = new UmlVisibilityActionGroup(this.getBuilder())).getChildrenCount() > 0) {
            actions.add((AnAction)visibility);
        }
        if ((scopeManager = this.getBuilder().getDataModel().getScopeManager()) != null) {
            UmlScopesActionGroup actionGroup = new UmlScopesActionGroup(this.getBuilder(), scopeManager);
            actions.add((AnAction)actionGroup);
        }
        if ((handler = (extras = this.getBuilder().getProvider().getExtras()).getAddElementHandler()) != null && !isDiagramInPopup) {
            actions.add((AnAction)handler);
        }
        actions.addSeparator();
        Object object = this.myActionsLock;
        synchronized (object) {
            if (this.myElementProvidersActions.getChildrenCount() > 0) {
                actions.addAll((ActionGroup)this.myElementProvidersActions);
                actions.addSeparator();
            }
            if (this.myExtraActions.getChildrenCount() > 0) {
                actions.addAll((ActionGroup)this.myExtraActions);
                actions.addSeparator();
            }
        }
        if (extras.isExpandCollapseActionsImplemented()) {
            actions.add(ActionManager.getInstance().getAction("Uml.CollapseNodes"));
            actions.add(ActionManager.getInstance().getAction("Uml.ExpandNodes"));
            actions.addSeparator();
        }
        if (this.getBuilder().getDataModel().isDependencyDiagramSupported()) {
            actions.add((AnAction)new UmlShowDependencies());
            actions.addSeparator();
        }
        if (extras.isDeleteActionImplemented()) {
            actions.add((AnAction)new DeleteSelectionWrapper.DeleteSelectedItemDiagramAction());
            actions.addSeparator();
        }
        if (extras.isSourceActionsImplemented()) {
            actions.add(ActionManager.getInstance().getAction("UML.SourceActionsGroup"));
            actions.addSeparator();
        }
        actions.add(ActionManager.getInstance().getAction("UML.DefaultGraphPopup"));
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(20);
        }
        return defaultActionGroup;
    }

    @GuardedBy(value="myActionsLock")
    private void registerElementProvidersActions() {
        for (DiagramElementsProvider provider : this.myProvider.getExtras().getElementsProviders()) {
            AddElementsFromPopupAction addElementsFromPopupAction = new AddElementsFromPopupAction(provider, this.getBuilder());
            this.myElementProvidersActions.add((AnAction)addElementsFromPopupAction);
        }
    }

    @GuardedBy(value="myActionsLock")
    private void registerExtraActions() {
        for (AnAction action : this.myProvider.getExtras().getExtraActions()) {
            this.myExtraActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActions() {
        Object object = this.myActionsLock;
        synchronized (object) {
            this.myElementProvidersActions.removeAll();
            this.myExtraActions.removeAll();
            this.registerElementProvidersActions();
            this.registerExtraActions();
        }
        new DeleteNodeContentAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), this.getBuilder().getView().getCanvasComponent());
    }

    public void update() {
        this.myUpdateTracker.incModificationCount();
        this.getBuilder().update(false, false);
    }

    public boolean isAutoRotateLabels() {
        return true;
    }

    private static LineType toGraphLineType(int width, DiagramLineType type) {
        switch (type) {
            case DASHED: {
                return LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_1.getLineStyle());
            }
            case DOTTED: {
                return LineType.Statics.getLineType((int)width, (byte)LineType.DOTTED_2.getLineStyle());
            }
        }
        return LineType.Statics.getLineType((int)width, (byte)LineType.LINE_1.getLineStyle());
    }

    @NotNull
    private static EditorColorsScheme getCurrentScheme() {
        EditorColorsScheme editorColorsScheme = GraphViewUtil.isPrintMode() ? EditorColorsManager.getInstance().getScheme("Default") : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    @NotNull
    private static Arrow getInnerArrow() {
        String innerClassArrow = "InnerClassArrow";
        if (Arrow.Statics.getCustomArrow((String)"InnerClassArrow") == null) {
            int r = 5;
            Drawable arrow = new Drawable(){

                public void paint(Graphics2D g) {
                    Paint paint = g.getPaint();
                    g.setPaint(DiagramPresentationModelImpl.getCurrentScheme().getDefaultBackground());
                    g.fillOval(-10, -5, 10, 10);
                    g.setPaint(paint);
                    g.drawOval(-10, -5, 10, 10);
                    g.drawLine(-5, -3, -5, 3);
                    g.drawLine(-8, 0, -2, 0);
                }

                public Rectangle getBounds() {
                    return new Rectangle(-5, -5, 5, 5);
                }
            };
            Arrow.Statics.addCustomArrow((String)"InnerClassArrow", (Drawable)arrow);
        }
        Arrow arrow = Arrow.Statics.getCustomArrow((String)"InnerClassArrow");
        if (arrow == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(22);
        }
        return arrow;
    }

    @NotNull
    private static Arrow getDeltaSmallArrow() {
        String deltaSmallArrow = "DeltaSmallArrow";
        if (Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow") == null) {
            Drawable arrow = new Drawable(){
                static final int r = 3;
                final int[] x = new int[]{-5, 1, -5};
                final int[] y = new int[]{-3, 0, 3};

                public void paint(Graphics2D g) {
                    g.fillPolygon(this.x, this.y, 3);
                }

                public Rectangle getBounds() {
                    return new Rectangle(0, 0, 6, 6);
                }
            };
            Arrow.Statics.addCustomArrow((String)"DeltaSmallArrow", (Drawable)arrow);
        }
        Arrow arrow = Arrow.Statics.getCustomArrow((String)"DeltaSmallArrow");
        if (arrow == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(23);
        }
        return arrow;
    }

    @NotNull
    private static Arrow getArrow(@Nullable Shape shape) {
        if (shape == null) {
            Arrow arrow = Arrow.NONE;
            if (arrow == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(24);
            }
            return arrow;
        }
        Arrow arrow = KNOWN_SHAPES.get(shape);
        if (arrow != null) {
            Arrow arrow2 = arrow;
            if (arrow2 == null) {
                DiagramPresentationModelImpl.$$$reportNull$$$0(25);
            }
            return arrow2;
        }
        String id = "UML_" + shape.hashCode();
        arrow = Arrow.Statics.getCustomArrow((String)id);
        Arrow arrow3 = arrow == null ? Arrow.Statics.addCustomArrow((String)id, (Shape)shape, (Color)ARROW_BG) : arrow;
        if (arrow3 == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(26);
        }
        return arrow3;
    }

    public void onSelectionChanged(@NotNull Graph2DSelectionEvent e) {
        if (e == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(27);
        }
        this.dropHighlightingFlag();
        if (this.myNodeHighlighter != null) {
            List list;
            this.myNodeHighlighter.selectionChanged(this.getBuilder());
            ArrayList nodes = DiagramUtils.getSelectedNodes((DiagramBuilder)this.getBuilder());
            for (DiagramNode node : new ArrayList(nodes)) {
                if (!(node instanceof DiagramNoteNode)) continue;
                nodes.remove(node);
            }
            if (!nodes.isEmpty() && (list = this.myNodeHighlighter.onNodeSelected((List)nodes, this.getBuilder().getDataModel())) != null && !list.isEmpty()) {
                for (DiagramNode umlNode : this.getBuilder().getNodeObjects()) {
                    umlNode.putUserData(DiagramNode.SELECTED_NODE_KEY, (Object)list.contains(umlNode));
                }
            }
        }
    }

    private void dropHighlightingFlag() {
        for (DiagramNode node : this.getBuilder().getNodeObjects()) {
            node.putUserData(DiagramNode.SELECTED_NODE_KEY, null);
        }
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = (DiagramBuilder)this.getGraphBuilder();
        if (diagramBuilder == null) {
            DiagramPresentationModelImpl.$$$reportNull$$$0(28);
        }
        return diagramBuilder;
    }

    static {
        KNOWN_SHAPES.put(DiagramRelationshipInfo.NONE, Arrow.NONE);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DIAMOND, Arrow.DIAMOND);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DELTA, Arrow.DELTA);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.STANDARD, Arrow.STANDARD);
        KNOWN_SHAPES.put(DiagramRelationshipInfo.INNER_CLASS_ARROW, DiagramPresentationModelImpl.getInnerArrow());
        KNOWN_SHAPES.put(DiagramRelationshipInfo.DELTA_SMALL, DiagramPresentationModelImpl.getDeltaSmallArrow());
        KNOWN_SHAPES.put(DiagramRelationshipInfo.WHITE_DELTA, Arrow.WHITE_DELTA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/presentation/DiagramPresentationModelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/presentation/DiagramPresentationModelImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTrackerOfViewUpdates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createZoomChangedModificationTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTrackerOfZoomChanged";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeCreationPolicy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActionGroup";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonActionGroup";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentScheme";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerArrow";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeltaSmallArrow";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrow";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGraphBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeLabels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setupNonAntialiasedBackgroundRenderer";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onSelectionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

