/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.java.project.DependencyPath;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.ModulesUmlCategoryManager;
import com.intellij.uml.java.project.ModulesUmlDataModel;
import com.intellij.uml.java.project.ModulesUmlNode;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleNodeIntentionActionBase
extends DiagramNodeIntentionAction<ModuleItem> {
    public ModuleNodeIntentionActionBase(@Nls String name, @Nls String description, Icon icon) {
        super(name, description, icon);
    }

    public boolean isAvailable(DiagramNode<ModuleItem> node) {
        return ((ModuleItem)node.getIdentifyingElement()).isModule();
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            ModuleNodeIntentionActionBase.$$$reportNull$$$0(0);
        }
        return ModuleNodeIntentionActionBase.getSelectedModuleNode(e) != null;
    }

    protected void showPaths(DiagramBuilder builder, Collection<List<Module>> paths) {
        ArrayList<DependencyPath> dependencyPaths = new ArrayList<DependencyPath>();
        for (List<Module> path : paths) {
            dependencyPaths.add(new DependencyPath(path.toArray(Module.EMPTY_ARRAY)));
        }
        Runnable command = () -> {
            ModulesUmlDataModel model = (ModulesUmlDataModel)builder.getDataModel();
            for (DiagramNode diagramNode : new ArrayList<ModulesUmlNode>(model.getNodes())) {
                DeleteSelectionWrapper.deleteNode(diagramNode, model);
            }
            for (DependencyPath dependencyPath : dependencyPaths) {
                for (Module module : dependencyPath.getPaths()) {
                    model.addElement(new ModuleItem(module));
                }
            }
            model.refreshDataModel(dependencyPaths);
        };
        DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)command, (String)this.getActionName(), null, (PsiElement[])new PsiElement[0]);
    }

    protected static Graph<Module> buildModulesGraph(DiagramBuilder builder, Project project) {
        return (Graph)ReadAction.compute(() -> {
            boolean includeTests = Objects.requireNonNull(builder.getDataModel().getNodeContentManager()).isCategoryEnabled(ModulesUmlCategoryManager.TEST);
            Graph moduleGraph = GraphAlgorithms.getInstance().invertEdgeDirections(ModuleManager.getInstance((Project)project).moduleGraph(includeTests));
            return moduleGraph;
        });
    }

    @Nullable
    private static ModulesUmlNode getSelectedModuleNode(AnActionEvent e) {
        DiagramNode node;
        Object element;
        List selectedNodes = ModuleNodeIntentionActionBase.getSelectedNodes((AnActionEvent)e);
        if (selectedNodes.size() == 1 && (element = (node = (DiagramNode)selectedNodes.get(0)).getIdentifyingElement()) instanceof ModuleItem && ((ModuleItem)element).isModule()) {
            return (ModulesUmlNode)node;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/java/project/actions/ModuleNodeIntentionActionBase", "isEnabled"));
    }
}

