/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.Layerer;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.OrderEntryNavigatable;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetAction;
import com.intellij.pom.Navigatable;
import com.intellij.uml.java.project.ModuleDependenciesProvider;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.ModulesUmlDnDProvider;
import com.intellij.uml.java.project.ModulesUmlEdge;
import com.intellij.uml.java.project.actions.AddModuleAction;
import com.intellij.uml.java.project.actions.ShowModuleCyclesAction;
import com.intellij.uml.java.project.actions.ShowPathsToModuleAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ModulesUmlExtras
extends CommonDiagramExtras<ModuleItem> {
    private final ModulesUmlDnDProvider dndProvider = new ModulesUmlDnDProvider();
    private final List<AnAction> myExtraActions = Arrays.asList(new AnAction[]{new ShowPathsToModuleAction(), new ShowModuleCyclesAction()});
    private static final DiagramElementsProvider[] PROVIDERS = new DiagramElementsProvider[]{new ModuleDependenciesProvider()};

    public ModulesUmlDnDProvider getDnDProvider() {
        return this.dndProvider;
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new AddModuleAction();
    }

    public DiagramElementsProvider<ModuleItem> @NotNull [] getElementsProviders() {
        if (PROVIDERS == null) {
            ModulesUmlExtras.$$$reportNull$$$0(0);
        }
        return PROVIDERS;
    }

    @NotNull
    public List<AnAction> getExtraActions() {
        List<AnAction> list = this.myExtraActions;
        if (list == null) {
            ModulesUmlExtras.$$$reportNull$$$0(1);
        }
        return list;
    }

    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        HierarchicGroupLayouter layouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        layouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.LEFT_TO_RIGHT));
        layouter.setMinimalNodeDistance(20.0);
        layouter.setMinimalLayerDistance(50.0);
        layouter.setLayerer((Layerer)GraphManager.getGraphManager().createBFSLayerer());
        return layouter;
    }

    public Object getData(@NotNull String dataId, List<DiagramNode<ModuleItem>> nodes, DiagramBuilder builder) {
        if (dataId == null) {
            ModulesUmlExtras.$$$reportNull$$$0(2);
        }
        if (!nodes.isEmpty()) {
            if (nodes.size() == 1) {
                DiagramNode<ModuleItem> node = nodes.get(0);
                ModuleItem moduleItem = (ModuleItem)node.getIdentifyingElement();
                Navigatable navigatable = moduleItem.getNavigatable();
                if (LangDataKeys.MODULE_CONTEXT.is(dataId) && moduleItem.isModule()) {
                    return moduleItem.getModule();
                }
                if (LangDataKeys.LIBRARY.is(dataId) && moduleItem.isLibrary()) {
                    return moduleItem.getLibrary();
                }
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    return navigatable;
                }
            }
            if (nodes.size() > 1 && LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                ArrayList<Module> modules = new ArrayList<Module>();
                for (DiagramNode diagramNode : nodes) {
                    if (!((ModuleItem)diagramNode.getIdentifyingElement()).isModule()) continue;
                    modules.add(((ModuleItem)diagramNode.getIdentifyingElement()).getModule());
                }
                return modules.toArray(Module.EMPTY_ARRAY);
            }
        } else {
            DiagramEdge edge;
            List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder);
            if (edges.size() == 1 && (edge = (DiagramEdge)edges.get(0)) instanceof ModulesUmlEdge) {
                ModulesUmlEdge modulesUmlEdge = (ModulesUmlEdge)edge;
                ModuleItem srcElement = (ModuleItem)modulesUmlEdge.getSource().getIdentifyingElement();
                ModuleItem trgElement = (ModuleItem)modulesUmlEdge.getTarget().getIdentifyingElement();
                if (CommonDataKeys.NAVIGATABLE.is(dataId) && srcElement.isModule()) {
                    return new OrderEntryNavigatable(srcElement.getModule(), (OrderEntry)modulesUmlEdge.findOrderEntry());
                }
                if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId) && srcElement.isModule() && trgElement.isModule()) {
                    return new Module[]{srcElement.getModule(), trgElement.getModule()};
                }
                if (LangDataKeys.MODULE_CONTEXT.is(dataId) && srcElement.isModule()) {
                    return srcElement.getModule();
                }
                if (AnalyzeDependenciesOnSpecifiedTargetAction.TARGET_SCOPE_KEY.is(dataId)) {
                    if (trgElement.isModule()) {
                        return trgElement.getModule().getModuleScope();
                    }
                    if (trgElement.isLibrary()) {
                        return new LibraryScope(srcElement.getProject(), trgElement.getLibrary());
                    }
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/project/ModulesUmlExtras";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/project/ModulesUmlExtras";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

