/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public final class JavaUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    private static final VisibilityLevel @NotNull [] levels = new VisibilityLevel[]{new VisibilityLevel("public"), new VisibilityLevel("packageLocal", DiagramBundle.message((String)"visibility.level.package", (Object[])new Object[0])), new VisibilityLevel("protected"), new VisibilityLevel("private", DiagramBundle.message((String)"visibility.level.all", (Object[])new Object[0]))};
    @NotNull
    private static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        int ind2;
        int ind1 = ArrayUtil.indexOf((Object[])levels, (Object)o1);
        return ind1 == (ind2 = ArrayUtil.indexOf((Object[])levels, (Object)o2)) ? 0 : (ind1 < 0 ? 1 : ind1 - ind2);
    };

    public VisibilityLevel @NotNull [] getVisibilityLevels() {
        if (levels == null) {
            JavaUmlVisibilityManager.$$$reportNull$$$0(0);
        }
        return levels;
    }

    public VisibilityLevel getVisibilityLevel(@Nullable Object element) {
        if (element instanceof JavaProperty) {
            element = ((JavaProperty)((Object)element)).getNotNullComponent();
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierList = (PsiModifierListOwner)element;
            if (modifierList.hasModifierProperty("public")) {
                return levels[0];
            }
            if (modifierList.hasModifierProperty("packageLocal")) {
                return levels[1];
            }
            if (modifierList.hasModifierProperty("protected")) {
                return levels[2];
            }
            if (modifierList.hasModifierProperty("private")) {
                return levels[3];
            }
        }
        return null;
    }

    @NotNull
    public Comparator<VisibilityLevel> getComparator() {
        Comparator<VisibilityLevel> comparator = COMPARATOR;
        if (comparator == null) {
            JavaUmlVisibilityManager.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    public boolean isRelayoutNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uml/java/JavaUmlVisibilityManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityLevels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

