/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramPsiScopeManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlColorManager;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.JavaUmlExtras;
import com.intellij.uml.java.JavaUmlRelationshipManager;
import com.intellij.uml.java.JavaUmlVfsResolver;
import com.intellij.uml.java.JavaUmlVisibilityManager;
import com.intellij.uml.java.actions.NewEnumConstant;
import com.intellij.uml.java.actions.NewJavaClass;
import com.intellij.uml.java.actions.NewJavaConstructor;
import com.intellij.uml.java.actions.NewJavaEnum;
import com.intellij.uml.java.actions.NewJavaField;
import com.intellij.uml.java.actions.NewJavaInterface;
import com.intellij.uml.java.actions.NewJavaMethod;
import com.intellij.uml.java.actions.NewJavaRecord;
import com.intellij.uml.java.utils.LightElementFacade;
import com.intellij.uml.utils.DiagramBundle;
import java.util.Collection;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUmlProvider
extends DiagramProvider<PsiElement> {
    public static final String ID = "JAVA";
    private final JavaUmlVisibilityManager myVisibilityManager;
    private final JavaUmlCategoryManager myCategoryManager;
    private final JavaUmlElementManager myElementManager;
    private final JavaUmlVfsResolver myVfsResolver;
    private final JavaUmlColorManager myColorManager = new JavaUmlColorManager();
    private final JavaUmlRelationshipManager myRelationshipManager = new JavaUmlRelationshipManager();
    private final JavaUmlExtras myExtras = new JavaUmlExtras();
    private static final DiagramEdgeCreationPolicy<PsiElement> EDGE_CREATION_POLICY = new DiagramEdgeCreationPolicy<PsiElement>(){

        public boolean acceptSource(@NotNull DiagramNode<PsiElement> source) {
            if (source == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!(source.getIdentifyingElement() instanceof PsiClass)) {
                return false;
            }
            PsiClass psiClass = (PsiClass)source.getIdentifyingElement();
            PsiFile file = psiClass.getContainingFile();
            Project prj = psiClass.getProject();
            if (file == null) {
                return false;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            return ProjectRootManager.getInstance((Project)prj).getFileIndex().isInSource(virtualFile);
        }

        public boolean acceptTarget(@NotNull DiagramNode<PsiElement> target) {
            if (target == null) {
                1.$$$reportNull$$$0(1);
            }
            return target.getIdentifyingElement() instanceof PsiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/java/JavaUmlProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptTarget";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DiagramCreateNewElementAction[] myActions = new DiagramCreateNewElementAction[]{new NewJavaClass(), new NewJavaInterface(), new NewJavaEnum(), new NewJavaRecord()};
    private final DiagramCreateNewNodeElementAction[] myNodeElementActions = new DiagramCreateNewNodeElementAction[]{new NewJavaField(), new NewJavaMethod(), new NewJavaConstructor(), new NewEnumConstant()};

    public JavaUmlProvider() {
        this.myVisibilityManager = new JavaUmlVisibilityManager();
        this.myCategoryManager = new JavaUmlCategoryManager();
        this.myElementManager = new JavaUmlElementManager();
        this.myVfsResolver = new JavaUmlVfsResolver();
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return ID;
    }

    @NotNull
    public JavaUmlVisibilityManager createVisibilityManager() {
        JavaUmlVisibilityManager javaUmlVisibilityManager = this.myVisibilityManager;
        if (javaUmlVisibilityManager == null) {
            JavaUmlProvider.$$$reportNull$$$0(0);
        }
        return javaUmlVisibilityManager;
    }

    @NotNull
    public JavaUmlCategoryManager getNodeContentManager() {
        JavaUmlCategoryManager javaUmlCategoryManager = this.myCategoryManager;
        if (javaUmlCategoryManager == null) {
            JavaUmlProvider.$$$reportNull$$$0(1);
        }
        return javaUmlCategoryManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new JavaUmlCategoryManager();
    }

    @NotNull
    public JavaUmlElementManager getElementManager() {
        JavaUmlElementManager javaUmlElementManager = this.myElementManager;
        if (javaUmlElementManager == null) {
            JavaUmlProvider.$$$reportNull$$$0(2);
        }
        return javaUmlElementManager;
    }

    @NotNull
    public JavaUmlVfsResolver getVfsResolver() {
        JavaUmlVfsResolver javaUmlVfsResolver = this.myVfsResolver;
        if (javaUmlVfsResolver == null) {
            JavaUmlProvider.$$$reportNull$$$0(3);
        }
        return javaUmlVfsResolver;
    }

    @NotNull
    public JavaUmlRelationshipManager getRelationshipManager() {
        JavaUmlRelationshipManager javaUmlRelationshipManager = this.myRelationshipManager;
        if (javaUmlRelationshipManager == null) {
            JavaUmlProvider.$$$reportNull$$$0(4);
        }
        return javaUmlRelationshipManager;
    }

    @NotNull
    public String getPresentableName() {
        String string = DiagramBundle.message((String)"uml.0.presentable.name", (Object[])new Object[]{JavaLanguage.INSTANCE.getDisplayName()});
        if (string == null) {
            JavaUmlProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getRefinedPresentableName(@Nullable PsiElement element, @NotNull Collection<PsiElement> additionalElements) {
        if (additionalElements == null) {
            JavaUmlProvider.$$$reportNull$$$0(6);
        }
        String languageName = Stream.concat(Stream.of(element), additionalElements.stream()).map(it -> {
            PsiElement navigationElement;
            PsiElement sourcePsi = LightElementFacade.asSourcePsi(it);
            PsiElement psiElement = navigationElement = element != null ? element.getNavigationElement() : null;
            return sourcePsi != null ? sourcePsi : (navigationElement != null ? navigationElement : it);
        }).filter(it -> it != null).map(it -> {
            try {
                Language language = it.getLanguage();
                return language.is((Language)JavaLanguage.INSTANCE) || "kotlin".equals(language.getID()) ? language : null;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(it -> it != null).findFirst().orElse((Language)JavaLanguage.INSTANCE).getDisplayName();
        String string = DiagramBundle.message((String)"uml.0.presentable.name", (Object[])new Object[]{languageName});
        if (string == null) {
            JavaUmlProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public DiagramDataModel<PsiElement> createDataModel(@NotNull Project project, @Nullable PsiElement element, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            JavaUmlProvider.$$$reportNull$$$0(8);
        }
        if (presentationModel == null) {
            JavaUmlProvider.$$$reportNull$$$0(9);
        }
        return new JavaUmlDataModel(project, element, file, presentationModel);
    }

    @NotNull
    public DiagramColorManager getColorManager() {
        JavaUmlColorManager javaUmlColorManager = this.myColorManager;
        if (javaUmlColorManager == null) {
            JavaUmlProvider.$$$reportNull$$$0(10);
        }
        return javaUmlColorManager;
    }

    @NotNull
    public JavaUmlExtras getExtras() {
        JavaUmlExtras javaUmlExtras = this.myExtras;
        if (javaUmlExtras == null) {
            JavaUmlProvider.$$$reportNull$$$0(11);
        }
        return javaUmlExtras;
    }

    public DiagramEdgeCreationPolicy<PsiElement> getEdgeCreationPolicy() {
        return EDGE_CREATION_POLICY;
    }

    public DiagramCreateNewElementAction @NotNull [] getCreateNewActions() {
        if (this.myActions == null) {
            JavaUmlProvider.$$$reportNull$$$0(12);
        }
        return this.myActions;
    }

    public DiagramCreateNewNodeElementAction<PsiElement, ?> @NotNull [] getCreateNewNodeElementActions() {
        if (this.myNodeElementActions == null) {
            JavaUmlProvider.$$$reportNull$$$0(13);
        }
        return this.myNodeElementActions;
    }

    public DiagramScopeManager<PsiElement> createScopeManager(@NotNull Project project) {
        if (project == null) {
            JavaUmlProvider.$$$reportNull$$$0(14);
        }
        return new DiagramPsiScopeManager(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibilityManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationshipManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewNodeElementActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedPresentableName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createScopeManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

