/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.HidingParametersDelegatingClass;
import com.intellij.uml.java.utils.HidingParametersDelegatingMethod;
import com.intellij.uml.java.utils.JavaDefaultParameterlessConstructor;
import com.intellij.uml.java.utils.LightElementFacade;
import com.intellij.uml.java.utils.NullabilityUtils;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ElementPresentation;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUmlElementManager
extends AbstractDiagramElementManager<PsiElement> {
    @Nullable
    public PsiElement findInDataContext(@NotNull DataContext context) {
        Project project;
        PsiElement initialElement;
        PsiElement initialElementAsSeed;
        if (context == null) {
            JavaUmlElementManager.$$$reportNull$$$0(0);
        }
        if ((initialElementAsSeed = JavaUmlElementManager.tryInterpretAsSeed(initialElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context), project = (Project)CommonDataKeys.PROJECT.getData(context))) != null) {
            return initialElementAsSeed;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiElement seedFromEditor;
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile == null && project != null) {
                psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            }
            if (psiFile != null && (seedFromEditor = JavaUmlElementManager.tryExtractSeedFromEditor(editor, psiFile)) != null && !(seedFromEditor instanceof PsiClassOwner)) {
                return seedFromEditor;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement tryInterpretAsSeed(@Nullable PsiElement element, @Nullable Project project) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory && project != null) {
            PsiDirectory dir = (PsiDirectory)element;
            PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(dir);
            return aPackage != null && JavaUmlElementManager.isPackageContainedInOneDirectory(project, aPackage, dir) ? aPackage : element;
        }
        if (element instanceof PsiPackage) {
            return project == null ? null : element;
        }
        PsiClassOwner lightFile = LightElementFacade.asJavaPsiFile(element);
        if (lightFile != null) {
            return lightFile;
        }
        PsiClass lightClass = LightElementFacade.asJavaPsiClass(element);
        if (lightClass != null) {
            return lightClass;
        }
        PsiMethod lightMethod = LightElementFacade.asJavaPsiMethod(element);
        if (lightMethod != null && lightMethod.isConstructor()) {
            return lightMethod.getContainingClass();
        }
        return null;
    }

    private static PsiElement tryExtractSeedFromEditor(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiClass psiClassOriginal;
        PsiElement target;
        PsiReference reference;
        if (editor == null) {
            JavaUmlElementManager.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            JavaUmlElementManager.$$$reportNull$$$0(2);
        }
        PsiClass resolved = LightElementFacade.asJavaPsiClass((reference = (PsiReference)PsiTreeUtil.findFirstParent((PsiElement)(target = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset())), (boolean)false, it -> it instanceof PsiReference)) != null ? reference.resolve() : null);
        Object object = psiClassOriginal = resolved != null ? resolved : PsiTreeUtil.findFirstParent((PsiElement)target, LightElementFacade::isJavaPsiClass);
        while (LightElementFacade.isJavaPsiAnonymousClass((PsiElement)psiClassOriginal)) {
            psiClassOriginal = PsiTreeUtil.findFirstParent((PsiElement)target, LightElementFacade::isJavaPsiClass);
        }
        return LightElementFacade.asJavaPsiClass((PsiElement)psiClassOriginal);
    }

    public static boolean isPackageContainedInOneDirectory(@NotNull Project project, @NotNull PsiPackage aPackage, @NotNull PsiDirectory dir) {
        PsiDirectory[] dirs;
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(3);
        }
        if (aPackage == null) {
            JavaUmlElementManager.$$$reportNull$$$0(4);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(5);
        }
        return (dirs = aPackage.getDirectories(GlobalSearchScope.allScope((Project)project))).length == 1 && dir.equals(dirs[0]);
    }

    @Nullable
    public static PsiPackage getDirectoryPackage(@NotNull PsiDirectory dir) {
        JavaDirectoryService service;
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(6);
        }
        return (service = JavaDirectoryService.getInstance()) == null ? null : service.getPackage(dir);
    }

    @NotNull
    public static List<PsiFile> getAllPsiFilesRecursively(@NotNull Project project, @NotNull PsiDirectory dir) {
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(8);
        }
        List result = VfsUtil.collectChildrenRecursively((VirtualFile)dir.getVirtualFile());
        List list = ContainerUtil.mapNotNull((Collection)result, it -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
            return LightElementFacade.asJavaPsiFile((PsiElement)psiFile);
        });
        if (list == null) {
            JavaUmlElementManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static Stream<PsiElement> getAllPackagesOrClassOwnersRecursively(@NotNull Project project, @NotNull PsiDirectory dir, @Nullable PsiPackage packageDirectoryBelongsTo, @NotNull List<PsiFile> allFiles) {
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(11);
        }
        if (allFiles == null) {
            JavaUmlElementManager.$$$reportNull$$$0(12);
        }
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)project);
        PsiFile[] directoryFiles = packageDirectoryBelongsTo != null ? ContainerUtil.filter(allFiles, it -> javaFacade.isInPackage((PsiElement)it, packageDirectoryBelongsTo)).toArray(PsiFile.EMPTY_ARRAY) : dir.getFiles();
        Stream<PsiFile> stream = Stream.concat(Arrays.stream(directoryFiles).filter(it -> it instanceof PsiClassOwner), Arrays.stream(dir.getSubdirectories()).flatMap(it -> {
            PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(it);
            return aPackage != null && JavaUmlElementManager.isPackageContainedInOneDirectory(project, aPackage, dir) ? Stream.of(aPackage) : JavaUmlElementManager.getAllPackagesOrClassOwnersRecursively(project, it, aPackage, allFiles);
        }));
        if (stream == null) {
            JavaUmlElementManager.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    public Collection<PsiElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            JavaUmlElementManager.$$$reportNull$$$0(14);
        }
        PsiElement[] initialElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (initialElements != null) {
            Set<PsiElement> result = ContainerUtil.map2SetNotNull(Arrays.asList(initialElements), it -> JavaUmlElementManager.tryInterpretAsSeed(it, project));
            Set<PsiElement> set = result.size() > 1 ? result : Collections.emptySet();
            if (set == null) {
                JavaUmlElementManager.$$$reportNull$$$0(15);
            }
            return set;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            JavaUmlElementManager.$$$reportNull$$$0(16);
        }
        return set;
    }

    public boolean canBeBuiltFrom(@Nullable Object element) {
        return this.isAcceptableAsNode(element) || element instanceof PsiClassOwner || element instanceof PsiDirectory;
    }

    public static boolean isAcceptedForDnD(@Nullable Object element) {
        if (!(element instanceof PsiElement)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)element;
        return JavaUmlElementManager.tryInterpretAsSeed(psiElement, psiElement.getProject()) != null;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return JavaUmlElementManager.isAcceptableAsNodeForJavaUml(element);
    }

    public static boolean isAcceptableAsNodeForJavaUml(@Nullable Object element) {
        if (element instanceof PsiClass) {
            return !(element instanceof PsiAnonymousClass);
        }
        return element instanceof PsiPackage;
    }

    public Object @NotNull [] getNodeItems(PsiElement parent) {
        if (parent instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)parent;
            ArrayList<JavaProperty> elements = new ArrayList<JavaProperty>();
            TreeSet<JavaProperty> properties = new TreeSet<JavaProperty>(Comparator.comparing(JavaProperty::getName));
            if (!UmlKotlinUtils.isFromKotlin((PsiElement)psiClass)) {
                ContainerUtil.addAll(elements, (Object[])psiClass.getFields());
            }
            Collection<PsiMethod> methods = JavaUmlElementManager.getClassMethods(psiClass);
            if (ArrayUtils.isEmpty((Object[])psiClass.getConstructors()) && !psiClass.isInterface() && !UmlKotlinUtils.TopLevel.isImplicitClassForTopLevelDeclarations(psiClass)) {
                methods.add(new JavaDefaultParameterlessConstructor(psiClass));
            }
            ContainerUtil.addAll(elements, methods);
            for (PsiMethod method : methods) {
                JavaProperty property = JavaProperty.create(method);
                if (property == null) continue;
                properties.add(property);
            }
            if (UmlKotlinUtils.isFromKotlin((PsiElement)psiClass)) {
                Arrays.stream(psiClass.getFields()).filter(it -> !"INSTANCE".equals(it.getName()) && !"Companion".equals(it.getName()) && !UmlKotlinUtils.Properties.isNonPhysicalFieldForDelegatedProperty(it)).map(it -> JavaProperty.create(it, false)).filter(it -> it.getGetterElseSetter() == null).forEach(properties::add);
            }
            elements.addAll(properties);
            Object[] objectArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
            if (objectArray == null) {
                JavaUmlElementManager.$$$reportNull$$$0(17);
            }
            return objectArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            JavaUmlElementManager.$$$reportNull$$$0(18);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    private static Collection<PsiMethod> getClassMethods(@NotNull PsiClass psiClass) {
        PsiClass defaultImpls;
        if (psiClass == null) {
            JavaUmlElementManager.$$$reportNull$$$0(19);
        }
        TreeSet<PsiMethod> result = new TreeSet<PsiMethod>(Comparator.comparing(JavaUmlElementManager::getMethodSignature));
        Optional.of(Arrays.stream(psiClass.getMethods())).map(methods -> UmlKotlinUtils.DataClasses.isDataClass(psiClass) ? UmlKotlinUtils.DataClasses.filterOutDataClassGeneratedMethods(methods) : methods).map(methods -> UmlKotlinUtils.Objects.isObject(psiClass) || UmlKotlinUtils.Objects.isCompanionObject(psiClass) ? methods.filter(it -> !it.isConstructor()) : methods).get().forEach(result::add);
        if (UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) && (defaultImpls = (PsiClass)ContainerUtil.find((Object[])psiClass.getInnerClasses(), UmlKotlinUtils.DefaultImpls::isDefaultImplsCompanion)) != null) {
            HidingParametersDelegatingClass defaultImplsWrapper = new HidingParametersDelegatingClass(defaultImpls, 0);
            ContainerUtil.addAll(result, (Object[])defaultImplsWrapper.getMethods());
        }
        TreeSet<PsiMethod> treeSet = result;
        if (treeSet == null) {
            JavaUmlElementManager.$$$reportNull$$$0(20);
        }
        return treeSet;
    }

    public boolean isContainerFor(PsiElement parent, PsiElement child) {
        if (parent instanceof PsiPackage && child instanceof PsiQualifiedNamedElement) {
            PsiQualifiedNamedElement psiQualifiedNamedElement = (PsiQualifiedNamedElement)child;
            PsiPackage psiPackage = (PsiPackage)parent;
            String fqn = psiQualifiedNamedElement.getQualifiedName();
            return fqn != null && fqn.startsWith(psiPackage.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public SimpleColoredText getPresentableElementTitle(PsiElement element) {
        if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
            return JavaUmlElementManager.getClassPresentableName((PsiClass)element);
        }
        return super.getPresentableElementTitle((Object)element);
    }

    public String getElementTitle(PsiElement element) {
        if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
            return ((PsiClass)element).getName();
        }
        if (element instanceof PsiPackage) {
            String name = ((PsiPackage)element).getName();
            return name == null ? DiagramBundle.message((String)"uml.java.default.package.title", (Object[])new Object[0]) : DiagramBundle.message((String)"uml.java.package.title", (Object[])new Object[]{name});
        }
        return ElementPresentation.forElement((PsiElement)element).getName();
    }

    public int getTitleAttributes(PsiElement element) {
        if (element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return 4;
        }
        return super.getTitleAttributes((Object)element);
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            JavaUmlElementManager.$$$reportNull$$$0(21);
        }
        if (element instanceof PsiMethod) {
            return IconManager.getIconForPsiMethod((PsiMethod)element, 1);
        }
        if (element instanceof PsiField) {
            return IconManager.getIconForPsiField((PsiField)element, 1);
        }
        if (element instanceof Iconable) {
            return ((Iconable)element).getIcon(1);
        }
        return super.getItemIcon(element, presentation);
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            JavaUmlElementManager.$$$reportNull$$$0(22);
        }
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        if (element instanceof PsiMethod) {
            return JavaUmlElementManager.getMethodPresentableName((PsiMethod)element);
        }
        if (element instanceof PsiField) {
            return JavaUmlElementManager.getPresentableNameInCommonStyleFor((PsiDocCommentOwner)((PsiField)element), ((PsiField)element).getName());
        }
        if (element instanceof PsiClass) {
            return JavaUmlElementManager.getClassPresentableName((PsiClass)element);
        }
        if (element instanceof PsiPackage) {
            return JavaUmlElementManager.getPackagePresentableName((PsiPackage)element);
        }
        if (element instanceof JavaProperty) {
            JavaProperty property = (JavaProperty)((Object)element);
            PsiMethod accessor = property.getGetterElseSetter();
            String name = property.getName();
            return JavaUmlElementManager.getPresentableNameInCommonStyleFor((PsiDocCommentOwner)Objects.requireNonNull(accessor != null ? accessor : property.getField()), name);
        }
        return null;
    }

    @NotNull
    private static SimpleColoredText getPackagePresentableName(PsiPackage psiPackage) {
        return new SimpleColoredText(psiPackage.getQualifiedName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @NotNull
    private static SimpleColoredText getClassPresentableName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlElementManager.$$$reportNull$$$0(23);
        }
        StringBuilder nameBuilder = new StringBuilder(StringUtil.notNullize((String)psiClass.getName()));
        PsiTypeParameterList paramList = psiClass.getTypeParameterList();
        PsiTypeParameter[] typeParams = paramList != null ? paramList.getTypeParameters() : PsiTypeParameter.EMPTY_ARRAY;
        JavaUmlElementManager.appendTypeParameters(nameBuilder, typeParams);
        @NlsSafe String className = nameBuilder.toString();
        SimpleColoredText result = new SimpleColoredText();
        if (UmlKotlinUtils.DataClasses.isDataClass(psiClass)) {
            result.append("data", JavaUmlElementManager.getKeywordAttributes());
            result.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        result.append(className, JavaUmlElementManager.getCommonStyleAttributes((PsiDocCommentOwner)psiClass));
        SimpleColoredText simpleColoredText = result;
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(24);
        }
        return simpleColoredText;
    }

    private static void appendTypeParameters(@NotNull StringBuilder sb, PsiTypeParameter @NotNull [] typeParams) {
        if (sb == null) {
            JavaUmlElementManager.$$$reportNull$$$0(25);
        }
        if (typeParams == null) {
            JavaUmlElementManager.$$$reportNull$$$0(26);
        }
        if (typeParams.length > 0) {
            sb.append('<');
        }
        for (int i = 0; i < typeParams.length; ++i) {
            sb.append(typeParams[i].getName());
            if (i == typeParams.length - 1) continue;
            sb.append(", ");
        }
        if (typeParams.length > 0) {
            sb.append('>');
        }
    }

    @NotNull
    private static SimpleColoredText getMethodPresentableName(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JavaUmlElementManager.$$$reportNull$$$0(27);
        }
        if (UmlKotlinUtils.Coroutines.isSuspendFun(psiMethod)) {
            HidingParametersDelegatingMethod hidingContinuationParameterWrapper = new HidingParametersDelegatingMethod(psiMethod, Objects.requireNonNull(psiMethod.getContainingClass()), psiMethod.getParameterList().getParametersCount() - 1);
            SimpleColoredText result = new SimpleColoredText();
            result.append("suspend", JavaUmlElementManager.getKeywordAttributes());
            result.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            result.append(JavaUmlElementManager.getMethodSignature((PsiMethod)hidingContinuationParameterWrapper), JavaUmlElementManager.getCommonStyleAttributes((PsiDocCommentOwner)psiMethod));
            SimpleColoredText simpleColoredText = result;
            if (simpleColoredText == null) {
                JavaUmlElementManager.$$$reportNull$$$0(28);
            }
            return simpleColoredText;
        }
        return JavaUmlElementManager.getPresentableNameInCommonStyleFor((PsiDocCommentOwner)psiMethod, JavaUmlElementManager.getMethodSignature(psiMethod));
    }

    @NotNull
    private static SimpleTextAttributes getKeywordAttributes() {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)EditorColorsUtil.getGlobalOrDefaultColorScheme().getAttributes(DefaultLanguageHighlighterColors.KEYWORD));
        if (simpleTextAttributes == null) {
            JavaUmlElementManager.$$$reportNull$$$0(29);
        }
        return simpleTextAttributes;
    }

    @NotNull
    private static SimpleColoredText getPresentableNameInCommonStyleFor(@NotNull PsiDocCommentOwner psiElement, @NotNull @NlsSafe String name) {
        if (psiElement == null) {
            JavaUmlElementManager.$$$reportNull$$$0(30);
        }
        if (name == null) {
            JavaUmlElementManager.$$$reportNull$$$0(31);
        }
        return new SimpleColoredText(name, JavaUmlElementManager.getCommonStyleAttributes(psiElement));
    }

    @NotNull
    private static SimpleTextAttributes getCommonStyleAttributes(@NotNull PsiDocCommentOwner psiElement) {
        if (psiElement == null) {
            JavaUmlElementManager.$$$reportNull$$$0(32);
        }
        return new SimpleTextAttributes(JavaUmlElementManager.getCommonStyleFor(psiElement), DEFAULT_TEXT_ATTR.getFgColor());
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getCommonStyleFor(@NotNull PsiDocCommentOwner psiElement) {
        if (psiElement == null) {
            JavaUmlElementManager.$$$reportNull$$$0(33);
        }
        int style = 0;
        if (psiElement.isDeprecated()) {
            style |= 4;
        }
        if (psiElement.getLanguage().is((Language)JavaLanguage.INSTANCE) && !psiElement.isPhysical() && !(psiElement instanceof JavaDefaultParameterlessConstructor)) {
            style |= 2;
        }
        return style;
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        Project project = element instanceof PsiElement ? ((PsiElement)element).getProject() : null;
        PsiType type = null;
        boolean isNullable = false;
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            type = field instanceof PsiEnumConstant ? null : field.getType();
            isNullable = NullabilityUtils.isNullable((PsiModifierListOwner)field);
        } else if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            boolean isSuspendFun = UmlKotlinUtils.Coroutines.isSuspendFun(method);
            type = isSuspendFun ? UmlKotlinUtils.Coroutines.getSuspendFunPresentableReturnType(method) : method.getReturnType();
            isNullable = !isSuspendFun && NullabilityUtils.isNullable((PsiModifierListOwner)method);
        } else if (element instanceof JavaProperty) {
            JavaProperty javaProperty = (JavaProperty)((Object)element);
            type = javaProperty.getType();
            boolean bl = isNullable = NullabilityUtils.isNullable((PsiModifierListOwner)javaProperty.getNotNullComponent()) || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project);
        }
        if (type == null) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        int style = 0;
        if (psiClass != null && psiClass.isDeprecated()) {
            style |= 4;
        }
        StringBuilder typePresentableTextBuilder = new StringBuilder();
        if (UmlKotlinUtils.isFromKotlin((PsiElement)element)) {
            UmlKotlinUtils.appendPresentableNameForKotlinType(typePresentableTextBuilder, type, project, isNullable || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project));
        } else {
            typePresentableTextBuilder.append(type.getPresentableText());
            if (isNullable || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project)) {
                typePresentableTextBuilder.append('?');
            }
        }
        @NlsSafe String typePresentableText = typePresentableTextBuilder.toString();
        return new SimpleColoredText(typePresentableText, new SimpleTextAttributes(style, DEFAULT_TEXT_ATTR.getFgColor()));
    }

    @NotNull
    @Nls
    public String getNodeTooltip(PsiElement element) {
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.notNullize((String)name));
            if (string == null) {
                JavaUmlElementManager.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = UmlJavaUtils.getInfo((PsiPackage)element).toString();
            if (string == null) {
                JavaUmlElementManager.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = DiagramJavaBundle.message("unknown.node.tooltip", new Object[0]);
        if (string == null) {
            JavaUmlElementManager.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            JavaUmlElementManager.$$$reportNull$$$0(37);
        }
        Project project = method.getProject();
        boolean isFromKotlin = UmlKotlinUtils.isFromKotlin((PsiElement)method);
        String methodName = UmlKotlinUtils.isInternal(method) ? StringUtil.substringBefore((String)method.getName(), (String)"$") : method.getName();
        boolean isBacktickedNamedMethod = UmlKotlinUtils.isBacktickNamedMethod(method);
        assert (methodName != null);
        StringBuilder signature = new StringBuilder();
        if (isBacktickedNamedMethod) {
            signature.append('`');
        }
        signature.append(methodName);
        if (isBacktickedNamedMethod) {
            signature.append('`');
        }
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            PsiType paramType = param.getType();
            if (isFromKotlin) {
                UmlKotlinUtils.appendPresentableNameForKotlinType(signature, paramType, project, NullabilityUtils.isNullable((PsiModifierListOwner)param) || NullabilityUtils.isNullable((PsiAnnotationOwner)paramType, project));
            } else {
                signature.append(paramType.getPresentableText());
                if (NullabilityUtils.isNullable((PsiModifierListOwner)param) || NullabilityUtils.isNullable((PsiAnnotationOwner)paramType, project)) {
                    signature.append('?');
                }
            }
            signature.append(", ");
        }
        if (method.getParameterList().getParameters().length != 0) {
            signature.delete(signature.length() - 2, signature.length());
        }
        signature.append(")");
        String string = signature.toString();
        if (string == null) {
            JavaUmlElementManager.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParams";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPsiFilesRecursively";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesOrClassOwnersRecursively";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMethods";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPresentableName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPresentableName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordAttributes";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTooltip";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractSeedFromEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPackageContainedInOneDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryPackage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllPsiFilesRecursively";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllPackagesOrClassOwnersRecursively";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getClassMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getClassPresentableName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeParameters";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPresentableName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameInCommonStyleFor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleAttributes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleFor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class IconManager {
        @NotNull
        public static Icon getIconForPsiClass(@NotNull PsiClass psiClass, @Iconable.IconFlags int flags) {
            Icon classIcon;
            if (psiClass == null) {
                IconManager.$$$reportNull$$$0(0);
            }
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)psiClass, (classIcon = psiClass.getIcon(0)) != null ? classIcon : PlatformIcons.CLASS_ICON, flags, false);
        }

        @NotNull
        public static Icon getIconForPsiMethod(@NotNull PsiMethod method, @Iconable.IconFlags int flags) {
            if (method == null) {
                IconManager.$$$reportNull$$$0(1);
            }
            Icon baseIcon = method.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)method, baseIcon, flags, true);
        }

        @NotNull
        public static Icon getIconForPsiField(@NotNull PsiField field, @Iconable.IconFlags int flags) {
            if (field == null) {
                IconManager.$$$reportNull$$$0(2);
            }
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)field, PlatformIcons.FIELD_ICON, flags, true);
        }

        @NotNull
        private static Icon getIconForPsiModifierListOwner(@NotNull PsiModifierListOwner modifierListOwner, @NotNull Icon baseIcon, @Iconable.IconFlags int flags, boolean addModifiersEarrings) {
            if (modifierListOwner == null) {
                IconManager.$$$reportNull$$$0(3);
            }
            if (baseIcon == null) {
                IconManager.$$$reportNull$$$0(4);
            }
            RowIcon layeredIcon = com.intellij.ui.IconManager.getInstance().createLayeredIcon((Iconable)modifierListOwner, baseIcon, addModifiersEarrings ? ElementPresentationUtil.getFlags((PsiModifierListOwner)modifierListOwner, (boolean)false) : 0);
            IconManager.setVisibilityIcon(modifierListOwner, layeredIcon, flags);
            RowIcon rowIcon = layeredIcon;
            if (rowIcon == null) {
                IconManager.$$$reportNull$$$0(5);
            }
            return rowIcon;
        }

        public static void setVisibilityIcon(@NotNull PsiModifierListOwner modifierListOwner, @NotNull RowIcon icon, @Iconable.IconFlags int flags) {
            if (modifierListOwner == null) {
                IconManager.$$$reportNull$$$0(6);
            }
            if (icon == null) {
                IconManager.$$$reportNull$$$0(7);
            }
            if (BitUtil.isSet((int)flags, (int)1)) {
                if (modifierListOwner instanceof PsiMethod && UmlKotlinUtils.isInternal((PsiMethod)modifierListOwner)) {
                    VisibilityIcons.setVisibilityIcon((int)2, (RowIcon)icon);
                } else {
                    VisibilityIcons.setVisibilityIcon((PsiModifierList)modifierListOwner.getModifierList(), (RowIcon)icon);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseIcon";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/JavaUmlElementManager$IconManager";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/JavaUmlElementManager$IconManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIconForPsiModifierListOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiField";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiModifierListOwner";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setVisibilityIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

