/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlEdge;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.JavaUmlNode;
import com.intellij.uml.java.JavaUmlRelationshipManager;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.JavaClassDependencyAnalyzer;
import com.intellij.uml.java.dependency.RelationshipAnalysisSimpleResult;
import com.intellij.uml.java.dependency.RelationshipAnalyzer;
import com.intellij.uml.java.dependency.UastClassDependencyAnalyzer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.java.utils.UmlPsiUtil;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public final class JavaUmlDataModel
extends DiagramDataModel<PsiElement> {
    @Nullable
    private volatile SmartPsiElementPointer<PsiElement> myInitialElement;
    private volatile boolean myHasAlreadyDroppedParents;
    private volatile boolean myUseInnerClasses;
    private volatile boolean myIsReinitializing;
    @GuardedBy(value="myLock")
    @NotNull
    private final List<SmartPsiElementPointer<PsiClass>> myInnerOnInit;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiClass>> myClasses;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiClass>> myClassesRemovedByUser;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiPackage>> myPackages;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiPackage>> myPackagesRemovedByUser;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramNode<PsiElement>> myNodes;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramEdge<PsiElement>> myEdges;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramEdge<PsiElement>> myDependencyEdges;
    @NotNull
    private final Object myLock;
    @Nullable
    private final VirtualFile myEditorFile;
    @NotNull
    private final DiagramPresentationModel myPresentationModel;
    @NotNull
    private final SmartPointerManager mySpManager;

    public JavaUmlDataModel(@NotNull Project project, @Nullable PsiElement psiElement, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            JavaUmlDataModel.$$$reportNull$$$0(0);
        }
        if (presentationModel == null) {
            JavaUmlDataModel.$$$reportNull$$$0(1);
        }
        super(project, Objects.requireNonNull(DiagramProvider.findByID((String)"JAVA")));
        this.myInnerOnInit = new ArrayList<SmartPsiElementPointer<PsiClass>>();
        this.myClasses = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
        this.myClassesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
        this.myPackages = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
        this.myPackagesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
        this.myNodes = new HashSet<DiagramNode<PsiElement>>();
        this.myEdges = new HashSet<DiagramEdge<PsiElement>>();
        this.myDependencyEdges = new HashSet<DiagramEdge<PsiElement>>();
        this.myLock = new Object();
        this.myEditorFile = file;
        this.myPresentationModel = presentationModel;
        this.mySpManager = SmartPointerManager.getInstance((Project)this.getProject());
        this.init(psiElement);
    }

    private void init(@Nullable PsiElement psiElement) {
        this.myIsReinitializing = true;
        this.myInitialElement = psiElement == null ? null : this.mySpManager.createSmartPsiElementPointer(psiElement);
        this.myHasAlreadyDroppedParents = false;
        this.myUseInnerClasses = Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES);
        if (psiElement != null) {
            this.addElement(psiElement);
        }
        this.myIsReinitializing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DiagramNode<PsiElement> addElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaUmlDataModel.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.findNode(element) != null) {
                return null;
            }
            Stream<DiagramNode<PsiElement>> nodes = element instanceof PsiPackage ? this.addPackage((PsiPackage)element) : (element instanceof PsiClass ? this.addClasses(!this.isModelInitializationFinished() && this.myIsReinitializing, (PsiClass)element) : (element instanceof PsiClassOwner ? this.addFile((PsiClassOwner)element) : (element instanceof PsiDirectory ? this.addDirectory((PsiDirectory)element) : Stream.of((DiagramNode)null))));
            return nodes.findFirst().orElse(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addClasses(boolean addParents, PsiClass ... classes) {
        PsiElement initialElement;
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(3);
        }
        List<Object> classesList = new ArrayList<PsiClass>(Arrays.asList(classes));
        if (!this.isModelInitializationFinished() || this.myIsReinitializing) {
            void var6_8;
            classesList = ContainerUtil.filter(classesList, it -> it.getQualifiedName() != null && !this.isInsidePackages((PsiClass)it));
            PsiClass[] psiClassArray = classes;
            int n = psiClassArray.length;
            boolean bl = false;
            while (var6_8 < n) {
                PsiClass psiClass = psiClassArray[var6_8];
                this.setupScopeManager(psiClass, true);
                if (PsiUtil.isInnerClass((PsiClass)psiClass) && !this.myUseInnerClasses) {
                    this.myUseInnerClasses = true;
                    Objects.requireNonNull(this.getNodeContentManager()).setCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES, true);
                }
                ++var6_8;
            }
            classesList.forEach(it -> this.myClassesRemovedByUser.remove(it.getQualifiedName()));
        }
        if (!(this.myHasAlreadyDroppedParents || this.isModelInitializationFinished() || this.myIsReinitializing || !((initialElement = JavaUmlDataModel.dereference(this.myInitialElement)) instanceof PsiClass) || this.myClasses.isEmpty())) {
            this.clearAllNodesAndEdges();
            this.clearAllData();
            this.myHasAlreadyDroppedParents = true;
            classesList.add((PsiClass)initialElement);
        }
        if (addParents) {
            classesList = classesList.stream().flatMap(it -> JavaUmlDataModel.findAllParentsForClass(it)).collect(Collectors.toList());
        }
        if (this.myUseInnerClasses) {
            classesList.addAll(ContainerUtil.flatMap(classesList, it -> new ArrayList<PsiClass>(UmlPsiUtil.getAllInnerClasses(it))));
        }
        HashSet<Object> classesSet = new HashSet<Object>(classesList);
        for (PsiClass psiClass : classesSet) {
            this.myClasses.put(psiClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiClass));
        }
        this.updateInitialInnerClasses();
        Stream<DiagramNode<PsiElement>> stream = classesSet.stream().map(it -> this.createJavaNode((PsiElement)it));
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(5);
        }
        if (!this.isModelInitializationFinished() || this.myIsReinitializing) {
            PsiPackage[] packages;
            Stream<DiagramNode<PsiElement>> classesStream = this.addClasses(false, psiPackage.getClasses());
            for (PsiPackage aPackage : packages = psiPackage.getSubPackages()) {
                this.myPackages.put(aPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)aPackage));
            }
            Stream<DiagramNode<PsiElement>> stream = Stream.concat(Arrays.stream(packages).map(this::createJavaNode), classesStream);
            if (stream == null) {
                JavaUmlDataModel.$$$reportNull$$$0(6);
            }
            return stream;
        }
        String fqn = psiPackage.getQualifiedName();
        if (fqn.isEmpty() || ContainerUtil.exists(this.myPackages.keySet(), packageFqn -> fqn.startsWith(packageFqn + "."))) {
            Stream<DiagramNode<PsiElement>> stream = Stream.empty();
            if (stream == null) {
                JavaUmlDataModel.$$$reportNull$$$0(7);
            }
            return stream;
        }
        this.myPackages.put(fqn, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myPackagesRemovedByUser.remove(fqn);
        Stream<JavaUmlNode> stream = Stream.of(this.createJavaNode((PsiElement)psiPackage));
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addFile(@NotNull PsiClassOwner psiFile) {
        if (psiFile == null) {
            JavaUmlDataModel.$$$reportNull$$$0(9);
        }
        return this.addClasses(false, psiFile.getClasses());
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addDirectory(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            JavaUmlDataModel.$$$reportNull$$$0(10);
        }
        Project project = this.getProject();
        List<PsiFile> allFilesInDir = JavaUmlElementManager.getAllPsiFilesRecursively(project, psiDirectory);
        PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(psiDirectory);
        Stream<DiagramNode<PsiElement>> stream = JavaUmlElementManager.getAllPackagesOrClassOwnersRecursively(project, psiDirectory, aPackage, allFilesInDir).flatMap(it -> {
            if (it instanceof PsiPackage) {
                return this.addPackage((PsiPackage)it);
            }
            if (it instanceof PsiClassOwner) {
                return this.addFile((PsiClassOwner)it);
            }
            assert (false) : "Incorrect element type " + it.getClass().getName();
            return Stream.empty();
        }).collect(Collectors.toList()).stream();
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @GuardedBy(value="myLock")
    private void updateInitialInnerClasses() {
        this.myInnerOnInit.clear();
        for (SmartPsiElementPointer<PsiClass> pointer : this.myClasses.values()) {
            PsiClass element = (PsiClass)pointer.getElement();
            if (element == null || !PsiUtil.isInnerClass((PsiClass)element)) continue;
            this.myInnerOnInit.add(pointer);
        }
    }

    @NotNull
    private JavaUmlNode createJavaNode(@NotNull PsiElement it) {
        if (it == null) {
            JavaUmlDataModel.$$$reportNull$$$0(12);
        }
        return new JavaUmlNode(it, (DiagramProvider<PsiElement>)this.getProvider());
    }

    @NotNull
    private static <V> Set<V> copy(@NotNull Set<V> set) {
        if (set == null) {
            JavaUmlDataModel.$$$reportNull$$$0(13);
        }
        return new HashSet<V>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DiagramNode<PsiElement>> getNodes() {
        Object object = this.myLock;
        // MONITORENTER : object
        Set<DiagramNode<PsiElement>> set = JavaUmlDataModel.copy(this.myNodes);
        // MONITOREXIT : object
        if (set != null) return set;
        JavaUmlDataModel.$$$reportNull$$$0(14);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DiagramEdge<PsiElement>> getEdges() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myDependencyEdges.isEmpty()) {
            Set<DiagramEdge<PsiElement>> set = JavaUmlDataModel.copy(this.myEdges);
            // MONITOREXIT : object
            if (set != null) return set;
            JavaUmlDataModel.$$$reportNull$$$0(15);
            return set;
        }
        Set<DiagramEdge<PsiElement>> allEdges = JavaUmlDataModel.copy(this.myEdges);
        allEdges.addAll(this.myDependencyEdges);
        Set<DiagramEdge<PsiElement>> set = allEdges;
        // MONITOREXIT : object
        if (set != null) return set;
        JavaUmlDataModel.$$$reportNull$$$0(16);
        return set;
    }

    @GuardedBy(value="myLock")
    private void collapseToPackage(@NotNull DiagramNode<? extends PsiElement> umlNode) {
        PsiElement element;
        PsiPackage psiPackage;
        if (umlNode == null) {
            JavaUmlDataModel.$$$reportNull$$$0(17);
        }
        PsiPackage psiPackage2 = psiPackage = (element = (PsiElement)umlNode.getIdentifyingElement()) instanceof PsiPackage ? ((PsiPackage)element).getParentPackage() : UmlJavaUtils.getPackage(element);
        if (psiPackage == null || psiPackage.getQualifiedName().isEmpty()) {
            return;
        }
        String fqnStart = psiPackage.getQualifiedName() + ".";
        ContainerUtil.filter(this.myPackages.keySet(), fqn -> fqn.startsWith(fqnStart)).forEach(fqn -> this.myPackages.remove(fqn));
        ContainerUtil.filter(this.myClasses.keySet(), fqn -> fqn.startsWith(fqnStart)).forEach(fqn -> this.myClasses.remove(fqn));
        this.myPackages.put(psiPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myPackagesRemovedByUser.remove(psiPackage.getQualifiedName());
    }

    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(18);
        }
        if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PsiClass) {
            String string = "Class " + ((PsiClass)element).getQualifiedName();
            if (string == null) {
                JavaUmlDataModel.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = "Package " + ((PsiPackage)element).getQualifiedName();
            if (string == null) {
                JavaUmlDataModel.$$$reportNull$$$0(20);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public DiagramEdge<PsiElement> createEdge(@NotNull DiagramNode<PsiElement> from, @NotNull DiagramNode<PsiElement> to) {
        if (from == null) {
            JavaUmlDataModel.$$$reportNull$$$0(21);
        }
        if (to == null) {
            JavaUmlDataModel.$$$reportNull$$$0(22);
        }
        Ref errorHolder = Ref.create();
        PsiClass source = (PsiClass)from.getIdentifyingElement();
        PsiClass target = (PsiClass)to.getIdentifyingElement();
        String srcName = JavaUmlDataModel.getNameForClass(source);
        String dstName = JavaUmlDataModel.getNameForClass(target);
        DiagramRelationshipInfo relationship = JavaUmlDataModel.inferRelationshipInfo(source, target);
        String commandName = JavaUmlDataModel.getEdgeCreationCommandName(relationship, srcName, dstName);
        Callable<JavaUmlEdge> callable = () -> {
            try {
                errorHolder.set((Object)(target.isAnnotationType() ? UmlPsiUtil.annotateClass(source, target) : UmlPsiUtil.createInheritanceBetween(source, target)));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (errorHolder.get() != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new Exception((String)errorHolder.get());
                }
                Messages.showErrorDialog((Project)((PsiElement)from.getIdentifyingElement()).getProject(), (String)((String)errorHolder.get()), (String)DiagramBundle.message((String)"error.cant.create.edge", (Object[])new Object[0]));
                return null;
            }
            JavaUmlEdge edge = new JavaUmlEdge(from, to, relationship, new NavigatablePsiElement[0]);
            Object object = this.myLock;
            synchronized (object) {
                this.myEdges.add((DiagramEdge<PsiElement>)edge);
            }
            DiagramBuilder builder = this.getBuilder();
            builder.update(true, false);
            if (!UmlPsiUtil.isAbstract(source) && !OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)source).isEmpty()) {
                int code;
                Project project = builder.getProject();
                int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((Project)project, (String)DiagramBundle.message((String)"class.must.be.abstract.or.implement.methods", (Object[])new Object[]{source.getName()}), (String)DiagramBundle.message((String)"class.must.be.abstract.title", (Object[])new Object[0]), (String)DiagramBundle.message((String)"generate.methods", (Object[])new Object[0]), (String)DiagramBundle.message((String)"make.abstract", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (code == 0) {
                    VirtualFile file;
                    PsiFile psiFile = source.getContainingFile();
                    VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
                    if (psiFile == null) {
                        return null;
                    }
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), false);
                    OverrideImplementUtil.chooseAndImplementMethods((Project)project, (Editor)editor, (PsiClass)source);
                    if (!ApplicationManager.getApplication().isUnitTestMode() && this.myEditorFile != null) {
                        FileEditorManager.getInstance((Project)project).openFile(this.myEditorFile, true);
                    }
                } else {
                    UmlPsiUtil.makeClassAbstract(source);
                }
            }
            return edge;
        };
        return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{((PsiElement)from.getIdentifyingElement()).getContainingFile()});
    }

    @NotNull
    @Nls
    private static String getNameForClass(@NotNull PsiClass source) {
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(23);
        }
        String string = StringUtil.notNullize((String)source.getName(), (String)("<" + DiagramJavaBundle.message("unknown.node.tooltip", new Object[0]) + ">"));
        if (string == null) {
            JavaUmlDataModel.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static DiagramRelationshipInfo inferRelationshipInfo(@NotNull PsiClass src, @NotNull PsiClass dst) {
        if (src == null) {
            JavaUmlDataModel.$$$reportNull$$$0(25);
        }
        if (dst == null) {
            JavaUmlDataModel.$$$reportNull$$$0(26);
        }
        if (dst.isInterface()) {
            if (dst.isAnnotationType()) {
                DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.ANNOTATION;
                if (diagramRelationshipInfo == null) {
                    JavaUmlDataModel.$$$reportNull$$$0(27);
                }
                return diagramRelationshipInfo;
            }
            DiagramRelationshipInfo diagramRelationshipInfo = src.isInterface() ? JavaUmlRelationships.INTERFACE_GENERALIZATION : JavaUmlRelationships.REALIZATION;
            if (diagramRelationshipInfo == null) {
                JavaUmlDataModel.$$$reportNull$$$0(28);
            }
            return diagramRelationshipInfo;
        }
        if (src.isEquivalentTo((PsiElement)dst)) {
            DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.DEPENDENCY;
            if (diagramRelationshipInfo == null) {
                JavaUmlDataModel.$$$reportNull$$$0(29);
            }
            return diagramRelationshipInfo;
        }
        DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.GENERALIZATION;
        if (diagramRelationshipInfo == null) {
            JavaUmlDataModel.$$$reportNull$$$0(30);
        }
        return diagramRelationshipInfo;
    }

    @Nullable
    @Nls
    private static String getEdgeCreationCommandName(@NotNull DiagramRelationshipInfo relationship, @NotNull String srcName, @NotNull String dstName) {
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(31);
        }
        if (srcName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(32);
        }
        if (dstName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(33);
        }
        String messageKey = null;
        if (relationship == JavaUmlRelationships.ANNOTATION) {
            messageKey = "create.edge.command.name.annotation";
        } else if (relationship == JavaUmlRelationships.GENERALIZATION || relationship == JavaUmlRelationships.INTERFACE_GENERALIZATION) {
            messageKey = "create.edge.command.name.extends";
        } else if (relationship == JavaUmlRelationships.REALIZATION) {
            messageKey = "create.edge.command.name.implements";
        }
        return messageKey != null ? DiagramJavaBundle.message(messageKey, srcName, dstName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(@NotNull DiagramNode<PsiElement> node) {
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(34);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.removeElement((PsiElement)node.getIdentifyingElement());
        }
    }

    public void removeEdge(@NotNull DiagramEdge<PsiElement> edge) {
        if (edge == null) {
            JavaUmlDataModel.$$$reportNull$$$0(35);
        }
        PsiElement source = (PsiElement)edge.getSource().getIdentifyingElement();
        PsiElement target = (PsiElement)edge.getTarget().getIdentifyingElement();
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (source instanceof PsiClass && target instanceof PsiClass && relationship != DiagramRelationshipInfo.NO_RELATIONSHIP) {
            int exitCode;
            PsiClass srcCls = (PsiClass)source;
            PsiClass trgCls = (PsiClass)target;
            int n = exitCode = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)srcCls.getProject(), (String)JavaUmlDataModel.getMessageForEdgeRemoval(JavaUmlDataModel.getNameForClass(srcCls), JavaUmlDataModel.getNameForClass(trgCls), relationship), (String)DiagramBundle.message((String)"remove.relationship.link", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (exitCode == 0) {
                String commandName = DiagramJavaBundle.message("create.edge.command.name.remove.link", srcCls.getName(), trgCls.getName());
                Runnable runnable = () -> {
                    if (UmlJavaUtils.prepareClassForWrite(srcCls)) {
                        try {
                            PsiModifierList list;
                            PsiReferenceList extendsList = Objects.requireNonNull(srcCls.getExtendsList(), "Diagram has not been updated");
                            PsiReferenceList implementsList = Objects.requireNonNull(srcCls.getImplementsList(), "Diagram has not been updated");
                            if (relationship == JavaUmlRelationships.GENERALIZATION || relationship == JavaUmlRelationships.INTERFACE_GENERALIZATION) {
                                RefactoringUtil.removeFromReferenceList((PsiReferenceList)extendsList, (PsiClass)trgCls);
                            } else if (relationship == JavaUmlRelationships.REALIZATION) {
                                RefactoringUtil.removeFromReferenceList((PsiReferenceList)(srcCls.isInterface() ? extendsList : implementsList), (PsiClass)trgCls);
                            } else if (relationship == JavaUmlRelationships.ANNOTATION && (list = srcCls.getModifierList()) != null) {
                                for (PsiAnnotation annotation : list.getAnnotations()) {
                                    if (!annotation.isPhysical() || !annotation.isValid() || !Objects.equals(annotation.getQualifiedName(), trgCls.getQualifiedName())) continue;
                                    annotation.delete();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)commandName, null, (PsiElement[])new PsiElement[]{source.getContainingFile()});
            }
        }
    }

    @NotNull
    @Nls
    private static String getMessageForEdgeRemoval(@NotNull @Nls String sourceName, @NotNull @Nls String targetName, @NotNull DiagramRelationshipInfo relationship) {
        if (sourceName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(36);
        }
        if (targetName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(37);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(38);
        }
        String string = relationship == JavaUmlRelationships.ANNOTATION ? DiagramBundle.message((String)"remove.annotation.from.class", (Object[])new Object[]{targetName, sourceName}) : DiagramBundle.message((String)"this.will.remove.relationship.link.between.classes", (Object[])new Object[]{sourceName});
        if (string == null) {
            JavaUmlDataModel.$$$reportNull$$$0(39);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDataModel() {
        Object object = this.myLock;
        synchronized (object) {
            this.clearAllNodesAndEdges();
            this.myUseInnerClasses = ContainerUtil.exists((Object[])Objects.requireNonNull(this.getNodeContentManager()).getEnabledCategories(), it -> it == JavaUmlCategoryManager.INNER_CLASSES);
            this.updateDataModel();
        }
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            JavaUmlDataModel.$$$reportNull$$$0(40);
        }
        return psiModificationTracker;
    }

    @GuardedBy(value="myLock")
    private void clearAllNodesAndEdges() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.myDependencyEdges.clear();
    }

    @GuardedBy(value="myLock")
    private void clearAllData() {
        this.myClasses.clear();
        this.myClassesRemovedByUser.clear();
        this.myInnerOnInit.clear();
        this.myPackages.clear();
        this.myPackagesRemovedByUser.clear();
    }

    @GuardedBy(value="myLock")
    private boolean isAllowedToShow(@Nullable PsiClass psiClass) {
        PsiElement initialElement = this.getInitialElement();
        DiagramScopeManager scopeManager = this.getScopeManager();
        return psiClass != null && psiClass.isValid() && !ContainerUtil.exists(this.myClassesRemovedByUser.values(), it -> psiClass.equals(it.getElement())) && (scopeManager == null || scopeManager.contains((Object)psiClass)) && !this.isInsidePackages(psiClass) && !UmlKotlinUtils.DefaultImpls.isDefaultImplsCompanion(psiClass) && (this.myUseInnerClasses || psiClass.getContainingClass() == null || initialElement instanceof PsiClass && JavaUmlDataModel.equals(psiClass, (PsiClass)initialElement) || ContainerUtil.exists(this.myInnerOnInit, it -> psiClass.equals(it.getElement())));
    }

    private boolean isAllowedToShow(@NotNull PsiPackage aPackage) {
        if (aPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(41);
        }
        DiagramScopeManager scopeManager = this.getScopeManager();
        return aPackage.isValid() && (scopeManager == null || scopeManager.contains((Object)aPackage));
    }

    private static boolean equals(@Nullable PsiClass one, @Nullable PsiClass another) {
        return one != null && one.isValid() && another != null && another.isValid() && Objects.equals(one.getQualifiedName(), another.getQualifiedName());
    }

    @GuardedBy(value="myLock")
    private void updateDataModel() {
        Set<PsiClass> classes = this.getAllClassesFromCurrentModel();
        Set interfaces = ContainerUtil.map2SetNotNull(classes, it -> it.isInterface() ? it.getQualifiedName() : null);
        Set annotations = ContainerUtil.map2SetNotNull(classes, it -> it.isAnnotationType() ? it.getQualifiedName() : null);
        this.updatePackages();
        this.updateClasses(classes);
        for (PsiClass psiClass : classes) {
            DiagramNode<PsiElement> source = this.findNode((PsiElement)psiClass);
            if (source == null) continue;
            this.updateClassGeneralizationEdgesFor(psiClass, source);
            this.updateInterfaceGeneralizationEdgesFor(psiClass, source, interfaces);
            this.updateInterfaceRealizationEdgesFor(psiClass, source);
            this.updateInnerClassEdgesFor(psiClass, source, classes);
            this.updateAnnotationEdgesFor(psiClass, source, annotations);
            this.updateTypeParametersEdgesFor(psiClass, source);
        }
        if (this.isShowDependencies()) {
            if (UndoManager.getInstance((Project)this.getProject()).isUndoOrRedoInProgress()) {
                this.doShowDependenciesNow(null, classes);
            } else {
                this.showDependenciesLater(classes);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void updatePackages() {
        PsiElement initElement = JavaUmlDataModel.dereference(this.myInitialElement);
        if (initElement instanceof PsiPackage) {
            PsiPackage initPackage = (PsiPackage)initElement;
            Arrays.stream(initPackage.getSubPackages()).map(it -> Pair.create((Object)it.getQualifiedName(), (Object)it)).filter(it -> !this.myPackages.containsKey(it.first) && !this.myPackagesRemovedByUser.containsKey(it.first)).forEach(it -> this.myPackages.put((String)it.first, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)((PsiPackage)it.second))));
        }
        Set<String> packageFqns = this.myPackages.keySet();
        this.myPackages.values().stream().map(it -> (PsiPackage)it.getElement()).filter(psiPackage -> {
            String fqn = psiPackage != null ? UmlJavaUtils.getFQN((PsiElement)psiPackage) : null;
            return fqn != null && this.isAllowedToShow((PsiPackage)psiPackage) && !ContainerUtil.exists((Iterable)packageFqns, it -> fqn.startsWith(it + "."));
        }).forEach(this::addNode);
    }

    @GuardedBy(value="myLock")
    private void updateClasses(@NotNull Set<PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(42);
        }
        for (PsiClass psiClass : classes) {
            if (!this.isAllowedToShow(psiClass)) continue;
            this.addNode((PsiElement)psiClass);
        }
    }

    @GuardedBy(value="myLock")
    private void updateClassGeneralizationEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> source) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(43);
        }
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(44);
        }
        if (JavaUmlDataModel.isGeneralizationEdgeAllowed(psiClass)) {
            DiagramNode<PsiElement> target = null;
            for (PsiClass superClass = psiClass.getSuperClass(); target == null && superClass != null; superClass = superClass.getSuperClass()) {
                target = this.findNode((PsiElement)superClass);
            }
            if (target != null && source != target) {
                this.addEdge(source, target, JavaUmlRelationships.GENERALIZATION);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void updateInterfaceGeneralizationEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> source, @NotNull Set<@NlsSafe String> interfaces) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(45);
        }
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(46);
        }
        if (interfaces == null) {
            JavaUmlDataModel.$$$reportNull$$$0(47);
        }
        if (psiClass.isInterface()) {
            JavaUmlDataModel.findNearestInterfaces(psiClass, interfaces).distinct().forEach(inter -> {
                DiagramNode<PsiElement> target = this.findNode((PsiElement)inter);
                if (target != null && source != target) {
                    this.addEdge(source, target, JavaUmlRelationships.INTERFACE_GENERALIZATION);
                }
            });
        }
    }

    @GuardedBy(value="myLock")
    private void updateInterfaceRealizationEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> source) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(48);
        }
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(49);
        }
        if (psiClass.isInterface()) {
            return;
        }
        HashSet inters = new HashSet();
        ContainerUtil.addAll(inters, (Object[])psiClass.getInterfaces());
        for (PsiClass curr = psiClass.getSuperClass(); curr != null && this.findNode((PsiElement)curr) == null; curr = curr.getSuperClass()) {
            ContainerUtil.addAll(inters, (Object[])curr.getInterfaces());
        }
        ArrayList faces = new ArrayList(inters);
        while (!faces.isEmpty()) {
            PsiClass inter = (PsiClass)faces.get(0);
            if (this.findNode((PsiElement)inter) != null) {
                DiagramNode<PsiElement> target = this.findNode((PsiElement)inter);
                if (target != null && source != target) {
                    this.addEdge(source, target, JavaUmlRelationships.REALIZATION);
                }
                faces.remove(inter);
                continue;
            }
            faces.remove(inter);
            ContainerUtil.addAll(faces, (Object[])inter.getInterfaces());
        }
    }

    @GuardedBy(value="myLock")
    private void updateInnerClassEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> target, @NotNull Set<PsiClass> classes) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(50);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(51);
        }
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(52);
        }
        if (!this.isInsidePackages(psiClass) && this.myUseInnerClasses) {
            for (PsiClass inner : psiClass.getInnerClasses()) {
                DiagramNode<PsiElement> source;
                if (!classes.contains(inner) || (source = this.findNode((PsiElement)inner)) == null || source == target) continue;
                this.addEdge(source, target, JavaUmlRelationships.INNER_CLASS);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void updateAnnotationEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> source, @NotNull Set<@Nullable @NlsSafe String> annotations) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(53);
        }
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(54);
        }
        if (annotations == null) {
            JavaUmlDataModel.$$$reportNull$$$0(55);
        }
        for (PsiClass annotation : UmlPsiUtil.findAnnotationsForClass(psiClass)) {
            DiagramNode<PsiElement> target;
            if (!annotations.contains(annotation.getQualifiedName()) || (target = this.findNode((PsiElement)annotation)) == null || source == target) continue;
            this.addEdge(source, target, JavaUmlRelationships.ANNOTATION);
        }
    }

    @GuardedBy(value="myLock")
    private void updateTypeParametersEdgesFor(@NotNull PsiClass psiClass, @NotNull DiagramNode<PsiElement> source) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(56);
        }
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(57);
        }
        for (PsiClass extClass : UmlPsiUtil.getTypeParametersForClass(psiClass)) {
            DiagramNode<PsiElement> target = this.findNode((PsiElement)extClass);
            if (target == null || source == target) continue;
            this.addEdge(source, target, JavaUmlRelationships.DEPENDENCY);
        }
    }

    @NotNull
    private static Stream<? extends PsiClass> findNearestInterfaces(@NotNull PsiClass psiClass, @NotNull Set<String> interfaces) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(58);
        }
        if (interfaces == null) {
            JavaUmlDataModel.$$$reportNull$$$0(59);
        }
        Stream stream = Arrays.stream(psiClass.getInterfaces()).flatMap(it -> interfaces.contains(it.getQualifiedName()) ? Stream.of(it) : JavaUmlDataModel.findNearestInterfaces(it, interfaces));
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(60);
        }
        return stream;
    }

    private static boolean isGeneralizationEdgeAllowed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(61);
        }
        return !psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @GuardedBy(value="myLock")
    private boolean isInsidePackages(@NotNull PsiClass psiClass) {
        String clsFqn;
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(62);
        }
        return (clsFqn = UmlJavaUtils.getFQN((PsiElement)psiClass)) != null && this.myPackages.keySet().stream().anyMatch(packageFqn -> clsFqn.startsWith(packageFqn + "."));
    }

    @GuardedBy(value="myLock")
    private void addNode(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(63);
        }
        this.myNodes.add((DiagramNode<PsiElement>)this.createJavaNode(psiElement));
    }

    @GuardedBy(value="myLock")
    private void addEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship) {
        PsiElement sourceElement;
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(64);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(65);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(66);
        }
        this.addEdge(source, target, relationship, (sourceElement = (PsiElement)source.getIdentifyingElement()) instanceof NavigatablePsiElement ? (NavigatablePsiElement)sourceElement : null, this.myEdges);
    }

    @GuardedBy(value="myLock")
    private void addDependencyEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship, @Nullable NavigatablePsiElement navigatable) {
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(67);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(68);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(69);
        }
        this.addEdge(source, target, relationship, navigatable, this.myDependencyEdges);
    }

    @GuardedBy(value="myLock")
    private void addEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship, @Nullable NavigatablePsiElement navigatable, @NotNull Collection<DiagramEdge<PsiElement>> storage) {
        NavigatablePsiElement[] navigatablePsiElementArray;
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(70);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(71);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(72);
        }
        if (storage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(73);
        }
        JavaUmlRelationshipManager relationshipManager = (JavaUmlRelationshipManager)this.getProvider().getRelationshipManager();
        if (navigatable != null) {
            NavigatablePsiElement[] navigatablePsiElementArray2 = new NavigatablePsiElement[1];
            navigatablePsiElementArray = navigatablePsiElementArray2;
            navigatablePsiElementArray2[0] = navigatable;
        } else {
            navigatablePsiElementArray = NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        }
        JavaUmlEdge newEdge = new JavaUmlEdge(source, target, relationship, navigatablePsiElementArray);
        boolean isSuppressed = Stream.concat(this.myEdges.stream(), this.myDependencyEdges.stream()).anyMatch(it -> relationshipManager.isSubtype((DiagramEdge<PsiElement>)it, (DiagramEdge<PsiElement>)newEdge));
        if (isSuppressed) {
            return;
        }
        for (DiagramEdge suppressedEdge : ContainerUtil.filter(this.myDependencyEdges, it -> relationshipManager.isSubtype((DiagramEdge<PsiElement>)newEdge, (DiagramEdge<PsiElement>)it))) {
            this.myDependencyEdges.remove(suppressedEdge);
        }
        DiagramEdge alreadyPresent = (DiagramEdge)ContainerUtil.find(storage, (Object)((Object)newEdge));
        if (alreadyPresent != null) {
            if (navigatable != null) {
                ((JavaUmlEdge)alreadyPresent).addNavigationElement(navigatable);
            }
        } else {
            storage.add((DiagramEdge<PsiElement>)newEdge);
        }
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Set<PsiClass> getAllClassesFromCurrentModel() {
        PsiElement initElement = JavaUmlDataModel.dereference(this.myInitialElement);
        PsiPackage initPackage = initElement instanceof PsiPackage ? (PsiPackage)initElement : null;
        Stream<PsiClass> classesAddedByUser = this.myClasses.values().stream().map(it -> (PsiClass)it.getElement());
        Stream initPackageClasses = initPackage != null ? Arrays.stream(initPackage.getClasses()) : Stream.empty();
        Stream myPackagesClasses = this.myPackages.values().stream().map(it -> (PsiPackage)it.getElement()).filter(it -> it != null).flatMap(it -> Arrays.stream(it.getClasses()));
        List topLevel = Stream.of(classesAddedByUser, initPackageClasses, myPackagesClasses).flatMap(it -> it).filter(it -> it != null).collect(Collectors.toList());
        Stream inner = this.myUseInnerClasses ? topLevel.stream().flatMap(it -> UmlPsiUtil.getAllInnerClasses(it).stream()) : Stream.empty();
        Set<PsiClass> set = Stream.concat(topLevel.stream(), inner).filter(it -> it != null && it.isValid() && !this.myClassesRemovedByUser.containsKey(it.getQualifiedName())).collect(Collectors.toSet());
        if (set == null) {
            JavaUmlDataModel.$$$reportNull$$$0(74);
        }
        return set;
    }

    @NotNull
    private static Stream<PsiClass> findAllParentsForClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(75);
        }
        Stream supers = Arrays.stream(psiClass.getSupers()).flatMap(base -> {
            if (base.getSuperClass() != null) {
                return JavaUmlDataModel.findAllParentsForClass(base);
            }
            if (!psiClass.isInterface() && !JavaUmlDataModel.isJavaLangObject(base)) {
                return Stream.of(base);
            }
            return Stream.empty();
        });
        Stream annotations = UmlPsiUtil.getAnnotationClassesForClass(psiClass).stream();
        Stream typeParameters = UmlPsiUtil.getTypeParametersForClass(psiClass).stream();
        Stream<PsiClass> stream = Stream.of(Stream.of(psiClass), supers, annotations, typeParameters).flatMap(it -> it).distinct();
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(76);
        }
        return stream;
    }

    private static boolean isJavaLangObject(@Nullable PsiClass cls) {
        return cls != null && "java.lang.Object".equals(cls.getQualifiedName());
    }

    @GuardedBy(value="myLock")
    @Nullable
    private DiagramNode<PsiElement> findNode(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(77);
        }
        return this.myNodes.stream().filter(it -> {
            String fqn = UmlJavaUtils.getFQN((PsiElement)it.getIdentifyingElement());
            return fqn != null && fqn.equals(UmlJavaUtils.getFQN(psiElement));
        }).findAny().orElseGet(() -> {
            String packageName = UmlJavaUtils.getPackageName(psiElement);
            PsiPackage aPackage = (PsiPackage)JavaUmlDataModel.dereference(packageName != null ? this.myPackages.get(packageName) : null);
            return aPackage == null || aPackage == psiElement ? null : this.findNode((PsiElement)aPackage);
        });
    }

    public void dispose() {
    }

    @GuardedBy(value="myLock")
    private void removeElement(@NotNull PsiElement element) {
        DiagramNode<PsiElement> node;
        if (element == null) {
            JavaUmlDataModel.$$$reportNull$$$0(78);
        }
        if ((node = this.findNode(element)) == null) {
            this.myClasses.remove(UmlJavaUtils.getFQN(element));
        } else {
            this.myNodes.remove(node);
            ContainerUtil.filter(this.myEdges, e -> e.getTarget().equals(node) || e.getSource().equals(node)).forEach(this.myEdges::remove);
            ContainerUtil.filter(this.myDependencyEdges, e -> e.getTarget().equals(node) || e.getSource().equals(node)).forEach(this.myDependencyEdges::remove);
            if (element instanceof PsiClass) {
                this.removeClass((PsiClass)element);
            }
            if (element instanceof PsiPackage) {
                this.removePackage((PsiPackage)element);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void removePackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(79);
        }
        String packageName = psiPackage.getQualifiedName();
        this.myPackages.remove(packageName);
        this.myPackagesRemovedByUser.put(packageName, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myClasses.entrySet().stream().filter(it -> {
            PsiClass psiClass = (PsiClass)JavaUmlDataModel.dereference((SmartPsiElementPointer)it.getValue());
            return psiClass != null && Objects.equals(packageName, UmlJavaUtils.getRealPackageName((PsiElement)psiClass));
        }).collect(Collectors.toSet()).forEach(e -> this.myClasses.remove(e.getKey()));
    }

    @GuardedBy(value="myLock")
    private void removeClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(80);
        }
        this.myClassesRemovedByUser.put(psiClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiClass));
        this.myClasses.remove(psiClass.getQualifiedName());
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            this.myClassesRemovedByUser.put(innerClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)innerClass));
            this.myClasses.remove(innerClass.getQualifiedName());
        }
    }

    @GuardedBy(value="myLock")
    private void expandPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(81);
        }
        String packageName = psiPackage.getQualifiedName();
        this.myPackages.remove(packageName);
        this.myPackagesRemovedByUser.put(packageName, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.addClasses(false, psiPackage.getClasses());
        for (PsiPackage aPackage : psiPackage.getSubPackages()) {
            this.addPackage(aPackage);
        }
    }

    private void showDependenciesLater(final @NotNull Set<PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(82);
        }
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), DiagramBundle.message((String)"uml.java.calculating.dependencies", (Object[])new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = JavaUmlDataModel.this.myLock;
                synchronized (object) {
                    JavaUmlDataModel.this.doShowDependenciesNow(indicator, classes);
                    ApplicationManager.getApplication().invokeLater(() -> JavaUmlDataModel.this.getBuilder().update(true, true));
                }
            }

            public void onCancel() {
                JavaUmlDataModel.this.setShowDependencies(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/uml/java/JavaUmlDataModel$1", "run"));
            }
        }));
    }

    @GuardedBy(value="myLock")
    private void doShowDependenciesNow(@Nullable ProgressIndicator indicator, @NotNull Set<? extends PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(83);
        }
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        ArrayList computedDependencies = new ArrayList();
        int classInd = 1;
        for (PsiClass psiClass : classes) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            ReadAction.run(() -> {
                DiagramNode<PsiElement> sourceNode;
                if (indicator != null) {
                    String className = psiClass.getName();
                    indicator.setText(DiagramBundle.message((String)"uml.java.analyzing.0", (Object[])new Object[]{className}));
                }
                if ((sourceNode = this.findNode((PsiElement)psiClass)) != null) {
                    Pair classDependencies = new Pair(sourceNode, JavaUmlDataModel.getClassDependenciesAnalyzer(psiClass).compute(psiClass));
                    computedDependencies.add(classDependencies);
                }
            });
            ++classInd;
            if (indicator == null) continue;
            indicator.setFraction((double)classInd / (double)classes.size());
        }
        ReadAction.run(() -> {
            for (Pair dependencyInfo : computedDependencies) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                DiagramNode sourceNode = (DiagramNode)dependencyInfo.first;
                for (RelationshipAnalysisSimpleResult dependency : (Collection)dependencyInfo.second) {
                    DiagramNode<PsiElement> targetNode = this.findNode((PsiElement)dependency.getTarget());
                    if (targetNode == null) continue;
                    this.addDependencyEdge((DiagramNode<PsiElement>)sourceNode, targetNode, dependency.getRelationshipInfo(), dependency.getNavigatableElement());
                }
            }
        });
    }

    @NotNull
    private static RelationshipAnalyzer<PsiClass, RelationshipAnalysisSimpleResult<PsiClass>> getClassDependenciesAnalyzer(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(84);
        }
        return psiClass.getLanguage().is((Language)JavaLanguage.INSTANCE) ? new JavaClassDependencyAnalyzer() : new UastClassDependencyAnalyzer();
    }

    @Nullable
    public PsiElement getInitialElement() {
        PsiElement result = JavaUmlDataModel.dereference(this.myInitialElement);
        return result == null || !result.isValid() ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasElement(@Nullable PsiElement element) {
        Object object = this.myLock;
        synchronized (object) {
            return element != null && this.findNode(element) != null;
        }
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseNode(@NotNull DiagramNode<PsiElement> node) {
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(85);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.collapseToPackage(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandNode(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(86);
        }
        if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PsiPackage) {
            Object object = this.myLock;
            synchronized (object) {
                this.expandPackage((PsiPackage)element);
            }
        }
    }

    public boolean isPsiListener() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(@Nullable PsiElement element) {
        Object object = this.myLock;
        synchronized (object) {
            super.rebuild((Object)element);
            this.myClasses.clear();
            this.myClassesRemovedByUser.clear();
            this.myPackages.clear();
            this.myPackagesRemovedByUser.clear();
            this.clearAllNodesAndEdges();
            this.init(element);
            this.refreshDataModel();
        }
    }

    @Nullable
    private static <T extends PsiElement> T dereference(@Nullable SmartPsiElementPointer<T> pointer) {
        return (T)(pointer == null ? null : pointer.getElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 60: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 60: 
            case 74: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 2: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 42: 
            case 52: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 60: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlDataModel";
                break;
            }
            case 5: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umlNode";
                break;
            }
            case 18: 
            case 34: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 23: 
            case 44: 
            case 46: 
            case 49: 
            case 54: 
            case 57: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 31: 
            case 38: 
            case 66: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationship";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 58: 
            case 61: 
            case 62: 
            case 75: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 47: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 51: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 63: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlDataModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addClasses";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForClass";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "inferRelationshipInfo";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageForEdgeRemoval";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestInterfaces";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassesFromCurrentModel";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentsForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 60: 
            case 74: 
            case 76: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPackage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJavaNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collapseToPackage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNameForClass";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "inferRelationshipInfo";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeCreationCommandName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForEdgeRemoval";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedToShow";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateClasses";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateClassGeneralizationEdgesFor";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateInterfaceGeneralizationEdgesFor";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateInterfaceRealizationEdgesFor";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "updateInnerClassEdgesFor";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "updateAnnotationEdgesFor";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "updateTypeParametersEdgesFor";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findNearestInterfaces";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralizationEdgeAllowed";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackages";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyEdge";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentsForClass";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "removePackage";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "removeClass";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "expandPackage";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "showDependenciesLater";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "doShowDependenciesNow";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getClassDependenciesAnalyzer";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "collapseNode";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 60: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

