/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.ui.CellRendererPanel;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.UmlUtils;
import java.awt.Point;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DiagramNodeCellEditor
extends AbstractCellEditor
implements NodeCellEditor {
    private final DiagramBuilder myBuilder;
    private JComponent myEditor;
    private Object myValue;

    public DiagramNodeCellEditor(DiagramBuilder builder) {
        this.myBuilder = builder;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    public JComponent getEditor() {
        return this.myEditor;
    }

    public JComponent getNodeCellEditorComponent(Graph2DView view, NodeRealizer context, Object value, boolean isSelected) {
        if (this.myEditor == null) {
            this.initEditor(context);
        }
        this.myValue = value;
        this.myEditor.putClientProperty("NodeCellRenderer.noImage", Boolean.TRUE);
        return this.myEditor;
    }

    private void initEditor(NodeRealizer realizer) {
        DefaultUmlRenderer umlRenderer = ((DiagramPresentationModelImpl)this.myBuilder.getPresentationModel()).getRenderer();
        CellRendererPanel panel = new CellRendererPanel();
        panel.setOpaque(true);
        panel.setBorder(umlRenderer.getBorder(realizer, this.myValue, true));
        panel.setFocusable(false);
        Point p = UmlUtils.getNodeCoordinatesOnScreen(realizer.getNode(), this.myBuilder.getView());
        panel.putClientProperty((Object)"cell.editor", (Object)Boolean.TRUE);
        umlRenderer.tuneNode(realizer, (JPanel)panel, p);
        this.myEditor = panel;
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(this, this.myBuilder);
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(null, this.myBuilder);
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        return true;
    }

    @Override
    public void cancelCellEditing() {
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(null, this.myBuilder);
        super.cancelCellEditing();
    }
}

