/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.dnd;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlDnDSupport
extends DropTargetAdapter {
    @NotNull
    private final DiagramBuilder myBuilder;
    @Nullable
    private final DiagramDnDProvider<?> myDnDProvider;

    public UmlDnDSupport(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlDnDSupport.$$$reportNull$$$0(0);
        }
        this.myBuilder = builder;
        this.myDnDProvider = builder.getProvider().getExtras().getDnDProvider();
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent event) {
        Object[] values;
        if (event == null) {
            UmlDnDSupport.$$$reportNull$$$0(1);
        }
        if (this.myDnDProvider == null || (values = UmlDnDSupport.getValues(event.getTransferable())).length == 0) {
            event.rejectDrag();
            return;
        }
        for (Object value : values) {
            if (this.myDnDProvider.isAcceptedForDnD(value, this.myBuilder.getProject())) continue;
            event.rejectDrag();
            return;
        }
        event.acceptDrag(3);
    }

    private static Object @NotNull [] getValues(@NotNull Transferable transferable) {
        block9: {
            Object[] objectArray;
            block8: {
                if (transferable == null) {
                    UmlDnDSupport.$$$reportNull$$$0(2);
                }
                TreeNode[] treeNodes = AbstractProjectViewPane.getTransferedTreeNodes((Transferable)transferable);
                if (treeNodes == null) break block8;
                ArrayList<Object> values = new ArrayList<Object>();
                for (TreeNode treeNode : treeNodes) {
                    Object userObject;
                    if (!(treeNode instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof AbstractTreeNode)) continue;
                    values.add(((AbstractTreeNode)userObject).getValue());
                }
                Object[] objectArray2 = ArrayUtil.toObjectArray(values);
                if (objectArray2 == null) {
                    UmlDnDSupport.$$$reportNull$$$0(3);
                }
                return objectArray2;
            }
            try {
                Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
                if (!(transferData instanceof Object[])) break block9;
                objectArray = (Object[])transferData;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (objectArray == null) {
                UmlDnDSupport.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            UmlDnDSupport.$$$reportNull$$$0(5);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent event) {
        if (event == null) {
            UmlDnDSupport.$$$reportNull$$$0(6);
        }
        if (this.myDnDProvider == null) {
            event.rejectDrop();
            return;
        }
        Point loc = event.getLocation();
        Object[] valuesToDrop = UmlDnDSupport.getValues(event.getTransferable());
        ArrayList<Object> newElementsForDataModel = new ArrayList<Object>();
        for (Object valueToDrop : valuesToDrop) {
            Object[] element;
            Project project = this.myBuilder.getProject();
            if (!this.myDnDProvider.isAcceptedForDnD(valueToDrop, project) || (element = this.myDnDProvider.wrapToModelObject(valueToDrop, project)) == null || element.length <= 0) continue;
            newElementsForDataModel.addAll(Arrays.asList(element));
        }
        if (!newElementsForDataModel.isEmpty()) {
            Runnable addElements = () -> {
                boolean setCoord = false;
                DiagramDataModel dataModel = this.myBuilder.getDataModel();
                for (Object element : newElementsForDataModel) {
                    DiagramNode umlNode = dataModel.addElement(element);
                    if (setCoord || umlNode == null) continue;
                    umlNode.putUserData(Utils.GRAPH_BUILDER, (Object)this.myBuilder);
                    Node node = NodeFactory.getInstance().createDraggedNode((GraphBuilder)((UmlGraphBuilder)this.myBuilder), (Object)umlNode, umlNode.getTooltip(), new Point(0, 0));
                    if (node == null) continue;
                    Graph2DView view = this.myBuilder.getView();
                    this.myBuilder.getGraph().getRealizer(node).setLocation(view.toWorldCoordX((int)loc.getX()), view.toWorldCoordY((int)loc.getY()));
                    setCoord = true;
                }
                dataModel.refreshDataModel();
                this.myBuilder.updateGraph();
            };
            DiagramAction.performCommand((DiagramBuilder)this.myBuilder, (Runnable)addElements, (String)DiagramBundle.message((String)"command.add.elements", (Object[])new Object[0]), null, (PsiElement[])new PsiElement[0]);
        }
        event.dropComplete(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/dnd/UmlDnDSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/dnd/UmlDnDSupport";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dragEnter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

