/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.renderers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class UmlNoteContainer
extends JPanel {
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final DiagramNoteNode myNote;
    @NotNull
    private final Point myBasePoint;
    private boolean myIsSelected;

    public UmlNoteContainer(@NotNull DiagramNoteNode note, @NotNull DiagramBuilder builder, @NotNull Point point) {
        if (note == null) {
            UmlNoteContainer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            UmlNoteContainer.$$$reportNull$$$0(1);
        }
        if (point == null) {
            UmlNoteContainer.$$$reportNull$$$0(2);
        }
        super(new BorderLayout(0, 0));
        this.myBuilder = builder;
        this.myNote = note;
        this.myBasePoint = point;
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setOpaque(false);
        panel.setFocusable(false);
        String tooltip = note.getTooltip();
        JBTextArea textArea = tooltip != null ? new JBTextArea(tooltip, (int)tooltip.lines().count(), tooltip.lines().mapToInt(it -> it.length()).max().orElse(0)) : new JBTextArea();
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        textArea.setForeground(colorManager.getNodeForeground(builder, (DiagramNode)note, null, false));
        textArea.setFont(colorManager.getNodeBodyFont());
        textArea.setSize(textArea.getPreferredSize());
        textArea.setEditable(false);
        panel.add((Component)textArea, "Center");
        this.add((Component)panel, "Center");
        this.setFocusable(false);
        this.setOpaque(true);
        this.setBackground(colorManager.getNodeBackground(builder, (DiagramNode)note, null, false));
        this.setBorder(this.getMyBorder(false));
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.myBasePoint.x - p.x + event.getX(), this.myBasePoint.y - p.y + event.getY());
    }

    @Override
    public void paint(Graphics g) {
        boolean isSelected = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode((DiagramNode)this.myNote));
        if (isSelected != this.myIsSelected) {
            this.myIsSelected = isSelected;
            this.setBorder(this.getMyBorder(isSelected));
        }
        super.paint(g);
    }

    @NotNull
    private Border getMyBorder(boolean isSelected) {
        Color borderColor = this.myBuilder.getProvider().getColorManager().getNodeBorderColor(this.myBuilder, (DiagramNode)this.myNote, isSelected);
        Border border = JBUI.Borders.merge((Border)new LineBorder(borderColor, 1), (Border)JBUI.Borders.empty((int)5, (int)10), (boolean)false);
        if (border == null) {
            UmlNoteContainer.$$$reportNull$$$0(3);
        }
        return border;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/renderers/UmlNoteContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/renderers/UmlNoteContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

