/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.visibility;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uml.core.actions.visibility.DeselectedVisibilityIcon;
import com.intellij.uml.core.actions.visibility.SelectedVisibilityIcon;
import com.intellij.uml.utils.DiagramBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ChangeVisibilityLevelAction
extends DiagramAction {
    @NotNull
    private static final SelectedVisibilityIcon SELECTED_ICON = new SelectedVisibilityIcon();
    @NotNull
    private static final DeselectedVisibilityIcon DESELECTED_ICON = new DeselectedVisibilityIcon();
    @NotNull
    private final VisibilityLevel myLevel;
    @NotNull
    private final DiagramBuilder myBuilder;

    public ChangeVisibilityLevelAction(@NotNull VisibilityLevel level, @NotNull DiagramBuilder builder) {
        if (level == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(1);
        }
        super(level.getDisplayName(), "", ChangeVisibilityLevelAction.getActionIcon(builder.getDataModel().getVisibilityManager(), level));
        this.myLevel = level;
        this.myBuilder = builder;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setIcon(ChangeVisibilityLevelAction.getActionIcon(this.myBuilder.getDataModel().getVisibilityManager(), this.myLevel));
    }

    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(3);
        }
        DiagramDataModel dataModel = this.myBuilder.getDataModel();
        DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
        visibilityManager.setCurrentVisibilityLevel(this.myLevel);
        dataModel.refreshDataModel();
        this.myBuilder.update(true, visibilityManager.isRelayoutNeeded());
    }

    private static Icon getActionIcon(@NotNull DiagramVisibilityManager mgr, @NotNull VisibilityLevel level) {
        if (mgr == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(4);
        }
        if (level == null) {
            ChangeVisibilityLevelAction.$$$reportNull$$$0(5);
        }
        return level == mgr.getCurrentVisibilityLevel() ? SELECTED_ICON : DESELECTED_ICON;
    }

    public String getActionName() {
        return DiagramBundle.message((String)"action.name.change.visibility.to.0", (Object[])new Object[]{this.myLevel.getDisplayName()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/core/actions/visibility/ChangeVisibilityLevelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

