/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.renderers.UmlNodesListRenderer;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class UmlLineToAction
extends DiagramAction {
    public UmlLineToAction(String name, String description) {
        super(name, description, UmlIcons.Dependencies);
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    public void perform(@NotNull AnActionEvent e) {
        PsiFile[] psiFileArray;
        PsiFile psiFile;
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(1);
        }
        DiagramNode selected = (DiagramNode)UmlLineToAction.getSelectedNodes((AnActionEvent)e).get(0);
        DiagramEdgeCreationPolicy policy = UmlLineToAction.getProvider((AnActionEvent)e).getEdgeCreationPolicy();
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        DiagramBuilder builder = UmlLineToAction.getBuilder((AnActionEvent)e);
        for (DiagramNode node : builder.getNodeObjects()) {
            if (selected.equals(node) || node instanceof DiagramNoteNode || !policy.acceptTarget(node) || !policy.acceptTargetWithSource(node, selected)) continue;
            nodes.add(node);
        }
        PsiFile psiFile2 = psiFile = selected.getIdentifyingElement() instanceof PsiElement ? ((PsiElement)selected.getIdentifyingElement()).getContainingFile() : null;
        if (psiFile != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiFile})) {
            Messages.showErrorDialog((Project)psiFile.getProject(), (String)DiagramBundle.message((String)"file.is.readonly", (Object[])new Object[]{psiFile.getName()}), (String)DiagramBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        DiagramDataModel model = UmlLineToAction.getDataModel((AnActionEvent)e);
        JBList list = new JBList(nodes);
        list.setCellRenderer(UmlNodesListRenderer.INSTANCE);
        Runnable callback = () -> {
            DiagramNode target = (DiagramNode)list.getSelectedValue();
            if (target != null) {
                model.createEdge(selected, target);
                builder.update(true, false);
                builder.update(false, true);
            }
        };
        if (psiFile == null) {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        } else {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = psiFile;
        }
        PsiFile[] files = psiFileArray;
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(DiagramBundle.message((String)"popup.title.select.target.node", (Object[])new Object[0])).setFilteringEnabled((Function)new Namer()).setAutoselectOnMouseMove(true).setItemChoosenCallback(DiagramAction.createCallback((DiagramBuilder)builder, (PopupCallback)new PopupCallback.Adapter(callback, this.getActionName(), files))).createPopup();
        Utils.showInGraphCenter((JBPopup)popup, (Graph2D)builder.getGraph());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(2);
        }
        DiagramEdgeCreationPolicy policy = UmlLineToAction.getProvider((AnActionEvent)e).getEdgeCreationPolicy();
        List selected = UmlLineToAction.getSelectedNodes((AnActionEvent)e);
        boolean enabled = selected.size() == 1 && !(selected.get(0) instanceof DiagramNoteNode) && UmlLineToAction.getBuilder((AnActionEvent)e).getNodeObjects().size() > 1 && policy.acceptSource((DiagramNode)selected.get(0));
        e.getPresentation().setEnabled(enabled);
    }

    public String getActionName() {
        return DiagramBundle.message((String)"action.name.create.line", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/UmlLineToAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Namer
    implements Function<Object, String> {
        private Namer() {
        }

        public String fun(Object o) {
            DiagramNode node = (DiagramNode)o;
            return node.getProvider().getElementManager().getElementTitle(node.getIdentifyingElement());
        }
    }
}

