/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.NotNull;

public class UmlCategorySwitcher
extends DiagramAction
implements Toggleable {
    @NotNull
    private final DiagramCategory myCategory;
    @NotNull
    private final DiagramBuilder myBuilder;

    public UmlCategorySwitcher(@NotNull DiagramCategory category, @NotNull DiagramBuilder builder) {
        if (category == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(1);
        }
        super(category.getName(), "", category.getIcon());
        this.myCategory = category;
        this.myBuilder = builder;
    }

    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(2);
        }
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        boolean enabled = !this.isSelected();
        DiagramNodeContentManager nodeContentManager = this.myBuilder.getDataModel().getNodeContentManager();
        nodeContentManager.setCategoryEnabled(this.myCategory, enabled);
        nodeContentManager.onCategoryEnabled(this.myCategory, enabled);
        if (this.myCategory.isRefreshDataModel()) {
            this.myBuilder.getDataModel().refreshDataModel();
        }
        this.myBuilder.update(true, this.myBuilder.isPopupMode() || this.myCategory.isRefreshLayout());
        if (this.myCategory.isFitContent()) {
            this.myBuilder.getGraph().fitGraph2DView();
        }
    }

    public String getActionName() {
        return this.isSelected() ? DiagramBundle.message((String)"action.name.disable.category", (Object[])new Object[]{this.myCategory.getName()}) : DiagramBundle.message((String)"action.name.enable.category", (Object[])new Object[]{this.myCategory.getName()});
    }

    private boolean isSelected() {
        return this.myBuilder.getDataModel().getNodeContentManager().isCategoryEnabled(this.myCategory);
    }

    public boolean isSelected(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            UmlCategorySwitcher.$$$reportNull$$$0(3);
        }
        return this.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/core/actions/UmlCategorySwitcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

