/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.utils.DiagramBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlAddNoteAction
extends DiagramActionWithPreparation<String> {
    public UmlAddNoteAction() {
        super(DiagramBundle.message((String)"add.note.action.title", (Object[])new Object[0]), "", UmlIcons.AddNote);
    }

    @Nullable
    @Nls
    public String prepare(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(0);
        }
        return Messages.showMultilineInputDialog((Project)e.getProject(), (String)DiagramBundle.message((String)"dialog.message.note.text", (Object[])new Object[0]), (String)DiagramBundle.message((String)"dialog.title.add.a.note", (Object[])new Object[0]), (String)"", (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
    }

    public void execute(@NotNull DiagramBuilder builder, @Nls String description, AnActionEvent e) {
        if (builder == null) {
            UmlAddNoteAction.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)description)) {
            return;
        }
        DiagramDataModel model = builder.getDataModel();
        DiagramNode selectedNode = builder.getNodeObject(GraphViewUtil.getSingleSelectedNode((Graph2D)builder.getGraph()));
        assert (selectedNode != null);
        DiagramNoteNode note = model.addNote(selectedNode, description);
        builder.updateGraph();
        if (note != null) {
            Node noteNode = builder.getNode((DiagramNode)note);
            NodeRealizer realizer = builder.getGraph().getRealizer(noteNode);
            NodeRealizer target = builder.getGraph().getRealizer(builder.getNode(note.getIdentifyingElement()));
            realizer.setCenterX(target.getCenterX());
            realizer.setY(target.getY() - realizer.getHeight() - 20.0);
        }
        builder.updateGraph();
        builder.notifyOtherBuilders();
    }

    public void update(@NotNull AnActionEvent e) {
        Graph2D graph;
        Node selectedNode;
        DiagramBuilder builder;
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(2);
        }
        if ((builder = UmlAddNoteAction.getBuilder((AnActionEvent)e)) != null && (selectedNode = GraphViewUtil.getSingleSelectedNode((Graph2D)(graph = builder.getGraph()))) != null) {
            DiagramNode node = builder.getNodeObject(selectedNode);
            DiagramDataModel model = builder.getDataModel();
            if (!(node instanceof DiagramNoteNode) && !model.getNotes().containsKey(node)) {
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    public String getActionName() {
        return DiagramBundle.message((String)"action.name.add.note", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/core/actions/UmlAddNoteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

