/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.core.actions.ShowDiagram;
import com.intellij.uml.statistics.DiagramUsagesCollector;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class ShowDiagramBase
extends DumbAwareAction {
    private boolean myIsCalledFromList = false;

    protected ShowDiagramBase() {
        this.setInjectedContext(true);
    }

    @NotNull
    @NonNls
    public String getFeatureId() {
        return "diagram.show";
    }

    public boolean isCalledFromJList() {
        return this.myIsCalledFromList;
    }

    protected abstract boolean isPopup();

    protected boolean isUnderProgress() {
        return true;
    }

    @Nullable
    protected Object findInDataContext(@NotNull DiagramProvider<?> provider, @NotNull DataContext context) {
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(1);
        }
        return provider.getElementManager().findInDataContext(context);
    }

    @NotNull
    protected RelativePoint getLocation(@NotNull DataContext context, @NotNull AnActionEvent e) {
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(3);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        if (relativePoint == null) {
            ShowDiagramBase.$$$reportNull$$$0(4);
        }
        return relativePoint;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(5);
        }
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LightEdit.owns((Project)e.getProject())) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        DiagramProvider provider = this.findAppropriateProvidersForThisAction(e).findFirst().orElse(null);
        boolean isEnabled = provider != null;
        boolean isPopup = this.isPopup();
        presentation.setEnabledAndVisible(isEnabled);
        if (isEnabled) {
            presentation.setIcon(provider.getActionIcon(isPopup));
            presentation.setText(DiagramBundle.message((String)"action.text.show.0.1", (Object[])new Object[]{provider.getActionName(isPopup), isPopup ? " Popup" : ""}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(6);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List providers = this.findAppropriateProvidersForThisAction(e).collect(Collectors.toList());
        if (providers.isEmpty()) {
            return;
        }
        Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        AbstractPopup.MyContentPanel panel = component != null ? (AbstractPopup.MyContentPanel)ComponentUtil.getParentOfType(AbstractPopup.MyContentPanel.class, (Component)component) : null;
        DataContext context = e.getDataContext();
        RelativePoint point = this.getLocation(context, e);
        this.myIsCalledFromList = panel != null;
        List providersWithInitialElements = ContainerUtil.map(providers, provider -> Trinity.create((Object)provider, (Object)this.findInDataContext((DiagramProvider<?>)provider, context), new ArrayList(provider.getElementManager().findElementsInDataContext(context))));
        Consumer showCallback = chosen -> {
            this.logStatistics(project, (DiagramProvider<Object>)((DiagramProvider)chosen.first), chosen.second, (Collection)chosen.third);
            this.showUnderProgress(project, (DiagramProvider<Object>)((DiagramProvider)chosen.first), chosen.second, (Collection)chosen.third, point);
        };
        if (providers.size() > 1) {
            this.askUserToChooseDiagramType(providersWithInitialElements, context, (Consumer<? super Trinity<DiagramProvider<Object>, Object, Collection<Object>>>)showCallback);
        } else {
            showCallback.consume((Object)((Trinity)providersWithInitialElements.get(0)));
        }
    }

    protected void askUserToChooseDiagramType(@NotNull List<? extends Trinity<DiagramProvider<Object>, Object, Collection<Object>>> providersWithData, @NotNull DataContext context, @NotNull Consumer<? super Trinity<DiagramProvider<Object>, Object, Collection<Object>>> diagramChosenCallback) {
        if (providersWithData == null) {
            ShowDiagramBase.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(8);
        }
        if (diagramChosenCallback == null) {
            ShowDiagramBase.$$$reportNull$$$0(9);
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(providersWithData).setTitle(DiagramBundle.message((String)"select.uml.provider", (Object[])new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setText(((DiagramProvider)value.first).getRefinedPresentableName(value.second, (Collection)value.third));
            label.setIcon(((DiagramProvider)value.first).getActionIcon(this.isPopup()));
        })).setResizable(false).setMovable(false).setItemChosenCallback(diagramChosenCallback).createPopup().showInBestPositionFor(context);
    }

    protected void logStatistics(@NotNull Project project, @NotNull DiagramProvider<Object> chosenProvider, @Nullable Object element, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(10);
        }
        if (chosenProvider == null) {
            ShowDiagramBase.$$$reportNull$$$0(11);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(12);
        }
        DiagramUsagesCollector.logShowDiagram(project, chosenProvider, element, additionalElements);
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureId());
    }

    protected void showUnderProgress(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull RelativePoint point) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(14);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(15);
        }
        if (point == null) {
            ShowDiagramBase.$$$reportNull$$$0(16);
        }
        Object obj = element != null ? element : ContainerUtil.getFirstItem(additionalElements);
        additionalElements.remove(obj);
        if (this.isUnderProgress() && !this.isCalledFromJList() && !this.isPopup()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                ShowDiagramBase.run(this.show(project, provider, obj, additionalElements, point));
            }, DiagramBundle.message((String)"building.diagram", (Object[])new Object[]{provider.getRefinedPresentableName(element, additionalElements)}), true, project);
        } else {
            ShowDiagramBase.run(this.show(project, provider, obj, additionalElements, point));
        }
    }

    @Nullable
    protected Runnable show(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull RelativePoint popupLocation) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(18);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(19);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(20);
        }
        return () -> {
            Trinity initializedHolders = (Trinity)WriteAction.computeAndWait(() -> {
                UmlVirtualFileSystem.UmlVirtualFile file = this.initializeDiagramVirtualFile(project, provider, element, additionalElements);
                if (file == null) {
                    return null;
                }
                DiagramBuilder builder = this.initializeDiagramBuilder(project, provider, element, file);
                if (builder == null) {
                    return null;
                }
                DiagramDataModel dataModel = builder.getDataModel();
                this.fillDataModel((DiagramDataModel<Object>)dataModel, additionalElements);
                dataModel.setupScopeManager(element, false);
                return Trinity.create((Object)((Object)file), (Object)builder, (Object)dataModel);
            });
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)((Object)((Object)initializedHolders.first));
            DiagramBuilder builder = (DiagramBuilder)initializedHolders.second;
            DiagramDataModel dataModel = (DiagramDataModel)initializedHolders.third;
            Runnable dataModelInitializedCallback = () -> {
                Runnable showCallback = this.showReadyDiagramCallback(element, additionalElements, builder, file, popupLocation);
                if (showCallback != null) {
                    showCallback.run();
                    ShowDiagramBase.invokeLater(this.afterDiagramIsShownCallback(element, additionalElements, builder, file, popupLocation));
                }
            };
            if (dataModel instanceof DiagramDataModel.AsyncDataLoader) {
                this.initializeDataModelAsync(dataModel).onSuccess(__ -> ApplicationManager.getApplication().invokeLater(dataModelInitializedCallback));
            } else {
                WriteAction.runAndWait(() -> this.initializeDataModel(dataModel));
                ApplicationManager.getApplication().invokeLater(dataModelInitializedCallback);
            }
        };
    }

    @RequiresReadLock
    @Nullable
    protected UmlVirtualFileSystem.UmlVirtualFile initializeDiagramVirtualFile(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(21);
        }
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(22);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(23);
        }
        String url = "uml://" + provider.getID() + "/" + provider.getVfsResolver().getQualifiedName(element);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (!(virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile)) {
            return null;
        }
        UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
        String text = provider.getElementManager().getEditorTitle(element, additionalElements);
        if (text != null) {
            file.setPresentableName(text);
        }
        if (file.getProject() == null) {
            file.setProject(project);
        }
        file.putUserData(DiagramProvider.ORIGINAL_ELEMENT, element);
        return file;
    }

    @RequiresWriteLock
    @Nullable
    protected DiagramBuilder initializeDiagramBuilder(@NotNull Project project, @NotNull DiagramProvider<?> provider, @Nullable Object element, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(24);
        }
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(25);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(26);
        }
        UmlGraphBuilder builder = UmlGraphBuilderFactory.create(project, provider, element, file);
        builder.setPopupMode(this.isPopup());
        builder.getPresentationModel().registerActions();
        return builder;
    }

    @RequiresWriteLock
    protected void fillDataModel(@NotNull DiagramDataModel<Object> dataModel, @NotNull Collection<Object> additionalElements) {
        if (dataModel == null) {
            ShowDiagramBase.$$$reportNull$$$0(27);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(28);
        }
        for (Object additionalElement : additionalElements) {
            dataModel.addElement(additionalElement);
        }
    }

    @RequiresWriteLock
    protected void initializeDataModel(@NotNull DiagramDataModel<?> dataModel) {
        if (dataModel == null) {
            ShowDiagramBase.$$$reportNull$$$0(29);
        }
        dataModel.refreshDataModel();
        dataModel.setModelInitializationFinished();
    }

    protected Promise<?> initializeDataModelAsync(@NotNull DiagramDataModel<?> dataModel) {
        if (dataModel == null) {
            ShowDiagramBase.$$$reportNull$$$0(30);
        }
        Project project = dataModel.getProject();
        return ((DiagramDataModel.AsyncDataLoader)dataModel).refreshDataModelAsync().onSuccess(o -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (!project.isDisposed()) {
                dataModel.setModelInitializationFinished();
            }
        })).onError(t -> {
            if (!(t instanceof ProcessCanceledException) && !(t instanceof CancellationException)) {
                Logger.getInstance(ShowDiagram.class).error("Unable to refresh diagram model async", t);
            }
        });
    }

    @Nullable
    protected Runnable showReadyDiagramCallback(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(31);
        }
        if (builder == null) {
            ShowDiagramBase.$$$reportNull$$$0(32);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(33);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(34);
        }
        return null;
    }

    @Nullable
    protected Runnable afterDiagramIsShownCallback(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(35);
        }
        if (builder == null) {
            ShowDiagramBase.$$$reportNull$$$0(36);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(37);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(38);
        }
        return () -> {
            DiagramFileEditor editor = builder.getEditor();
            if (editor != null && editor.isOpenedForTheFirstTime()) {
                builder.update(false, true);
                builder.getGraphBuilder().fitContent();
            }
            Graph2DView view = builder.getView();
            view.adjustScrollBarVisibility();
            view.adjustScrollBarVisibility();
        };
    }

    protected static void run(@Nullable Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    protected static void invokeLater(@Nullable Runnable runnable) {
        if (runnable != null) {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    @Nullable
    public DiagramProvider<?> getForcedProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(39);
        }
        return null;
    }

    @NotNull
    private Stream<? extends DiagramProvider<?>> findAppropriateProvidersForThisAction(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(40);
        }
        return ShowDiagramBase.findProviders(e, this.getForcedProvider(e));
    }

    @NotNull
    public static Stream<? extends DiagramProvider<?>> findProviders(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(41);
        }
        return ShowDiagramBase.findProviders(e, null);
    }

    @NotNull
    public static Stream<? extends DiagramProvider<?>> findProviders(@NotNull AnActionEvent e, @Nullable DiagramProvider<?> forcedProvider) {
        Project project;
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(42);
        }
        if ((project = e.getProject()) == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                ShowDiagramBase.$$$reportNull$$$0(43);
            }
            return stream;
        }
        boolean isDumb = DumbService.isDumb((Project)project);
        Stream<Object> providers = forcedProvider != null ? Stream.of(forcedProvider) : DiagramProvider.DIAGRAM_PROVIDER.getExtensionList().stream();
        Stream<DiagramProvider> stream = providers.filter(provider -> {
            if (isDumb && !DumbService.isDumbAware((Object)provider)) {
                return false;
            }
            DiagramElementManager manager = provider.getElementManager();
            return Optional.ofNullable(manager.findInDataContext(e.getDataContext())).or(() -> manager.findElementsInDataContext(e.getDataContext()).stream().findFirst()).map(arg_0 -> ((DiagramElementManager)manager).canBeBuiltFrom(arg_0)).orElse(false);
        });
        if (stream == null) {
            ShowDiagramBase.$$$reportNull$$$0(44);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providersWithData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagramChosenCallback";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenProvider";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 20: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 26: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 43: 
            case 44: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "askUserToChooseDiagramType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logStatistics";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUnderProgress";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initializeDiagramVirtualFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "initializeDiagramBuilder";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fillDataModel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "initializeDataModel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "initializeDataModelAsync";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showReadyDiagramCallback";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "afterDiagramIsShownCallback";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getForcedProvider";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateProvidersForThisAction";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

