/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilderFactory<T> {
    @NotNull
    public static UmlGraphBuilder create(@NotNull Project project, @NotNull DiagramProvider provider, @Nullable Object element, @Nullable VirtualFile file) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(1);
        }
        UmlGraphBuilder umlGraphBuilder = (UmlGraphBuilder)new UmlGraphBuilderFactory<Object>().createBuilder(project, provider, element, file);
        if (umlGraphBuilder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(2);
        }
        return umlGraphBuilder;
    }

    @NotNull
    public DiagramBuilder createBuilder(@NotNull Project project, @NotNull DiagramProvider<T> provider, @Nullable T element, @Nullable VirtualFile file) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(4);
        }
        DiagramBuilder diagramBuilder = this.createBuilderWithGivenDataModel(project, provider, null, element, file);
        if (diagramBuilder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(5);
        }
        return diagramBuilder;
    }

    @NotNull
    public DiagramBuilder createBuilderWithGivenDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider, @Nullable DiagramDataModel<T> dataModel, @Nullable T element, @Nullable VirtualFile file) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(7);
        }
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        DiagramPresentationModel presentationModel = this.createPresentationModel(project, provider, graph);
        if (dataModel == null) {
            dataModel = this.createDataModel(project, provider, element, file, presentationModel);
        }
        dataModel.setOriginalElement(element);
        UmlGraphBuilder builder = this.createBuilder(project, provider, graph, view, presentationModel, dataModel);
        this.registerUserData(project, provider, element, file, graph, view, dataModel, builder);
        this.registerListeners(graph, builder);
        UmlGraphBuilder umlGraphBuilder = builder;
        if (umlGraphBuilder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(8);
        }
        return umlGraphBuilder;
    }

    @NotNull
    protected DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull DiagramProvider<T> provider, @NotNull Graph2D graph) {
        DiagramPresentationModel presentationModel;
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(10);
        }
        if (graph == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(11);
        }
        return (presentationModel = provider.createPresentationModel(project, graph)) != null ? presentationModel : new DiagramPresentationModelImpl(graph, project, provider);
    }

    @NotNull
    protected DiagramDataModel<T> createDataModel(@NotNull Project project, @NotNull DiagramProvider<T> provider, @Nullable T element, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(12);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(13);
        }
        if (presentationModel == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(14);
        }
        DiagramDataModel diagramDataModel = provider.createDataModel(project, element, file, presentationModel);
        if (diagramDataModel == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(15);
        }
        return diagramDataModel;
    }

    @NotNull
    protected UmlGraphBuilder createBuilder(@NotNull Project project, @NotNull DiagramProvider<T> provider, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull DiagramPresentationModel presentationModel, @NotNull DiagramDataModel<T> dataModel) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(16);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(17);
        }
        if (graph == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(18);
        }
        if (view == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(19);
        }
        if (presentationModel == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(20);
        }
        if (dataModel == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(21);
        }
        return new UmlGraphBuilder(project, graph, view, dataModel, presentationModel);
    }

    protected void registerUserData(@NotNull Project project, @NotNull DiagramProvider<T> provider, @Nullable T element, @Nullable VirtualFile file, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull DiagramDataModel<T> dataModel, @NotNull DiagramBuilder builder) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(23);
        }
        if (graph == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(24);
        }
        if (view == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(25);
        }
        if (dataModel == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(26);
        }
        if (builder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(27);
        }
        view.getJComponent().putClientProperty("Diagram-View-Component-Key", Boolean.TRUE);
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"ORIGINAL_ELEMENT", DataProviderFactory.create(element));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)builder));
        builder.putUserData(Utils.UML_PROVIDER, provider);
        dataModel.putUserData(Utils.GRAPH_BUILDER, (Object)builder);
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).addBuilder(builder);
            builder.putUserData(UmlGraphBuilder.EDITOR_FILE, (Object)file);
        }
    }

    protected void registerListeners(@NotNull Graph2D graph, final @NotNull DiagramBuilder builder) {
        if (graph == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(28);
        }
        if (builder == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(29);
        }
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.isNodeSelection()) {
                    builder.getPresentationModel().onSelectionChanged(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/UmlGraphBuilderFactory$1", "onGraph2DSelectionEvent"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlGraphBuilderFactory";
                break;
            }
            case 11: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlGraphBuilderFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderWithGivenDataModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderWithGivenDataModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerUserData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

