/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataModelWrapper;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeMap;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.undo.UmlRefactoringElementListenerProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Point;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilder
extends GraphBuilderImpl<DiagramNode<?>, DiagramEdge<?>>
implements GraphBuilderListener,
DiagramBuilder,
DocumentListener {
    @NotNull
    public static final Key<DiagramFileEditor> UML_FILE_EDITOR = Key.create((String)"UML_FILE_EDITOR");
    @NotNull
    public static final Key<VirtualFile> EDITOR_FILE = Key.create((String)"diagram.editor.file");
    @NotNull
    private final Map<GraphBuilderEvent, DiagramState> states;
    private volatile boolean myPopupMode;

    protected UmlGraphBuilder(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull DiagramDataModel<?> dataModel, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            UmlGraphBuilder.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            UmlGraphBuilder.$$$reportNull$$$0(1);
        }
        if (view == null) {
            UmlGraphBuilder.$$$reportNull$$$0(2);
        }
        if (dataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(3);
        }
        if (presentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(4);
        }
        super(project, graph, view, (GraphDataModel)new DiagramDataModelWrapper(dataModel), (GraphPresentationModel)presentationModel);
        this.states = ConcurrentCollectionFactory.createConcurrentMap();
        presentationModel.setGraphBuilder((GraphBuilder)this);
        this.addGraphBuilderListener(this, (Disposable)this);
        if (dataModel.isPsiListener()) {
            UmlRefactoringElementListenerProvider.getInstance(project).addBuilder(this);
            DocumentListener documentListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    VirtualFile editorFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editorFile = UmlGraphBuilder.this.getEditorFile()) != null) {
                        Document document = e.getDocument();
                        Project documentProject = ProjectUtil.guessProjectForFile((VirtualFile)FileDocumentManager.getInstance().getFile(document));
                        Project myProject = UmlGraphBuilder.this.getProject();
                        if (myProject.equals(documentProject)) {
                            PsiFile psiFile = PsiDocumentManager.getInstance((Project)myProject).getPsiFile(document);
                            if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress() && CommandProcessor.getInstance().getCurrentCommand() != null && psiFile != null && psiFile.isValid() && UmlGraphBuilder.this.getDataModel().hasFile(psiFile) && UmlGraphBuilder.this.isDiagramEditorActive()) {
                                CommandProcessor.getInstance().addAffectedFiles(myProject, new VirtualFile[]{editorFile});
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/UmlGraphBuilder$1", "documentChanged"));
                }
            };
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this);
        }
    }

    private boolean isDiagramEditorActive() {
        return ArrayUtil.contains((Object)this.getEditor(), (Object[])FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditors());
    }

    @NotNull
    public DiagramPresentationModel getGraphPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = (DiagramPresentationModel)super.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(5);
        }
        return diagramPresentationModel;
    }

    @NotNull
    public DiagramPresentationModel getPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = this.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(6);
        }
        return diagramPresentationModel;
    }

    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder() {
        UmlGraphBuilder umlGraphBuilder = this;
        if (umlGraphBuilder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(7);
        }
        return umlGraphBuilder;
    }

    @NotNull
    public EditorColorsScheme getColorScheme() {
        if (GraphViewUtil.isPrintMode()) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Default");
            if (editorColorsScheme == null) {
                UmlGraphBuilder.$$$reportNull$$$0(8);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            UmlGraphBuilder.$$$reportNull$$$0(9);
        }
        return editorColorsScheme;
    }

    public boolean doAllowEdgeCreation() {
        return this.getEditMode().doAllowEdgeCreation();
    }

    public void setAllowEdgeCreation(boolean allow) {
        this.getEditMode().allowEdgeCreation(allow);
    }

    @Deprecated
    @NotNull
    public DiagramState getPresentation() {
        DiagramState diagramState = this.getGraphPresentationModel().getPresentation();
        if (diagramState == null) {
            UmlGraphBuilder.$$$reportNull$$$0(10);
        }
        return diagramState;
    }

    @NotNull
    public DiagramDataModel<?> getDataModel() {
        DiagramDataModel diagramDataModel = ((DiagramDataModelWrapper)this.getGraphDataModel()).getModel();
        if (diagramDataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(11);
        }
        return diagramDataModel;
    }

    @NotNull
    public DiagramProvider<?> getProvider() {
        DiagramProvider provider = (DiagramProvider)this.getUserData(Utils.UML_PROVIDER);
        assert (provider != null) : "Forget to add uml provider to the user data";
        DiagramProvider diagramProvider = provider;
        if (diagramProvider == null) {
            UmlGraphBuilder.$$$reportNull$$$0(12);
        }
        return diagramProvider;
    }

    public void setSelected(@NotNull DiagramNode<?> node, boolean selected) {
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(13);
        }
        Node n = this.getNode(node);
        assert (n != null) : "Node " + node.getTooltip() + " is not in the model. Or model was not updated. Call DiagramBuilder.update()";
        this.getGraph().setSelected(n, selected);
    }

    public void setSelected(@NotNull DiagramEdge<?> edge, boolean selected) {
        if (edge == null) {
            UmlGraphBuilder.$$$reportNull$$$0(14);
        }
        Edge e = this.getEdge(edge);
        assert (e != null) : "Edge " + edge + " is not in the model. Or model was not updated. Call DiagramBuilder.update()";
        this.getGraph().setSelected(e, selected);
    }

    @Nullable
    public DiagramFileEditor getEditor() {
        return (DiagramFileEditor)this.getUserData(UML_FILE_EDITOR);
    }

    public void setEditor(@NotNull DiagramFileEditor editor) {
        if (editor == null) {
            UmlGraphBuilder.$$$reportNull$$$0(15);
        }
        this.putUserData(UML_FILE_EDITOR, editor);
        editor.putUserData(Utils.GRAPH_BUILDER, (Object)this);
    }

    @Nullable
    public DocumentReference getDocumentReference() {
        VirtualFile file;
        DiagramFileEditor editor = this.getEditor();
        if (editor != null && (file = editor.getOriginalVirtualFile()).isValid()) {
            return DocumentReferenceManager.getInstance().create(file);
        }
        return null;
    }

    public void beforeActionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(16);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(17);
        }
        if (this == builder && !this.states.containsKey(event)) {
            this.states.put(event, DiagramState.makeBuilderSnapshot((DiagramBuilder)this));
        }
    }

    public void actionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(18);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(19);
        }
        if (event != GraphBuilderEvent.ZOOM_CHANGED && this == builder && this.states.containsKey(event)) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(event.getTitle()).withGroupId(UmlGraphBuilder.getGroupId(event)).run(() -> {
                DiagramActionsManager.getInstance((Project)this.getProject()).notifyUmlListeners((DiagramBuilder)((UmlGraphBuilder)builder), this.states.remove(event), new PsiFile[0]);
                this.notifyOtherBuilders();
            });
        }
    }

    public void notifyOtherBuilders() {
        VirtualFile file = this.getEditorFile();
        if (file != null) {
            FileEditor[] editors = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file);
            if (editors.length < 2) {
                return;
            }
            DiagramState state = DiagramState.makeBuilderSnapshot((DiagramBuilder)this);
            ApplicationManager.getApplication().invokeLater(() -> {
                for (FileEditor editor : editors) {
                    if (!(editor instanceof UmlFileEditorImpl) || ((UmlFileEditorImpl)editor).getBuilder() == this) continue;
                    UmlFileEditorImpl umlFileEditor = (UmlFileEditorImpl)editor;
                    umlFileEditor.setUmlState(state);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        umlFileEditor.getBuilder().update(false, false);
                        umlFileEditor.getBuilder().getGraphBuilder().updateView();
                    });
                }
            });
        }
    }

    @Nullable
    private static String getGroupId(@NotNull GraphBuilderEvent event) {
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(20);
        }
        if (event == GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD) {
            return event.toString();
        }
        return null;
    }

    public void update() {
        this.update(true, false);
    }

    @RequiresEdt
    public void update(boolean increaseModTrackerCounter, boolean updateLayout) {
        if (increaseModTrackerCounter) {
            this.getGraphPresentationModel().update();
            for (DiagramEdge umlEdge : this.getEdgeObjects()) {
                Edge edge = this.getEdge(umlEdge);
                Utils.assertForgetToRemoveEdge((Edge)edge, (DiagramEdge)umlEdge, (DiagramBuilder)this);
                if (!updateLayout) continue;
                this.getGraph().getRealizer(edge).clearBends();
            }
        }
        this.updateGraph(false);
        if (updateLayout) {
            JBPopup popup;
            this.relayout();
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphUtil.setBestPopupSizeForGraph((JBPopup)popup, (GraphBuilder)this);
            }
            this.getGraph().updateViews();
        }
    }

    public boolean isPopupMode() {
        return this.myPopupMode;
    }

    @Nullable
    public JBPopup getPopup() {
        return (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    public void setPopup(@NotNull JBPopup popup) {
        if (popup == null) {
            UmlGraphBuilder.$$$reportNull$$$0(21);
        }
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.setPopupMode(true);
    }

    public void setPopupMode(boolean popupMode) {
        this.myPopupMode = popupMode;
    }

    @RequiresEdt
    public void relayout() {
        NodeMap nodeMap = this.getGraphUpdateModel().getNodeUpdatesDataMap();
        EdgeMap edgeMap = this.getGraphUpdateModel().getEdgeUpdatesDataMap();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            edgeMap.set((Object)edge, null);
        }
        for (Edge edge : this.getGraph().getNodeArray()) {
            nodeMap.set((Object)edge, null);
        }
        GraphUtil.doLayout((GraphBuilder)this);
        if (this.getGraphPresentationModel().getSettings().isFitContentAfterLayout()) {
            this.fitContent();
        }
    }

    @RequiresEdt
    public void createDraggedNode(@NotNull DiagramNode node, @Nullable String nodeName, @NotNull Point point) {
        NodeLayout nodeLayout;
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(22);
        }
        if (point == null) {
            UmlGraphBuilder.$$$reportNull$$$0(23);
        }
        Node nodeObj = NodeFactory.getInstance().createDraggedNode((GraphBuilder)this, (Object)node, node.getTooltip(), point);
        this.getDataModel().refreshDataModel();
        if (nodeObj != null && (nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj)) != null) {
            nodeLayout.setLocation((double)point.x, (double)point.y);
        }
    }

    @Nullable
    public VirtualFile getEditorFile() {
        return (VirtualFile)this.getUserData(EDITOR_FILE);
    }

    public void dispose() {
        DocumentReference ref = this.getDocumentReference();
        if (ref != null) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).invalidateActionsFor(ref);
        }
        super.dispose();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    public String toString() {
        return "UmlGraphBuilder@" + ((Object)((Object)this)).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGroupId";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setPopup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

