/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.diagram.DiagramActionsListener;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.uml.EmptyDiagramProvider;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.components.UmlGraphComponent;
import com.intellij.uml.core.actions.UmlActions;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlFileEditorImpl
extends UserDataHolderBase
implements DiagramFileEditor,
PossiblyDumbAware {
    @NotNull
    private static final Logger LOG = Logger.getInstance(UmlFileEditorImpl.class);
    @NotNull
    @NonNls
    static final String NAME = "UML";
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final UmlGraphComponent myPanel;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final NotNullLazyValue<StructureViewBuilder> myStructureViewBuilder;
    @Nullable
    private volatile DocumentReference myDocumentReference;
    private final boolean myIsOpenedForTheFirstTime;
    @NotNull
    private final AtomicBoolean myIsDisposed;

    public UmlFileEditorImpl(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(1);
        }
        this.myIsDisposed = new AtomicBoolean();
        this.myBuilder = builder;
        this.myFile = file;
        this.myStructureViewBuilder = NotNullLazyValue.atomicLazy(() -> GraphViewUtil.createStructureViewBuilder((Overview)this.myBuilder.getOverview()));
        this.myPanel = new UmlGraphComponent(this.myBuilder, this.createToolbar());
        this.myIsOpenedForTheFirstTime = UmlFileEditorImpl.isOpenedForTheFirstTime(builder, file);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        Disposer.register((Disposable)this, (Disposable)this.myPanel);
        this.myBuilder.setEditor((DiagramFileEditor)this);
        this.myBuilder.getPresentationModel().registerActions();
        GraphViewUtil.addDataProvider((Graph2DView)this.myBuilder.getView(), (DataProvider)this);
        this.createAndRegisterListeners();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myDocumentReference = DocumentReferenceManager.getInstance().create(this.myFile);
        });
    }

    private static boolean isOpenedForTheFirstTime(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(3);
        }
        FileEditorProvider umlEditorProvider = FileEditorProviderManager.getInstance().getProvider("UmlEditorProvider");
        assert (umlEditorProvider != null);
        EditorHistoryManager historyManager = EditorHistoryManager.getInstance((Project)builder.getProject());
        FileEditorState historyState = historyManager.getState(file, umlEditorProvider);
        return historyState == null || historyState == FileEditorState.INSTANCE;
    }

    @NotNull
    private ActionToolbar createToolbar() {
        ActionToolbar toolbar = UmlGraphComponent.createToolbarPanel(UmlActions.createToolbarActions(this.myBuilder));
        toolbar.setTargetComponent(this.myBuilder.getView().getJComponent());
        DataManager.registerDataProvider((JComponent)toolbar.getComponent(), (DataProvider)this);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(4);
        }
        return actionToolbar;
    }

    private void createAndRegisterListeners() {
        final Project project = this.myBuilder.getProject();
        MyFileEditorManagerListener fileEditorListener = new MyFileEditorManagerListener(this.myBuilder, this.myFile);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        if (this.isEditable()) {
            MyExternalChangeListener externalChangeListener = new MyExternalChangeListener();
            this.myFile.getFileSystem().addVirtualFileListener((VirtualFileListener)externalChangeListener, (Disposable)this);
            MyDiagramListener diagramListener = new MyDiagramListener(project, externalChangeListener);
            project.getMessageBus().connect((Disposable)this).subscribe(DiagramActionsListener.TOPIC, (Object)diagramListener);
        }
        MyGraphSelectionListener graphSelectionListener = new MyGraphSelectionListener();
        this.myBuilder.getGraph().addGraph2DSelectionListener((Graph2DSelectionListener)graphSelectionListener);
        Disposer.register((Disposable)this, (Disposable)graphSelectionListener);
        DiagramProvider.DIAGRAM_PROVIDER.addExtensionPointListener(new ExtensionPointListener<DiagramProvider<?>>(){

            public void extensionRemoved(@NotNull DiagramProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (extension.getClass() == UmlFileEditorImpl.this.myBuilder.getProvider().getClass()) {
                    FileEditorManager.getInstance((Project)project).closeFile(UmlFileEditorImpl.this.myFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/uml/UmlFileEditorImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Deprecated
    @NotNull
    public static FileEditorManagerListener createFileEditorListener(@NotNull Project project, @NotNull VirtualFile file, @NotNull DiagramBuilder builder) {
        if (project == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(5);
        }
        if (file == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(7);
        }
        return new MyFileEditorManagerListener(builder, file);
    }

    public boolean isUnknownProvider() {
        return this.myBuilder.getProvider() instanceof EmptyDiagramProvider;
    }

    public boolean isEditable() {
        return !(this.myFile instanceof UmlVirtualFileSystem.UmlVirtualFile) && !this.isUnknownProvider() && "uml".equalsIgnoreCase(this.myFile.getExtension());
    }

    public boolean isOpenedForTheFirstTime() {
        return this.myIsOpenedForTheFirstTime;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel.getComponent();
        if (jComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBuilder.getView().getCanvasComponent();
    }

    @NotNull
    @NonNls
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(9);
        }
        switch (level) {
            case UNDO: {
                FileEditorState fileEditorState = FileEditorState.INSTANCE;
                if (fileEditorState == null) {
                    UmlFileEditorImpl.$$$reportNull$$$0(10);
                }
                return fileEditorState;
            }
            case FULL: 
            case NAVIGATION: {
                DiagramState diagramState = DiagramState.makeBuilderSnapshot((DiagramBuilder)this.myBuilder);
                if (diagramState == null) {
                    UmlFileEditorImpl.$$$reportNull$$$0(11);
                }
                return diagramState;
            }
        }
        throw new AssertionError((Object)"Must be unreachable");
    }

    public void setState(@NotNull FileEditorState editorState) {
        if (editorState == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(12);
        }
        if (editorState instanceof DiagramState) {
            DumbService.getInstance((Project)this.myBuilder.getProject()).runWhenSmart(() -> this.setUmlState((DiagramState)editorState));
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public void setUmlState(@Nullable DiagramState state) {
        if (state == null) {
            return;
        }
        state.restoreTo(this.myBuilder);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myIsDisposed.get();
    }

    public void selectNotify() {
        this.findAndSelectOriginNode();
    }

    private void findAndSelectOriginNode() {
        DiagramDataModel dataModel = this.myBuilder.getDataModel();
        Object originalElement = dataModel.getOriginalElement();
        if (this.myBuilder.getGraph().isSelectionEmpty() && originalElement != null) {
            dataModel.getNodes().stream().filter(it -> originalElement.equals(it.getIdentifyingElement())).findFirst().ifPresent(it -> this.myBuilder.setSelected(it, true));
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(13);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(14);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @NotNull
    public StructureViewBuilder getStructureViewBuilder() {
        StructureViewBuilder structureViewBuilder = (StructureViewBuilder)this.myStructureViewBuilder.getValue();
        if (structureViewBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(15);
        }
        return structureViewBuilder;
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            ReopenInfo.copyIfNeeded(this.myFile, this.myBuilder);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(16);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        if (FileChooserKeys.DELETE_ACTION_AVAILABLE.is(dataId)) {
            return false;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myBuilder.getProject();
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            NodeCursor selectedCursor = this.myBuilder.getGraph().selectedNodes();
            if (!this.myBuilder.getGraph().isSelectionEmpty() && selectedCursor.ok()) {
                Point point = UmlUtils.getNodeCoordinatesOnScreen(selectedCursor.node(), this.myBuilder.getView());
                SwingUtilities.convertPointFromScreen(point, this.myBuilder.getView().getCanvasComponent());
                return UmlUtils.getPointBeneathHeader(point, this.myBuilder);
            }
        }
        return UmlFileEditorImpl.getData(dataId, this.myBuilder);
    }

    @Nullable
    public static Object getData(@NotNull @NonNls String dataId, @NotNull DiagramBuilder builder) {
        if (dataId == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(17);
        }
        if (builder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(18);
        }
        DiagramProvider provider = builder.getProvider();
        Graph2D graph = builder.getGraph();
        DiagramExtras extras = provider.getExtras();
        List selectedNodes = ContainerUtil.mapNotNull((Collection)GraphViewUtil.getSelectedNodes((Graph2D)graph), it -> builder.getNodeObject(it));
        DiagramNode selectedNode = selectedNodes.size() == 1 ? (DiagramNode)selectedNodes.get(0) : null;
        Object selectedElement = selectedNode == null ? null : selectedNode.getIdentifyingElement();
        DiagramNodeEditorManager manager = DiagramNodeEditorManager.getInstance();
        NodeCellEditor editor = manager.getCurrentCellEditor();
        Object dataFromExtras = extras.getData(dataId, selectedNodes, builder);
        if (dataFromExtras != null) {
            return dataFromExtras;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return builder.getProject();
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (editor != null) {
                return manager.getData(dataId);
            }
            return selectedElement instanceof PsiElement && ((PsiElement)selectedElement).isValid() ? selectedElement : null;
        }
        if (SelectInContext.DATA_KEY.is(dataId)) {
            if (selectedElement instanceof PsiElement) {
                PsiDirectory[] directories;
                PsiFile psiFile = ((PsiElement)selectedElement).getContainingFile();
                if (psiFile != null) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null) {
                        return new FileSelectInContext(builder.getProject(), virtualFile, null);
                    }
                } else if (selectedElement instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)selectedElement).getDirectories()).length > 0) {
                    return new FileSelectInContext(builder.getProject(), directories[0].getVirtualFile(), null);
                }
            }
        } else {
            if (DiagramDataKeys.BUILDER.is(dataId)) {
                return builder;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                if (editor != null) {
                    return manager.getData(dataId);
                }
                Object element = UmlFileEditorImpl.getData(CommonDataKeys.PSI_ELEMENT.getName(), builder);
                if (element instanceof PsiElement) {
                    return ((PsiElement)element).getContainingFile();
                }
            } else {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    if (editor != null) {
                        return manager.getData(dataId);
                    }
                    return null;
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return "reference.uml.class.diagram";
                }
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    Graph2DView view = builder.getView();
                    Component c = view.getComponent();
                    Component root = SwingUtilities.getRoot(c);
                    if (!root.isShowing()) {
                        return null;
                    }
                    Point p = root.getLocationOnScreen();
                    if (selectedNodes.size() == 1) {
                        Point np = UmlUtils.getNodeCoordinatesOnScreen(builder.getNode((DiagramNode)selectedNodes.get(0)), view);
                        np = UmlUtils.getPointBeneathHeader(np, builder);
                        return new Rectangle(np.x - p.x, np.y - p.y, 0, 0);
                    }
                    Point sp = c.getLocationOnScreen();
                    return new Rectangle(sp.x - p.x + c.getWidth() / 3, sp.y - p.y + c.getHeight() * 3 / 7, 0, 0);
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    NodeCellEditor cellEditor = DiagramNodeEditorManager.getInstance().getCurrentCellEditor();
                    if (cellEditor != null) {
                        return DiagramNodeEditorManager.getInstance().getData(dataId);
                    }
                    return selectedNodes.stream().map(it -> {
                        Object element = it.getIdentifyingElement();
                        return element instanceof NavigatablePsiElement ? (NavigatablePsiElement)element : null;
                    }).filter(it -> it != null).toArray(NavigatablePsiElement[]::new);
                }
            }
        }
        return null;
    }

    @NotNull
    public DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = this.myBuilder;
        if (diagramBuilder == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(19);
        }
        return diagramBuilder;
    }

    @Nullable
    public Object getOriginalElement() {
        return this.myBuilder.getDataModel().getOriginalElement();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getOriginalVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    @NotNull
    public Collection<DocumentReference> getDocumentReferences() {
        List<DocumentReference> list = this.myDocumentReference == null ? Collections.emptyList() : Collections.singletonList(this.myDocumentReference);
        if (list == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myBuilder.getProvider());
    }

    @Deprecated
    @NotNull
    public static HintUpdateSupply createHintUpdateSupply(@NotNull JComponent canvasComponent) {
        if (canvasComponent == null) {
            UmlFileEditorImpl.$$$reportNull$$$0(23);
        }
        return new HintUpdateSupply(canvasComponent){

            @Nullable
            protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorState";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvasComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureViewBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalVirtualFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedForTheFirstTime";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditorListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createHintUpdateSupply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ThreadSafe
    private static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        @NotNull
        private final DiagramBuilder myBuilder;
        @NotNull
        private final VirtualFile myFile;
        private long myCount;

        private MyFileEditorManagerListener(@NotNull DiagramBuilder builder, @NotNull VirtualFile file) {
            if (builder == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            this.myBuilder = builder;
            this.myFile = file;
            this.myCount = this.getCount();
        }

        private long getCount() {
            return this.myBuilder.getDataModel().getModificationTracker().getModificationCount();
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            long newCount;
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (Comparing.equal((Object)event.getNewFile(), (Object)this.myFile) && this.myCount != (newCount = this.getCount())) {
                this.myCount = newCount;
                Project project = this.myBuilder.getProject();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)this.myBuilder.getProvider())) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> {
                            if (!Disposer.isDisposed((Disposable)this.myBuilder)) {
                                this.myBuilder.update(false, true);
                            }
                        });
                    } else {
                        this.myBuilder.update(false, true);
                    }
                }, project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ThreadSafe
    private final class MyGraphSelectionListener
    implements Graph2DSelectionListener,
    Disposable {
        @NotNull
        private final HintUpdateSupply supply;

        private MyGraphSelectionListener() {
            this.supply = this.createHintUpdateSupply(UmlFileEditorImpl.this.myBuilder.getView().getCanvasComponent());
        }

        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent _graph2DSelectionEvent) {
            if (_graph2DSelectionEvent == null) {
                MyGraphSelectionListener.$$$reportNull$$$0(0);
            }
            if (!this.supply.shouldUpdateHint()) {
                return;
            }
            for (Node node : GraphViewUtil.getSelectedNodes((Graph2D)UmlFileEditorImpl.this.myBuilder.getGraph())) {
                Object element;
                DiagramNode diagramNode = UmlFileEditorImpl.this.myBuilder.getNodeObject(node);
                if (diagramNode == null || !((element = diagramNode.getIdentifyingElement()) instanceof PsiElement)) continue;
                this.supply.updateHint((PsiElement)element);
                return;
            }
        }

        @NotNull
        private HintUpdateSupply createHintUpdateSupply(@NotNull JComponent canvasComponent) {
            if (canvasComponent == null) {
                MyGraphSelectionListener.$$$reportNull$$$0(1);
            }
            return new HintUpdateSupply(canvasComponent){

                @Nullable
                protected PsiElement getPsiElementForHint(@Nullable Object selectedValue) {
                    return null;
                }
            };
        }

        public void dispose() {
            UmlFileEditorImpl.this.myBuilder.getGraph().removeGraph2DSelectionListener((Graph2DSelectionListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_graph2DSelectionEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canvasComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyGraphSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onGraph2DSelectionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHintUpdateSupply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ThreadSafe
    private final class MyExternalChangeListener
    implements VirtualFileListener {
        private volatile boolean myDoHandleEvent = true;

        private MyExternalChangeListener() {
        }

        public void setDoHandleEvent(boolean doHandleEvent) {
            this.myDoHandleEvent = doHandleEvent;
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyExternalChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myDoHandleEvent && UmlFileEditorImpl.this.myFile.equals(event.getFile())) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        UmlFileEditorImpl.this.setUmlState(DiagramState.read((InputStream)UmlFileEditorImpl.this.myFile.getInputStream()));
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/uml/UmlFileEditorImpl$MyExternalChangeListener", "contentsChanged"));
        }
    }

    private final class MyDiagramListener
    implements DiagramActionsListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final MyExternalChangeListener myExternalListener;

        MyDiagramListener(@NotNull Project project, MyExternalChangeListener externalListener) {
            if (project == null) {
                MyDiagramListener.$$$reportNull$$$0(0);
            }
            if (externalListener == null) {
                MyDiagramListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myExternalListener = externalListener;
        }

        public void actionPerformed(@NotNull DiagramActionsListener.DiagramActionEvent event) {
            if (event == null) {
                MyDiagramListener.$$$reportNull$$$0(2);
            }
            if (event.getBuilder() == UmlFileEditorImpl.this.myBuilder) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        UndoUtil.forceUndoIn((VirtualFile)UmlFileEditorImpl.this.myFile, () -> ((DiagramState)UmlFileEditorImpl.this.getState(FileEditorStateLevel.FULL)).saveTo(UmlFileEditorImpl.this.myFile, this.myProject));
                    }
                    finally {
                        this.myExternalListener.setDoHandleEvent(true);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/UmlFileEditorImpl$MyDiagramListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

