/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.uml.EmptyDiagramProvider;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.UmlFileConverter;
import com.intellij.uml.utils.VcsUtils;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UmlEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    @NonNls
    public static final String TYPE_ID = "UmlEditorProvider";
    @NotNull
    private static final Logger LOG = Logger.getInstance(UmlEditorProvider.class);

    UmlEditorProvider() {
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        UmlVirtualFileSystem.UmlVirtualFile umlVirtualFile;
        DiagramProvider provider;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(1);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && "uml".equalsIgnoreCase(file.getExtension())) {
            if (UmlEditorProvider.isNewUmlFormat(file)) {
                return true;
            }
            if (UmlEditorProvider.isOldUmlFormat(file)) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return this.convertFile(project, file);
                }
                ApplicationManager.getApplication().invokeLater(() -> this.convertFile(project, file));
            }
            return false;
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile && (provider = (umlVirtualFile = (UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider()) != null) {
            if (DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)provider)) {
                return false;
            }
            return UmlEditorProvider.getElementFromFile(project, umlVirtualFile) != null || VcsUtils.isShowChangesFile(file);
        }
        return false;
    }

    private boolean convertFile(@NotNull Project project, @NotNull VirtualFile file) {
        Boolean success;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(3);
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DiagramBundle.message((String)"dialog.message.this.file.has.old.format.would.you.like.to.convert.it", (Object[])new Object[0]), (String)DiagramBundle.message((String)"dialog.title.old.diagram.format", (Object[])new Object[0]), (Icon)AllIcons.FileTypes.Diagram) == 0 && !(success = (Boolean)WriteAction.computeAndWait(() -> {
            try {
                VirtualFile copy = file.copy((Object)this, file.getParent(), file.getName() + ".bak.xml");
                PsiFile xml = PsiManager.getInstance((Project)project).findFile(copy);
                if (!(xml instanceof XmlFile)) {
                    return false;
                }
                XmlDocument xmlDoc = ((XmlFile)xml).getDocument();
                if (xmlDoc == null) {
                    return false;
                }
                Document doc = UmlFileConverter.convert(xmlDoc);
                boolean result = DiagramState.writeXml((VirtualFile)file, (Project)project, (Document)doc);
                copy.delete(null);
                return result;
            }
            catch (IOException iOException) {
                return false;
            }
        })).booleanValue()) {
            Messages.showErrorDialog((Project)project, (String)DiagramBundle.message((String)"dialog.message.can.t.save.converted.content.into.file.check.read.only.status", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return true;
        }
        return false;
    }

    private static boolean isNewUmlFormat(@NotNull VirtualFile file) {
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(4);
        }
        try {
            String beginning = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            return beginning.contains("<Diagramm>") || beginning.contains("<Diagram>");
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static boolean isOldUmlFormat(@NotNull VirtualFile file) {
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(5);
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file, (int)100).contains("<ClassDiagramm>");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Nullable
    private static Object getElementFromFile(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        Object result;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(7);
        }
        DiagramProvider umlProvider = file.getUmlProvider();
        String fileFqn = file.getFQN();
        Object object = result = umlProvider != null && fileFqn != null ? umlProvider.getVfsResolver().resolveElementByFQN(fileFqn, project) : null;
        if (result == null && umlProvider != null) {
            Object element = file.getUserData(DiagramProvider.ORIGINAL_ELEMENT);
            if (umlProvider.getElementManager().canBeBuiltFrom(element)) {
                if (!(element instanceof PsiElement)) {
                    return element;
                }
                PsiFile psiFile = ((PsiElement)element).getContainingFile();
                if (psiFile != null && ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) {
                    return element;
                }
            }
        }
        return result;
    }

    @Nullable
    public static DiagramProvider<?> getProviderFromFile(@NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        DiagramProvider umlProvider;
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(8);
        }
        if ((umlProvider = file.getUmlProvider()) != null) {
            try {
                Constructor<?> constructor = umlProvider.getClass().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (DiagramProvider)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor editor;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(10);
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            return UmlEditorProvider.createEditorFromPsiElement(project, (UmlVirtualFileSystem.UmlVirtualFile)file);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && (editor = UmlEditorProvider.createEditorFromLocalFileSystem(project, file)) != null) {
            FileEditor fileEditor = editor;
            if (fileEditor == null) {
                UmlEditorProvider.$$$reportNull$$$0(11);
            }
            return fileEditor;
        }
        return UmlEditorProvider.createUnknownDiagramEmptyEditor(project, file);
    }

    @Nullable
    private static FileEditor createEditorFromLocalFileSystem(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(13);
        }
        try {
            DiagramState state = DiagramState.read((InputStream)file.getInputStream());
            DiagramProvider provider = Objects.requireNonNull(DiagramProvider.findByID((String)state.getProviderID()));
            String originalFQN = state.getOriginalFQN();
            Object originalElement = originalFQN != null ? provider.getVfsResolver().resolveElementByFQN(originalFQN, project) : null;
            UmlGraphBuilder builder = (UmlGraphBuilder)((Object)WriteAction.computeAndWait(() -> UmlGraphBuilderFactory.create(project, provider, originalElement, file)));
            UmlFileEditorImpl editor = new UmlFileEditorImpl(builder, file);
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                editor.setUmlState(state);
                EdtScheduledExecutorService.getInstance().schedule(() -> state.restorePositionsOnlyTo(editor.getBuilder()), 1L, TimeUnit.SECONDS);
            });
            return editor;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static FileEditor createUnknownDiagramEmptyEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(15);
        }
        UmlGraphBuilder builder = (UmlGraphBuilder)((Object)WriteAction.computeAndWait(() -> UmlGraphBuilderFactory.create(project, (DiagramProvider)new EmptyDiagramProvider(), null, file)));
        return new UmlFileEditorImpl(builder, file);
    }

    @NotNull
    public static FileEditor createEditorFromPsiElement(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        UmlFileEditorImpl editor;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(16);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(17);
        }
        Object originalElement = UmlEditorProvider.getElementFromFile(project, file);
        DiagramProvider<?> providerFromFile = UmlEditorProvider.getProviderFromFile(file);
        Object provider = providerFromFile != null ? providerFromFile : new EmptyDiagramProvider();
        DiagramBuilder builder = UmlEditorProvider.getOrCreateBuilderForNewEditor(project, file, originalElement, provider);
        ReopenInfo.apply(file, builder, originalElement);
        if (originalElement != null) {
            file.setPresentableName(provider.getElementManager().getElementTitle(originalElement));
        }
        if ((editor = new UmlFileEditorImpl(builder, file)).isOpenedForTheFirstTime()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                builder.getDataModel().refreshDataModel();
                builder.update(false, true);
                builder.getGraphBuilder().fitContent();
            });
        }
        UmlFileEditorImpl umlFileEditorImpl = editor;
        if (umlFileEditorImpl == null) {
            UmlEditorProvider.$$$reportNull$$$0(18);
        }
        return umlFileEditorImpl;
    }

    @NotNull
    private static DiagramBuilder getOrCreateBuilderForNewEditor(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @Nullable Object originalElement, @NotNull DiagramProvider provider) {
        DiagramBuilder builderFromFile;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(19);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(20);
        }
        if (provider == null) {
            UmlEditorProvider.$$$reportNull$$$0(21);
        }
        if ((builderFromFile = file.getBuilder()) == null) {
            DiagramBuilder diagramBuilder = (DiagramBuilder)WriteAction.computeAndWait(() -> UmlGraphBuilderFactory.create(project, provider, originalElement, file));
            if (diagramBuilder == null) {
                UmlEditorProvider.$$$reportNull$$$0(22);
            }
            return diagramBuilder;
        }
        if (builderFromFile.getEditor() == null) {
            DiagramBuilder diagramBuilder = builderFromFile;
            if (diagramBuilder == null) {
                UmlEditorProvider.$$$reportNull$$$0(23);
            }
            return diagramBuilder;
        }
        DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> new UmlGraphBuilderFactory<Object>().createBuilderWithGivenDataModel(project, provider, builderFromFile.getDataModel(), originalElement, file));
        if (!ReopenInfo.isContains(file)) {
            ReopenInfo.apply(builderFromFile, builder, originalElement);
            ApplicationManager.getApplication().invokeLater(() -> {
                builder.update(false, true);
                builder.getGraphBuilder().fitContent();
            });
        }
        DiagramBuilder diagramBuilder = builder;
        if (diagramBuilder == null) {
            UmlEditorProvider.$$$reportNull$$$0(24);
        }
        return diagramBuilder;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            UmlEditorProvider.$$$reportNull$$$0(25);
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            UmlEditorProvider.$$$reportNull$$$0(26);
        }
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(27);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(28);
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            UmlEditorProvider.$$$reportNull$$$0(29);
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState editorState, @NotNull Project project, @NotNull Element element) {
        if (editorState == null) {
            UmlEditorProvider.$$$reportNull$$$0(30);
        }
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(31);
        }
        if (element == null) {
            UmlEditorProvider.$$$reportNull$$$0(32);
        }
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            UmlEditorProvider.$$$reportNull$$$0(33);
        }
        return fileEditorPolicy;
    }

    public static void saveUmlState(@NotNull FileEditorState editorState, @NotNull Element root) {
        if (editorState == null) {
            UmlEditorProvider.$$$reportNull$$$0(34);
        }
        if (root == null) {
            UmlEditorProvider.$$$reportNull$$$0(35);
        }
        if (editorState instanceof DiagramState) {
            ((DiagramState)editorState).write(root);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorState";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFromPsiElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuilderForNewEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNewUmlFormat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOldUmlFormat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProviderFromFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 33: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromLocalFileSystem";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUnknownDiagramEmptyEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromPsiElement";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuilderForNewEditor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disposeEditor";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "saveUmlState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

