/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
final class ReopenInfo {
    @NotNull
    private static final Key<ReopenInfo> KEY = Key.create((String)"UmlEditor.ReopenInfo");
    @Nullable
    private final String myCurrentVisibility;
    private final DiagramCategory @NotNull [] myCategories;
    @Nullable
    private final NamedScope myNamedScope;
    @Nullable
    private final Boolean myDoAllowEdgeCreation;
    @Nullable
    private final Boolean myDoShowDependencies;

    private ReopenInfo(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(0);
        }
        DiagramDataModel dataModel = builder.getDataModel();
        VisibilityLevel visibilityLevel = dataModel.getVisibilityManager().getCurrentVisibilityLevel();
        this.myCurrentVisibility = visibilityLevel != null ? visibilityLevel.getName() : null;
        DiagramNodeContentManager nodeContentManager = dataModel.getNodeContentManager();
        this.myCategories = builder.getPresentationModel().allowChangeVisibleCategories() ? nodeContentManager.getEnabledCategories() : DiagramCategory.EMPTY_ARRAY;
        this.myDoAllowEdgeCreation = builder.getProvider().getEdgeCreationPolicy() == null ? null : Boolean.valueOf(builder.doAllowEdgeCreation());
        DiagramScopeManager scopeManager = dataModel.getScopeManager();
        this.myNamedScope = scopeManager == null ? null : scopeManager.getCurrentScope();
        this.myDoShowDependencies = dataModel.isShowDependencies();
    }

    private void apply(@NotNull DiagramBuilder builder, @Nullable Object element) {
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(1);
        }
        DiagramDataModel dataModel = builder.getDataModel();
        DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
        visibilityManager.setCurrentVisibilityLevel((VisibilityLevel)ContainerUtil.find((Object[])visibilityManager.getVisibilityLevels(), it -> it.getName().equals(this.myCurrentVisibility)));
        DiagramNodeContentManager nodeContentManager = dataModel.getNodeContentManager();
        for (DiagramCategory category : this.myCategories) {
            nodeContentManager.setCategoryEnabled(category, true);
        }
        if (this.myDoAllowEdgeCreation != null) {
            builder.setAllowEdgeCreation(this.myDoAllowEdgeCreation.booleanValue());
        }
        dataModel.setupScopeManager(element, false);
        DiagramScopeManager scopeManager = dataModel.getScopeManager();
        if (scopeManager != null && this.myNamedScope != null) {
            scopeManager.setCurrentScope(this.myNamedScope);
        }
        if (this.myDoShowDependencies != null) {
            dataModel.setShowDependencies(this.myDoShowDependencies.booleanValue());
        }
    }

    public static void apply(@NotNull DiagramBuilder prevBuilder, @NotNull DiagramBuilder newBuilder, @Nullable Object element) {
        if (prevBuilder == null) {
            ReopenInfo.$$$reportNull$$$0(2);
        }
        if (newBuilder == null) {
            ReopenInfo.$$$reportNull$$$0(3);
        }
        new ReopenInfo(prevBuilder).apply(newBuilder, element);
    }

    public static void apply(@NotNull VirtualFile file, @NotNull DiagramBuilder builder, @Nullable Object element) {
        ReopenInfo info;
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(5);
        }
        if ((info = (ReopenInfo)KEY.get((UserDataHolder)file)) != null) {
            KEY.set((UserDataHolder)file, null);
            info.apply(builder, element);
        }
    }

    public static boolean isContains(@NotNull VirtualFile file) {
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(6);
        }
        return KEY.isIn((UserDataHolder)file);
    }

    public static void copyIfNeeded(@NotNull VirtualFile file, @NotNull DiagramBuilder builder) {
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(8);
        }
        if (Boolean.TRUE.equals(file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            KEY.set((UserDataHolder)file, (Object)new ReopenInfo(builder));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuilder";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/ReopenInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isContains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "copyIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

