/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.services;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.services.DockerContainerItem;
import com.intellij.docker.view.services.DockerImageItem;
import com.intellij.docker.view.services.DockerNewServiceContributor;
import com.intellij.docker.view.services.DockerRuntimeItemBase;
import com.intellij.docker.view.services.DockerServerContributor;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerServerItem
implements Disposable {
    private static final Logger LOG = DockerRuntimeItemBase.LOG;
    private final Project myProject;
    private final RemoteServer<?> myDocker;
    @Deprecated
    private DockerServerContributor myContributor;
    private MyContainersList myContainers;
    private MyImagesList myImages;
    private MessageBusConnection myMessageBusConnection;

    public DockerServerItem(@NotNull Project project, @NotNull RemoteServer<?> docker) {
        if (project == null) {
            DockerServerItem.$$$reportNull$$$0(0);
        }
        if (docker == null) {
            DockerServerItem.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDocker = docker;
        Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), (Disposable)this);
        this.myMessageBusConnection = project.getMessageBus().connect((Disposable)this);
        this.myMessageBusConnection.subscribe(DockerServerRuntimeInstance.EVENTS_TOPIC, this::onDockerEvent);
    }

    public void dispose() {
        this.myMessageBusConnection.disconnect();
        this.myMessageBusConnection = null;
    }

    void initContributor(@NotNull DockerServerContributor contributor) {
        if (contributor == null) {
            DockerServerItem.$$$reportNull$$$0(2);
        }
        assert (this.myContributor == null);
        this.myContributor = contributor;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DockerServerItem.$$$reportNull$$$0(3);
        }
        return project;
    }

    protected final boolean matchesServerRuntime(@NotNull DockerServerRuntimeInstance serverRuntime) {
        DockerCloudConfiguration actualConfig;
        ServerConfiguration expectedConfig;
        if (serverRuntime == null) {
            DockerServerItem.$$$reportNull$$$0(4);
        }
        return (expectedConfig = this.myDocker.getConfiguration()) == (actualConfig = serverRuntime.getConfiguration());
    }

    public boolean isConnected() {
        return this.myContainers != null;
    }

    public void connect() {
        if (this.isConnected()) {
            return;
        }
        ((CompletableFuture)DockerServerItem.promiseConnect(this.myDocker).thenAccept(this::onServerConnected)).exceptionally(ex -> {
            LOG.error(ex);
            return null;
        });
    }

    private void onServerConnected(@NotNull DockerServerRuntimeInstance serverRuntime) {
        List<DockerApplicationRuntime> allRuntimes;
        if (serverRuntime == null) {
            DockerServerItem.$$$reportNull$$$0(5);
        }
        try {
            allRuntimes = serverRuntime.getApplications().stream().map(o -> (DockerApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerApplicationRuntime.class)))).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (ServerRuntimeException e) {
            throw new CompletionException(e);
        }
        this.myContainers = new MyContainersList(this);
        this.myImages = new MyImagesList(this);
        this.myContainers.initFrom(allRuntimes);
        this.myImages.initFrom(allRuntimes);
        this.broadcast(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, (Object)this.myContributor, DockerNewServiceContributor.class));
    }

    @NotNull
    public List<DockerImageItem> getImages() {
        List<DockerImageItem> list = this.myImages == null ? Collections.emptyList() : this.myImages.listChildren();
        if (list == null) {
            DockerServerItem.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<DockerContainerItem> getContainers() {
        List<DockerContainerItem> list = this.myContainers == null ? Collections.emptyList() : this.myContainers.listChildren();
        if (list == null) {
            DockerServerItem.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    final RemoteServer<?> getDocker() {
        RemoteServer<?> remoteServer = this.myDocker;
        if (remoteServer == null) {
            DockerServerItem.$$$reportNull$$$0(8);
        }
        return remoteServer;
    }

    void broadcast(@NotNull ServiceEventListener.ServiceEvent serviceEvent) {
        if (serviceEvent == null) {
            DockerServerItem.$$$reportNull$$$0(9);
        }
        ((ServiceEventListener)this.getProject().getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(serviceEvent);
    }

    private void onDockerEvent(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event) {
        if (docker == null) {
            DockerServerItem.$$$reportNull$$$0(10);
        }
        if (event == null) {
            DockerServerItem.$$$reportNull$$$0(11);
        }
        if (!this.matchesServerRuntime(docker)) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        switch (event.getType()) {
            case CONTAINER: {
                this.myContainers.handleEvent(docker, event);
                break;
            }
            case IMAGE: {
                this.myImages.handleEvent(docker, event);
                break;
            }
        }
    }

    void forgetChild(@NotNull DockerRuntimeItemBase item) {
        if (item == null) {
            DockerServerItem.$$$reportNull$$$0(12);
        }
        if (item instanceof DockerImageItem) {
            this.myImages.removeChild((DockerImageItem)item);
        } else if (item instanceof DockerContainerItem) {
            this.myContainers.removeChild((DockerContainerItem)item);
        }
    }

    private static CompletableFuture<DockerServerRuntimeInstance> promiseConnect(RemoteServer<?> docker) {
        final CompletableFuture<DockerServerRuntimeInstance> promise = new CompletableFuture<DockerServerRuntimeInstance>();
        ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(docker);
        connection.connectIfNeeded((ServerConnector.ConnectionCallback)new ServerConnector.ConnectionCallback<DockerDeploymentConfiguration>(){

            public void connected(@NotNull ServerRuntimeInstance<DockerDeploymentConfiguration> serverRuntime) {
                if (serverRuntime == null) {
                    1.$$$reportNull$$$0(0);
                }
                promise.complete((DockerServerRuntimeInstance)serverRuntime);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                promise.completeExceptionally(new Exception(errorMessage));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntime";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/view/services/DockerServerItem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/services/DockerServerItem";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverRuntime";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceEvent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/services/DockerServerItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initContributor";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesServerRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onServerConnected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "broadcast";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onDockerEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forgetChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyImagesList
    extends ChildrenList<DockerImageItem> {
        MyImagesList(@NotNull DockerServerItem parent) {
            if (parent == null) {
                MyImagesList.$$$reportNull$$$0(0);
            }
            super(parent);
        }

        @Override
        @NotNull
        protected CompletableFuture<DockerApplicationRuntime> fetchRuntimeLater(@NotNull DockerServerRuntimeInstance docker, @NotNull String id) {
            if (docker == null) {
                MyImagesList.$$$reportNull$$$0(1);
            }
            if (id == null) {
                MyImagesList.$$$reportNull$$$0(2);
            }
            CompletableFuture<DockerApplicationRuntime> completableFuture = docker.findRuntimeLater(id, false);
            if (completableFuture == null) {
                MyImagesList.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }

        @Override
        @Nullable
        protected DockerImageItem createItem(@NotNull DockerApplicationRuntime runtime) {
            if (runtime == null) {
                MyImagesList.$$$reportNull$$$0(4);
            }
            if (runtime.getContainerId() != null || runtime.getImageId() == null) {
                return null;
            }
            return new DockerImageItem(this.getServerItem(), runtime);
        }

        @Override
        protected void handleEvent(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event) {
            String status;
            if (docker == null) {
                MyImagesList.$$$reportNull$$$0(5);
            }
            if (event == null) {
                MyImagesList.$$$reportNull$$$0(6);
            }
            if ((status = event.getStatus()) == null) {
                LOG.warn("Docker event without status: " + event);
                return;
            }
            switch (status) {
                case "pull": 
                case "import": 
                case "load": {
                    this.onChildCreated(docker, event);
                    break;
                }
                case "delete": {
                    this.onChildDeleted(docker, event);
                    break;
                }
                default: {
                    DockerImageItem child = (DockerImageItem)this.findItemForEvent(event);
                    if (child == null) break;
                    child.onImageChanged(docker, event);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/services/DockerServerItem$MyImagesList";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/services/DockerServerItem$MyImagesList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetchRuntimeLater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchRuntimeLater";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createItem";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEvent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyContainersList
    extends ChildrenList<DockerContainerItem> {
        MyContainersList(@NotNull DockerServerItem parent) {
            if (parent == null) {
                MyContainersList.$$$reportNull$$$0(0);
            }
            super(parent);
        }

        @Override
        @NotNull
        protected CompletableFuture<DockerApplicationRuntime> fetchRuntimeLater(@NotNull DockerServerRuntimeInstance docker, @NotNull String id) {
            if (docker == null) {
                MyContainersList.$$$reportNull$$$0(1);
            }
            if (id == null) {
                MyContainersList.$$$reportNull$$$0(2);
            }
            CompletableFuture<DockerApplicationRuntime> completableFuture = docker.findRuntimeLater(id, true);
            if (completableFuture == null) {
                MyContainersList.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }

        @Override
        @Nullable
        protected DockerContainerItem createItem(@NotNull DockerApplicationRuntime runtime) {
            if (runtime == null) {
                MyContainersList.$$$reportNull$$$0(4);
            }
            if (runtime.getContainerId() == null) {
                return null;
            }
            return new DockerContainerItem(this.getServerItem(), runtime);
        }

        @Override
        protected void handleEvent(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event) {
            String status;
            if (docker == null) {
                MyContainersList.$$$reportNull$$$0(5);
            }
            if (event == null) {
                MyContainersList.$$$reportNull$$$0(6);
            }
            if ((status = event.getStatus()) == null) {
                LOG.warn("Docker event without status: " + event);
                return;
            }
            switch (status) {
                case "create": {
                    this.onChildCreated(docker, event);
                    break;
                }
                case "destroy": {
                    this.onChildDeleted(docker, event);
                    break;
                }
                default: {
                    DockerContainerItem child = (DockerContainerItem)this.findItemForEvent(event);
                    if (child == null) break;
                    child.onContainerChanged(docker, event);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/services/DockerServerItem$MyContainersList";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/services/DockerServerItem$MyContainersList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetchRuntimeLater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchRuntimeLater";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createItem";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleEvent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ChildrenList<T extends DockerRuntimeItemBase> {
        private final ConcurrentMap<String, T> myMap;
        private final DockerServerItem myParent;

        ChildrenList(@NotNull DockerServerItem parent) {
            if (parent == null) {
                ChildrenList.$$$reportNull$$$0(0);
            }
            this.myMap = new ConcurrentHashMap<String, T>();
            this.myParent = parent;
        }

        void initFrom(@NotNull List<DockerApplicationRuntime> runtimes) {
            if (runtimes == null) {
                ChildrenList.$$$reportNull$$$0(1);
            }
            for (DockerApplicationRuntime next : runtimes) {
                T item = this.createItem(next);
                if (item == null) continue;
                this.myMap.put(((DockerRuntimeItemBase)item).getUniqueId(), item);
            }
        }

        @NotNull
        protected DockerServerItem getServerItem() {
            DockerServerItem dockerServerItem = this.myParent;
            if (dockerServerItem == null) {
                ChildrenList.$$$reportNull$$$0(2);
            }
            return dockerServerItem;
        }

        @NotNull
        protected abstract CompletableFuture<DockerApplicationRuntime> fetchRuntimeLater(@NotNull DockerServerRuntimeInstance var1, @NotNull String var2);

        @Nullable
        protected abstract T createItem(@NotNull DockerApplicationRuntime var1);

        protected abstract void handleEvent(@NotNull DockerServerRuntimeInstance var1, @NotNull DockerEvent var2);

        @NotNull
        List<T> listChildren() {
            ArrayList result = new ArrayList(this.myMap.values());
            result.sort(Comparator.comparing(DockerRuntimeItemBase::getPresentableName));
            ArrayList arrayList = result;
            if (arrayList == null) {
                ChildrenList.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        void removeChild(@Nullable T item) {
            if (item != null) {
                this.myMap.remove(((DockerRuntimeItemBase)item).getUniqueId());
                this.myParent.broadcast(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, item, DockerNewServiceContributor.class));
            }
        }

        protected void onChildDeleted(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event) {
            if (docker == null) {
                ChildrenList.$$$reportNull$$$0(4);
            }
            if (event == null) {
                ChildrenList.$$$reportNull$$$0(5);
            }
            T item = this.findItemForEvent(event);
            this.removeChild(item);
        }

        protected void onChildCreated(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event) {
            String newId;
            if (docker == null) {
                ChildrenList.$$$reportNull$$$0(6);
            }
            if (event == null) {
                ChildrenList.$$$reportNull$$$0(7);
            }
            if ((newId = event.getId()) == null) {
                LOG.warn("Docker `create` event without id: " + event);
                return;
            }
            Runnable fetchLater = () -> ((CompletableFuture)this.fetchRuntimeLater(docker, newId).thenAcceptAsync(newRuntime -> {
                if (newRuntime == null) {
                    LOG.warn("Can't find runtime for create event: " + event);
                } else {
                    T newItem = this.createItem((DockerApplicationRuntime)((Object)((Object)newRuntime)));
                    if (newItem != null) {
                        this.myMap.put(((DockerRuntimeItemBase)newItem).getUniqueId(), newItem);
                        this.myParent.broadcast(ServiceEventListener.ServiceEvent.createServiceAddedEvent(newItem, DockerNewServiceContributor.class, (Object)this.myParent));
                    }
                }
            })).exceptionally(ex -> DockerRuntimeItemBase.logException(event, ex));
            AppExecutorUtil.getAppScheduledExecutorService().schedule(fetchLater, 1L, TimeUnit.SECONDS);
        }

        @Nullable
        protected T findItemForEvent(@NotNull DockerEvent event) {
            String id;
            DockerRuntimeItemBase item;
            if (event == null) {
                ChildrenList.$$$reportNull$$$0(8);
            }
            if ((item = (DockerRuntimeItemBase)this.myMap.get(id = event.getId())) == null) {
                LOG.warn("Can't find item for id: " + id + ", event: " + event);
            }
            return (T)item;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtimes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/services/DockerServerItem$ChildrenList";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docker";
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/services/DockerServerItem$ChildrenList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "initFrom";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "onChildDeleted";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onChildCreated";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findItemForEvent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

