/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRuntimeEditorBase {
    private final String myName;
    private final ConfigApplier myOnSave;
    private JPanel myMainPanel;
    private JButton mySaveButton;

    public DockerRuntimeEditorBase(String name, ConfigApplier onSave) {
        this.myName = name;
        this.myOnSave = onSave;
    }

    protected final void initControls(JPanel mainPanel, JButton saveButton) {
        this.myMainPanel = mainPanel;
        this.myMainPanel.putClientProperty("DataProvider", dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return this.getContextHelpId();
            }
            return null;
        });
        this.mySaveButton = saveButton;
        this.mySaveButton.addActionListener(e -> this.save());
    }

    @Nullable
    protected String getContextHelpId() {
        return null;
    }

    private void save() {
        boolean applied;
        DockerAgentContainerConfig config = this.createConfig();
        if (config != null && (applied = this.myOnSave.applyNewConfig(config))) {
            UIUtil.setEnabled((Component)this.myMainPanel, (boolean)false, (boolean)true);
            this.mySaveButton.setText(DockerBundle.message("DockerRuntimeEditorBase.save.button.title", new Object[0]));
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public String getName() {
        return this.myName;
    }

    protected abstract DockerAgentContainerConfig createConfig();

    public static interface ConfigApplier {
        public boolean applyNewConfig(DockerAgentContainerConfig var1);
    }
}

