/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class DockerPortBindingRuntimeEditor
extends DockerTableRuntimeEditor<DockerPortBindingImpl> {
    private final JCheckBox myPublishAllPortsCheckBox;

    public DockerPortBindingRuntimeEditor(DockerAgentContainerConfig config, DockerRuntimeEditorBase.ConfigApplier onSave) {
        super(DockerBundle.message("DockerPortBindingRuntimeEditor.name", new Object[0]), new DockerPortBindingsEditor(), onSave);
        Object[] portBindings = config.getPortBindings();
        this.getEditor().setItems(ContainerUtil.map((Object[])(portBindings != null ? portBindings : new DockerPortBinding[]{}), binding -> new DockerPortBindingImpl(binding)));
        this.myPublishAllPortsCheckBox = new JCheckBox(DockerBundle.message("DockerPortBindingRuntimeEditor.publish.ports.checkbox.title", new Object[0]));
        this.getEditorPlaceholder().add((Component)this.myPublishAllPortsCheckBox, "North");
        this.myPublishAllPortsCheckBox.setSelected(config.isPublishAllPorts());
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerPortBindingRuntimeEditor.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    @Override
    protected DockerAgentContainerConfig createConfig(final List<DockerPortBindingImpl> items) {
        return new DockerAgentContainerConfig.Adapter(){

            public DockerPortBinding[] getPortBindings() {
                return items.toArray(new DockerPortBinding[0]);
            }

            public Boolean getPublishAllPorts() {
                return DockerPortBindingRuntimeEditor.this.myPublishAllPortsCheckBox.isSelected();
            }
        };
    }

    @Override
    @NotNull
    protected String getContextHelpId() {
        return "reference.docker.runtime.port-bindings";
    }

    private void updateVisibility() {
        this.getEditor().setEnabled(!this.myPublishAllPortsCheckBox.isSelected());
    }
}

